/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.internal.admin.authentication.LegacyToken;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.metadata.Member;
import com.linecorp.centraldogma.server.internal.metadata.PerRolePermissions;
import com.linecorp.centraldogma.server.internal.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.internal.metadata.ProjectRole;
import com.linecorp.centraldogma.server.internal.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.internal.metadata.RepositoryUtil;
import com.linecorp.centraldogma.server.internal.metadata.Token;
import com.linecorp.centraldogma.server.internal.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.internal.metadata.Tokens;
import com.linecorp.centraldogma.server.internal.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.project.SafeProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationUtil {
    private static final Logger logger = LoggerFactory.getLogger(MigrationUtil.class);
    static final String LEGACY_TOKEN_REPO = "tokens";
    static final String LEGACY_TOKEN_JSON = "/token.json";
    private static final TypeReference<Map<String, LegacyToken>> TOKEN_MAP_TYPE_REFERENCE = new TypeReference<Map<String, LegacyToken>>(){};
    private static final Author author = Author.SYSTEM;

    public static void migrate(ProjectManager projectManager, CommandExecutor executor) {
        MigrationUtil.migrate(projectManager, executor, false);
    }

    public static synchronized void migrate(ProjectManager projectManager, CommandExecutor executor, boolean force) {
        Objects.requireNonNull(projectManager, "projectManager");
        Objects.requireNonNull(executor, "executor");
        RepositoryUtil<ProjectMetadata> metadataRepo = new RepositoryUtil<ProjectMetadata>(projectManager, executor, entry -> RepositoryUtil.convertWithJackson(entry, ProjectMetadata.class));
        UserAndTimestamp userAndTimestamp = UserAndTimestamp.of(author);
        Entry<?> tokenEntry = ((Repository)((Project)projectManager.get("dogma")).repos().get("main")).getOrNull(Revision.HEAD, "/tokens.json").join();
        Collection<Token> migratedTokens = tokenEntry == null || force ? MigrationUtil.migrateTokens(projectManager, executor) : ImmutableSet.of();
        migratedTokens.forEach(token -> logger.info("Token '{}' has been migrated", (Object)token.id()));
        UserAndTimestamp creationTime = UserAndTimestamp.of(author);
        Map registrations = migratedTokens.stream().map(t -> new TokenRegistration(t.id(), ProjectRole.MEMBER, creationTime)).collect(Collectors.toMap(TokenRegistration::id, Function.identity()));
        SafeProjectManager safeProjectManager = new SafeProjectManager(projectManager);
        safeProjectManager.list().values().forEach(p -> {
            block3: {
                Revision revision = metadataRepo.normalize(p.metaRepo());
                Entry<?> metadataEntry = p.metaRepo().getOrNull(revision, "/metadata.json").join();
                if (metadataEntry == null || force) {
                    Map<String, RepositoryMetadata> repos = p.repos().list().values().stream().filter(r -> !r.name().equals("meta")).map(r -> new RepositoryMetadata(r.name(), userAndTimestamp, PerRolePermissions.ofPublic())).collect(Collectors.toMap(RepositoryMetadata::name, Function.identity()));
                    ProjectMetadata metadata = new ProjectMetadata(p.name(), repos, (Map<String, Member>)ImmutableMap.of(), registrations, userAndTimestamp, null);
                    try {
                        metadataRepo.push(p.name(), p.metaRepo().name(), author, "Add the metadata file", Change.ofJsonUpsert((String)"/metadata.json", (JsonNode)Jackson.valueToTree((Object)metadata))).toCompletableFuture().join();
                        logger.info("Project '{}' has been migrated", (Object)p.name());
                    }
                    catch (Throwable cause) {
                        cause = Exceptions.peel((Throwable)cause);
                        if (cause instanceof RedundantChangeException) break block3;
                        Exceptions.throwUnsafely((Throwable)cause);
                    }
                }
            }
        });
    }

    private static Collection<Token> migrateTokens(ProjectManager projectManager, CommandExecutor executor) {
        Map<String, Token> tokenMap;
        block2: {
            RepositoryUtil<Tokens> tokensRepo = new RepositoryUtil<Tokens>(projectManager, executor, entry -> RepositoryUtil.convertWithJackson(entry, Tokens.class));
            Project project = (Project)projectManager.get("dogma");
            Object legacyTokens = project.repos().exists(LEGACY_TOKEN_REPO) ? (Collection)((CompletableFuture)((Repository)project.repos().get(LEGACY_TOKEN_REPO)).getOrNull(Revision.HEAD, LEGACY_TOKEN_JSON).thenApply(entry -> {
                if (entry != null) {
                    return ((Map)Jackson.convertValue((Object)entry.content(), TOKEN_MAP_TYPE_REFERENCE)).values();
                }
                return ImmutableList.of();
            })).join() : ImmutableList.of();
            tokenMap = legacyTokens.stream().map(MigrationUtil::migrateToken).collect(Collectors.toMap(Token::id, Function.identity()));
            Map<String, String> secretMap = tokenMap.values().stream().collect(Collectors.toMap(Token::secret, Token::id));
            Change change = Change.ofJsonUpsert((String)"/tokens.json", (JsonNode)Jackson.valueToTree((Object)new Tokens(tokenMap, secretMap)));
            try {
                tokensRepo.push("dogma", "main", author, "Add the token list file", change).toCompletableFuture().join();
            }
            catch (Throwable cause) {
                cause = Exceptions.peel((Throwable)cause);
                if (cause instanceof RedundantChangeException) break block2;
                Exceptions.throwUnsafely((Throwable)cause);
            }
        }
        return tokenMap.values();
    }

    private static Token migrateToken(LegacyToken legacyToken) {
        return new Token(legacyToken.appId(), legacyToken.secret(), false, new UserAndTimestamp(legacyToken.creator().email(), legacyToken.creationTime()));
    }

    private MigrationUtil() {
    }
}

