/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.server.internal.storage.DirectoryBasedStorageManager;
import com.linecorp.centraldogma.server.internal.storage.project.DefaultProject;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.RepositoryCache;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class DefaultProjectManager
extends DirectoryBasedStorageManager<Project>
implements ProjectManager {
    @Nullable
    private final RepositoryCache cache = (RepositoryCache)this.childArg(1);

    public DefaultProjectManager(File rootDir, Executor repositoryWorker, @Nullable String cacheSpec) {
        super(rootDir, Project.class, Objects.requireNonNull(repositoryWorker, "repositoryWorker"), cacheSpec != null ? new RepositoryCache(cacheSpec) : null);
    }

    @Override
    public CacheStats cacheStats() {
        return this.cache != null ? this.cache.stats() : CacheStats.empty();
    }

    @Override
    public void close() {
        super.close();
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    protected Project openChild(File childDir, Object[] childArgs) throws Exception {
        return new DefaultProject(childDir, false, (Executor)childArgs[0], (RepositoryCache)childArgs[1]);
    }

    @Override
    protected Project createChild(File childDir, Object[] childArgs, long creationTimeMillis) throws Exception {
        return new DefaultProject(childDir, true, (Executor)childArgs[0], (RepositoryCache)childArgs[1]);
    }

    @Override
    protected void closeChild(File childDir, Project child) {
        DefaultProject c = (DefaultProject)child;
        c.repos.close();
    }

    @Override
    protected RuntimeException newStorageExistsException(String name) {
        return new ProjectExistsException(name);
    }

    @Override
    protected RuntimeException newStorageNotFoundException(String name) {
        return new ProjectNotFoundException(name);
    }
}

