/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.mirror.Mirror;
import com.linecorp.centraldogma.server.internal.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.internal.mirror.credential.MirrorCredential;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryWrapper;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultMetaRepository
extends RepositoryWrapper
implements MetaRepository {
    @VisibleForTesting
    static final String PATH_CREDENTIALS = "/credentials.json";
    @VisibleForTesting
    static final String PATH_MIRRORS = "/mirrors.json";
    private static final String PATH_CREDENTIALS_AND_MIRRORS = "/credentials.json,/mirrors.json";
    private final Lock mirrorLock = new ReentrantLock();
    private int mirrorRev = -1;
    private Set<String> mirrorRepos = Collections.emptySet();
    private Set<Mirror> mirrors;

    public DefaultMetaRepository(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Mirror> mirrors() {
        this.mirrorLock.lock();
        try {
            int headRev = this.normalizeNow(Revision.HEAD).major();
            Set<String> repos = this.parent().repos().list().keySet();
            if (headRev > this.mirrorRev || !this.mirrorRepos.equals(repos)) {
                this.mirrors = this.loadMirrors(headRev);
                this.mirrorRev = headRev;
                this.mirrorRepos = repos;
            }
            Set<Mirror> set = this.mirrors;
            return set;
        }
        finally {
            this.mirrorLock.unlock();
        }
    }

    private Set<Mirror> loadMirrors(int rev) {
        Map<String, Entry<?>> entries = this.find(new Revision(rev), PATH_CREDENTIALS_AND_MIRRORS, Collections.emptyMap()).join();
        if (!entries.containsKey(PATH_MIRRORS)) {
            return Collections.emptySet();
        }
        JsonNode mirrorsJson = (JsonNode)entries.get(PATH_MIRRORS).content();
        if (!mirrorsJson.isArray()) {
            throw new RepositoryMetadataException("/mirrors.json must be an array: " + mirrorsJson.getNodeType());
        }
        if (mirrorsJson.size() == 0) {
            return Collections.emptySet();
        }
        try {
            List<MirrorCredential> credentials = DefaultMetaRepository.loadCredentials(entries);
            ImmutableSet.Builder mirrors = ImmutableSet.builder();
            for (JsonNode m : mirrorsJson) {
                MirrorConfig c = (MirrorConfig)Jackson.treeToValue((TreeNode)m, MirrorConfig.class);
                if (c == null) {
                    throw new RepositoryMetadataException("/mirrors.json contains null.");
                }
                mirrors.addAll(c.toMirrors(this.parent(), credentials));
            }
            return mirrors.build();
        }
        catch (RepositoryMetadataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryMetadataException("failed to load the mirror configuration", e);
        }
    }

    private static List<MirrorCredential> loadCredentials(Map<String, Entry<?>> entries) throws Exception {
        Entry<?> e = entries.get(PATH_CREDENTIALS);
        if (e == null) {
            return Collections.emptyList();
        }
        JsonNode credentialsJson = (JsonNode)e.content();
        if (!credentialsJson.isArray()) {
            throw new RepositoryMetadataException("/credentials.json must be an array: " + credentialsJson.getNodeType());
        }
        if (credentialsJson.size() == 0) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonNode c : credentialsJson) {
            MirrorCredential credential = (MirrorCredential)Jackson.treeToValue((TreeNode)c, MirrorCredential.class);
            if (credential == null) {
                throw new RepositoryMetadataException("/credentials.json contains null.");
            }
            builder.add((Object)credential);
        }
        return builder.build();
    }

    private static final class MirrorInclude {
        final Pattern pattern;
        final String replacement;
        final MirrorDirection direction;
        final String localPath;
        final Cron schedule;

        @JsonCreator
        MirrorInclude(@JsonProperty(value="schedule") String schedule, @JsonProperty(value="pattern", required=true) Pattern pattern, @JsonProperty(value="replacement", required=true) String replacement, @JsonProperty(value="direction") MirrorDirection direction, @JsonProperty(value="localPath") String localPath) {
            this.schedule = schedule != null ? MirrorConfig.cronParser.parse(schedule) : null;
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.replacement = Objects.requireNonNull(replacement, "replacement");
            this.direction = direction;
            this.localPath = localPath;
        }
    }

    private static final class MultipleMirrorConfig
    extends MirrorConfig {
        final MirrorDirection defaultDirection;
        final String defaultLocalPath;
        final Cron defaultSchedule;
        final List<MirrorInclude> includes;
        final List<Pattern> excludes;

        @JsonCreator
        MultipleMirrorConfig(@JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="defaultSchedule") String defaultSchedule, @JsonProperty(value="defaultDirection", required=true) MirrorDirection defaultDirection, @JsonProperty(value="defaultLocalPath") String defaultLocalPath, @JsonProperty(value="includes", required=true) @JsonDeserialize(contentAs=MirrorInclude.class) Iterable<MirrorInclude> includes, @JsonProperty(value="excludes") @JsonDeserialize(contentAs=Pattern.class) Iterable<Pattern> excludes) {
            super((Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)true));
            this.defaultSchedule = cronParser.parse((String)MoreObjects.firstNonNull((Object)defaultSchedule, (Object)"0 * * * * ?"));
            this.defaultDirection = Objects.requireNonNull(defaultDirection, "defaultDirection");
            this.defaultLocalPath = (String)MoreObjects.firstNonNull((Object)defaultLocalPath, (Object)"/");
            this.includes = ImmutableList.copyOf((Iterable)Util.requireNonNullElements(includes, (String)"includes"));
            this.excludes = excludes != null ? ImmutableList.copyOf((Iterable)Util.requireNonNullElements(excludes, (String)"excludes")) : Collections.emptyList();
        }

        @Override
        List<Mirror> toMirrors(Project parent, Iterable<MirrorCredential> credentials) {
            if (!this.enabled) {
                return Collections.emptyList();
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            parent.repos().list().forEach((repoName, repo) -> {
                if (repoName == null || this.excludes.stream().anyMatch(p -> p.matcher((CharSequence)repoName).find())) {
                    return;
                }
                for (MirrorInclude i : this.includes) {
                    Matcher m = i.pattern.matcher((CharSequence)repoName);
                    if (!m.matches()) continue;
                    URI remoteUri = URI.create(m.replaceFirst(i.replacement));
                    builder.add((Object)Mirror.of((Cron)MoreObjects.firstNonNull((Object)i.schedule, (Object)this.defaultSchedule), (MirrorDirection)((Object)((Object)MoreObjects.firstNonNull((Object)((Object)i.direction), (Object)((Object)this.defaultDirection)))), MultipleMirrorConfig.findCredential(credentials, remoteUri), repo, (String)MoreObjects.firstNonNull((Object)i.localPath, (Object)this.defaultLocalPath), remoteUri));
                }
            });
            return builder.build();
        }
    }

    private static final class SingleMirrorConfig
    extends MirrorConfig {
        final MirrorDirection direction;
        final String localRepo;
        final String localPath;
        final URI remoteUri;
        final Cron schedule;

        @JsonCreator
        SingleMirrorConfig(@JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="schedule") String schedule, @JsonProperty(value="direction", required=true) MirrorDirection direction, @JsonProperty(value="localRepo", required=true) String localRepo, @JsonProperty(value="localPath") String localPath, @JsonProperty(value="remoteUri", required=true) URI remoteUri) {
            super((Boolean)MoreObjects.firstNonNull((Object)enabled, (Object)true));
            this.schedule = cronParser.parse((String)MoreObjects.firstNonNull((Object)schedule, (Object)"0 * * * * ?"));
            this.direction = Objects.requireNonNull(direction, "direction");
            this.localRepo = Objects.requireNonNull(localRepo, "localRepo");
            this.localPath = (String)MoreObjects.firstNonNull((Object)localPath, (Object)"/");
            this.remoteUri = Objects.requireNonNull(remoteUri, "remoteUri");
        }

        @Override
        List<Mirror> toMirrors(Project parent, Iterable<MirrorCredential> credentials) {
            if (!this.enabled || this.localRepo == null || !parent.repos().exists(this.localRepo)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Mirror.of(this.schedule, this.direction, SingleMirrorConfig.findCredential(credentials, this.remoteUri), (Repository)parent.repos().get(this.localRepo), this.localPath, this.remoteUri));
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=SingleMirrorConfig.class, name="single"), @JsonSubTypes.Type(value=MultipleMirrorConfig.class, name="multiple")})
    private static abstract class MirrorConfig {
        static final String DEFAULT_SCHEDULE = "0 * * * * ?";
        static final CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        final boolean enabled;

        abstract List<Mirror> toMirrors(Project var1, Iterable<MirrorCredential> var2);

        static MirrorCredential findCredential(Iterable<MirrorCredential> credentials, URI remoteUri) {
            MirrorCredential credential = MirrorCredential.FALLBACK;
            for (MirrorCredential c : credentials) {
                if (!c.matches(remoteUri)) continue;
                credential = c;
                break;
            }
            return credential;
        }

        MirrorConfig(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

