/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOption;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

final class RepositoryUtil {
    static final Map<FindOption<?>, Object> EXISTS_FIND_OPTIONS = new IdentityHashMap();
    static final Map<FindOption<?>, Object> GET_FIND_OPTIONS = new IdentityHashMap();
    private static final CancellationException CANCELLATION_EXCEPTION = (CancellationException)Exceptions.clearTrace((Throwable)new CancellationException("parent complete"));

    static <T> CompletableFuture<Entry<T>> watch(Repository repo, Revision lastKnownRev, Query<T> query) {
        Objects.requireNonNull(repo, "repo");
        Objects.requireNonNull(lastKnownRev, "lastKnownRev");
        Objects.requireNonNull(query, "query");
        Query castQuery = (Query)Util.unsafeCast(query);
        CompletableFuture parentFuture = new CompletableFuture();
        ((CompletableFuture)repo.getOrNull(lastKnownRev, castQuery).thenAccept(oldResult -> RepositoryUtil.watch(repo, (Query<Object>)castQuery, lastKnownRev, (Entry<Object>)oldResult, parentFuture))).exceptionally(Functions.voidFunction(parentFuture::completeExceptionally));
        return (CompletableFuture)Util.unsafeCast(parentFuture);
    }

    private static void watch(Repository repo, Query<Object> query, Revision lastKnownRev, @Nullable Entry<Object> oldResult, CompletableFuture<Entry<Object>> parentFuture) {
        CompletableFuture<Revision> future = repo.watch(lastKnownRev, query.path());
        parentFuture.whenComplete((res, cause) -> future.completeExceptionally(CANCELLATION_EXCEPTION));
        ((CompletableFuture)future.thenCompose(newRev -> repo.getOrNull((Revision)newRev, query).thenAccept(newResult -> {
            if (newResult == null || oldResult != null && Objects.equals(oldResult.content(), newResult.content())) {
                if (!parentFuture.isDone()) {
                    RepositoryUtil.watch(repo, query, newRev, oldResult, parentFuture);
                }
            } else {
                parentFuture.complete((Entry<Object>)newResult);
            }
        }))).exceptionally(Functions.voidFunction(parentFuture::completeExceptionally));
    }

    private RepositoryUtil() {
    }

    static {
        EXISTS_FIND_OPTIONS.put(FindOption.FETCH_CONTENT, false);
        EXISTS_FIND_OPTIONS.put(FindOption.MAX_ENTRIES, 1);
        GET_FIND_OPTIONS.put(FindOption.MAX_ENTRIES, 1);
    }
}

