/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOption;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableCall;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class CacheableFindCall
extends CacheableCall<Map<String, Entry<?>>> {
    final Revision revision;
    final String pathPattern;
    final Map<FindOption<?>, ?> options;
    private final int hashCode;

    CacheableFindCall(Repository repo, Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        super(repo);
        this.revision = Objects.requireNonNull(revision, "revision");
        this.pathPattern = Objects.requireNonNull(pathPattern, "pathPattern");
        this.options = Objects.requireNonNull(options, "options");
        this.hashCode = Objects.hash(pathPattern, options) * 31 + System.identityHashCode(repo);
        assert (!revision.isRelative());
    }

    @Override
    int weigh(Map<String, Entry<?>> value) {
        int weight = 0;
        weight += this.pathPattern.length();
        weight += this.options.size();
        for (Entry<?> e : value.values()) {
            String content;
            weight += e.path().length();
            if (!e.hasContent() || (content = e.contentAsText()) == null) continue;
            weight += content.length();
        }
        return weight;
    }

    @Override
    CompletableFuture<Map<String, Entry<?>>> execute() {
        return this.repo.find(this.revision, this.pathPattern, this.options);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableFindCall that = (CacheableFindCall)o;
        return this.revision.equals((Object)that.revision) && this.pathPattern.equals(that.pathPattern) && this.options.equals(that.options);
    }

    @Override
    void toString(MoreObjects.ToStringHelper helper) {
        helper.add("revision", (Object)this.revision).add("pathPattern", (Object)this.pathPattern).add("options", this.options);
    }
}

