/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceMode;
import com.linecorp.centraldogma.server.internal.storage.StorageException;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOption;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitIdDatabase;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitWatchers;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepositoryFormat;
import com.linecorp.centraldogma.server.internal.storage.repository.git.PathPatternFilter;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GitRepository
implements Repository {
    private static final Logger logger = LoggerFactory.getLogger(GitRepository.class);
    static final String R_HEADS_MASTER = "refs/heads/master";
    private static final byte[] EMPTY_BYTE = new byte[0];
    private static final Pattern CR = Pattern.compile("\r", 16);
    private final Lock writeLock = new ReentrantLock();
    private final Project parent;
    private final Executor repositoryWorker;
    private final String name;
    private final org.eclipse.jgit.lib.Repository jGitRepository;
    private final GitRepositoryFormat format;
    private final CommitIdDatabase commitIdDatabase;
    private final CommitWatchers commitWatchers = new CommitWatchers();
    private volatile Revision headRevision;

    GitRepository(Project parent, File repoDir, Executor repositoryWorker, long creationTimeMillis, Author author) {
        this(parent, repoDir, GitRepositoryFormat.V1, repositoryWorker, creationTimeMillis, author);
    }

    GitRepository(Project parent, File repoDir, GitRepositoryFormat format, Executor repositoryWorker, long creationTimeMillis, Author author) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.name = Objects.requireNonNull(repoDir, "repoDir").getName();
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.format = Objects.requireNonNull(format, "format");
        Objects.requireNonNull(author, "author");
        RepositoryBuilder repositoryBuilder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).setBare();
        boolean success = false;
        try {
            try (org.eclipse.jgit.lib.Repository initRepo = repositoryBuilder.build();){
                if (GitRepository.exist(repoDir)) {
                    throw new StorageException("failed to create a repository at: " + repoDir + " (exists already)");
                }
                initRepo.create(true);
                StoredConfig config = initRepo.getConfig();
                if (format == GitRepositoryFormat.V1) {
                    config.setInt("core", null, "repositoryformatversion", 1);
                }
                config.setEnum("core", null, "hidedotfiles", (Enum)CoreConfig.HideDotFiles.FALSE);
                config.setBoolean("core", null, "symlinks", false);
                config.setBoolean("core", null, "filemode", false);
                config.setString("diff", null, "algorithm", "histogram");
                config.setBoolean("diff", null, "renames", false);
                config.save();
            }
            this.jGitRepository = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).build();
            RefUpdate head = this.jGitRepository.updateRef("HEAD");
            head.disableRefLog();
            head.link(R_HEADS_MASTER);
            this.commitIdDatabase = new CommitIdDatabase(this.jGitRepository);
            this.commit0(null, Revision.INIT, creationTimeMillis, author, "Create a new repository", "", Markup.PLAINTEXT, Collections.emptyList(), true);
            this.headRevision = Revision.INIT;
            success = true;
        }
        catch (IOException e) {
            throw new StorageException("failed to create a repository at: " + repoDir, e);
        }
        finally {
            if (!success) {
                this.close();
                GitRepository.deleteCruft(repoDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GitRepository(Project parent, File repoDir, Executor repositoryWorker) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.name = Objects.requireNonNull(repoDir, "repoDir").getName();
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        RepositoryBuilder repositoryBuilder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).setBare();
        try {
            this.jGitRepository = repositoryBuilder.build();
            if (!GitRepository.exist(repoDir)) {
                throw new RepositoryNotFoundException(repoDir.toString());
            }
            int formatVersion = this.jGitRepository.getConfig().getInt("core", null, "repositoryformatversion", 0);
            switch (formatVersion) {
                case 0: {
                    this.format = GitRepositoryFormat.V0;
                    break;
                }
                case 1: {
                    this.format = GitRepositoryFormat.V1;
                    break;
                }
                default: {
                    throw new StorageException("unknown repository format version: " + formatVersion);
                }
            }
        }
        catch (IOException e) {
            throw new StorageException("failed to open a repository at: " + repoDir, e);
        }
        boolean success = false;
        try {
            this.headRevision = this.uncachedHeadRevision();
            this.commitIdDatabase = new CommitIdDatabase(this.jGitRepository);
            if (!this.headRevision.equals((Object)this.commitIdDatabase.headRevision())) {
                this.commitIdDatabase.rebuild(this.jGitRepository);
                assert (this.headRevision.equals((Object)this.commitIdDatabase.headRevision()));
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    private static boolean exist(File repoDir) {
        try {
            RepositoryBuilder repositoryBuilder = (RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir);
            org.eclipse.jgit.lib.Repository repository = repositoryBuilder.build();
            if (repository.getConfig() instanceof FileBasedConfig) {
                return ((FileBasedConfig)repository.getConfig()).getFile().exists();
            }
            return repository.getDirectory().exists();
        }
        catch (IOException e) {
            throw new StorageException("failed to check if repository exists at " + repoDir, e);
        }
    }

    void close() {
        if (this.commitIdDatabase != null) {
            this.commitIdDatabase.close();
        }
        if (this.jGitRepository != null) {
            try {
                this.jGitRepository.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close a Git repository: {}", (Object)this.jGitRepository.getDirectory(), (Object)e);
            }
        }
    }

    @Override
    public Project parent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.name;
    }

    public GitRepositoryFormat format() {
        return this.format;
    }

    public boolean needsMigration(GitRepositoryFormat preferredFormat) {
        if (this.format != preferredFormat) {
            return true;
        }
        if (!(this.jGitRepository.getRefDatabase() instanceof RefDirectory)) {
            return true;
        }
        File oldTagFile = new File(this.jGitRepository.getDirectory(), "refs" + File.separatorChar + "tags" + File.separatorChar + "01" + File.separatorChar + "1.0");
        return oldTagFile.exists();
    }

    @Override
    public Revision normalizeNow(Revision revision) {
        return GitRepository.normalizeNow(revision, this.cachedHeadRevision().major());
    }

    private static Revision normalizeNow(Revision revision, int baseMajor) {
        Objects.requireNonNull(revision, "revision");
        int major = revision.major();
        if (major >= 0 ? major > baseMajor : (major = baseMajor + major + 1) <= 0) {
            throw new RevisionNotFoundException(revision);
        }
        if (revision.major() == major) {
            return revision;
        }
        return new Revision(major);
    }

    @Override
    public RevisionRange normalizeNow(Revision from, Revision to) {
        int baseMajor = this.cachedHeadRevision().major();
        return new RevisionRange(GitRepository.normalizeNow(from, baseMajor), GitRepository.normalizeNow(to, baseMajor));
    }

    @Override
    public CompletableFuture<Map<String, Entry<?>>> find(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        return CompletableFuture.supplyAsync(() -> this.blockingFind(revision, pathPattern, options), this.repositoryWorker);
    }

    /*
     * Exception decompiling
     */
    private Map<String, Entry<?>> blockingFind(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CompletableFuture<List<Commit>> history(Revision from, Revision to, String pathPattern, int maxCommits) {
        return CompletableFuture.supplyAsync(() -> this.blockingHistory(from, to, pathPattern, maxCommits), this.repositoryWorker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Commit> blockingHistory(Revision from, Revision to, String pathPattern, int maxCommits) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        if (maxCommits <= 0) {
            throw new IllegalArgumentException("maxCommits: " + maxCommits + " (expected: > 0)");
        }
        RevisionRange range = this.normalizeNow(from, to);
        RevisionRange descendingRange = range.toDescending();
        ObjectId fromCommitId = this.commitIdDatabase.get(descendingRange.from());
        ObjectId toCommitId = this.commitIdDatabase.get(descendingRange.to());
        try (RevWalk revWalk = new RevWalk(this.jGitRepository);){
            revWalk.setTreeFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathPatternFilter.of(pathPattern)));
            revWalk.markStart(revWalk.parseCommit((AnyObjectId)fromCommitId));
            RevCommit toCommit = revWalk.parseCommit((AnyObjectId)toCommitId);
            if (toCommit.getParentCount() != 0) {
                revWalk.markUninteresting(toCommit.getParent(0));
            } else {
                revWalk.markUninteresting(toCommit);
            }
            ArrayList<Commit> commitList = new ArrayList<Commit>();
            boolean needsLastCommit = true;
            for (RevCommit revCommit : revWalk) {
                Commit c = GitRepository.toCommit(revCommit);
                if (c == null) continue;
                commitList.add(c);
                if (!revCommit.getId().equals((AnyObjectId)toCommitId) && commitList.size() != maxCommits) continue;
                needsLastCommit = false;
                break;
            }
            if (needsLastCommit && pathPattern.contains("/**")) {
                try (RevWalk tmpRevWalk = new RevWalk(this.jGitRepository);){
                    RevCommit lastRevCommit = tmpRevWalk.parseCommit((AnyObjectId)toCommitId);
                    Revision lastCommitRevision = CommitUtil.extractRevision(lastRevCommit.getFullMessage());
                    if (lastCommitRevision.major() == 1) {
                        commitList.add(GitRepository.toCommit(lastRevCommit));
                    }
                }
            }
            if (!descendingRange.equals((Object)range)) {
                Collections.reverse(commitList);
            }
            ArrayList<Commit> arrayList = commitList;
            return arrayList;
        }
        catch (CentralDogmaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException("failed to retrieve the history: " + this.jGitRepository + " (" + pathPattern + ", " + from + ".." + to + ')', e);
        }
    }

    private static Commit toCommit(RevCommit revCommit) {
        PersonIdent committerIdent = revCommit.getCommitterIdent();
        Author author = committerIdent == null ? Author.UNKNOWN : new Author(committerIdent.getName(), committerIdent.getEmailAddress());
        long when = committerIdent.getWhen().getTime();
        try {
            return CommitUtil.newCommit(author, when, revCommit.getFullMessage());
        }
        catch (Exception e) {
            throw new StorageException("failed to create a Commit", e);
        }
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> diff(Revision from, Revision to, String pathPattern) {
        return CompletableFuture.supplyAsync(() -> this.blockingDiff(from, to, pathPattern), this.repositoryWorker);
    }

    private Map<String, Change<?>> blockingDiff(Revision from, Revision to, String pathPattern) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        RevisionRange range = this.normalizeNow(from, to).toAscending();
        return this.toChangeMap(this.compareTrees(this.commitIdDatabase.get(range.from()), this.commitIdDatabase.get(range.to()), PathPatternFilter.of(pathPattern)));
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision baseRevision, Iterable<Change<?>> changes) {
        return CompletableFuture.supplyAsync(() -> this.blockingPreviewDiff(baseRevision, changes), this.repositoryWorker);
    }

    /*
     * Exception decompiling
     */
    private Map<String, Change<?>> blockingPreviewDiff(Revision baseRevision, Iterable<Change<?>> changes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Change<?>> toChangeMap(List<DiffEntry> diffEntryList) {
        try (ObjectReader reader = this.jGitRepository.newObjectReader();){
            LinkedHashMap changeMap = new LinkedHashMap();
            block24: for (DiffEntry diffEntry : diffEntryList) {
                String oldPath = '/' + diffEntry.getOldPath();
                String newPath = '/' + diffEntry.getNewPath();
                switch (diffEntry.getChangeType()) {
                    case MODIFY: {
                        EntryType oldEntryType = EntryType.guessFromPath((String)oldPath);
                        switch (oldEntryType) {
                            case JSON: {
                                JsonNode newJsonNode;
                                JsonNode oldJsonNode;
                                JsonPatch patch;
                                if (!oldPath.equals(newPath)) {
                                    GitRepository.putChange(changeMap, oldPath, Change.ofRename((String)oldPath, (String)newPath));
                                }
                                if ((patch = JsonPatch.generate((JsonNode)(oldJsonNode = Jackson.readTree((byte[])reader.open((AnyObjectId)diffEntry.getOldId().toObjectId()).getBytes())), (JsonNode)(newJsonNode = Jackson.readTree((byte[])reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes())), (ReplaceMode)ReplaceMode.SAFE)).isEmpty()) continue block24;
                                GitRepository.putChange(changeMap, newPath, Change.ofJsonPatch((String)newPath, (JsonNode)Jackson.valueToTree((Object)patch)));
                                continue block24;
                            }
                            case TEXT: {
                                String oldText = GitRepository.sanitizeText(new String(reader.open((AnyObjectId)diffEntry.getOldId().toObjectId()).getBytes(), StandardCharsets.UTF_8));
                                String newText = GitRepository.sanitizeText(new String(reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes(), StandardCharsets.UTF_8));
                                if (!oldPath.equals(newPath)) {
                                    GitRepository.putChange(changeMap, oldPath, Change.ofRename((String)oldPath, (String)newPath));
                                }
                                if (oldText.equals(newText)) continue block24;
                                GitRepository.putChange(changeMap, newPath, Change.ofTextPatch((String)newPath, (String)oldText, (String)newText));
                                continue block24;
                            }
                        }
                        throw new Error("unexpected old entry type: " + oldEntryType);
                    }
                    case ADD: {
                        EntryType newEntryType = EntryType.guessFromPath((String)newPath);
                        switch (newEntryType) {
                            case JSON: {
                                JsonNode jsonNode = Jackson.readTree((byte[])reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes());
                                GitRepository.putChange(changeMap, newPath, Change.ofJsonUpsert((String)newPath, (JsonNode)jsonNode));
                                continue block24;
                            }
                            case TEXT: {
                                String text = GitRepository.sanitizeText(new String(reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes(), StandardCharsets.UTF_8));
                                GitRepository.putChange(changeMap, newPath, Change.ofTextUpsert((String)newPath, (String)text));
                                continue block24;
                            }
                        }
                        throw new Error("unexpected new entry type: " + newEntryType);
                    }
                    case DELETE: {
                        GitRepository.putChange(changeMap, oldPath, Change.ofRemoval((String)oldPath));
                        continue block24;
                    }
                }
                throw new Error();
            }
            LinkedHashMap<String, Change<?>> linkedHashMap = changeMap;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw new StorageException("failed to convert list of DiffEntry to Changes map", e);
        }
    }

    private static void putChange(Map<String, Change<?>> changeMap, String path, Change<?> change) {
        Change<?> oldChange = changeMap.put(path, change);
        assert (oldChange == null);
    }

    @Override
    public CompletableFuture<Revision> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes) {
        return CompletableFuture.supplyAsync(() -> this.blockingCommit(baseRevision, commitTimeMillis, author, summary, detail, markup, changes, false), this.repositoryWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Revision blockingCommit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes, boolean allowEmptyCommit) {
        CommitResult res;
        Objects.requireNonNull(baseRevision, "baseRevision");
        this.writeLock.lock();
        try {
            Revision normBaseRevision = this.normalizeNow(baseRevision);
            Revision headRevision = this.cachedHeadRevision();
            if (headRevision.major() != normBaseRevision.major()) {
                throw new ChangeConflictException("invalid baseRevision: " + baseRevision + " (expected: " + headRevision + " or equivalent)");
            }
            res = this.commit0(headRevision, headRevision.forward(1), commitTimeMillis, author, summary, detail, markup, changes, allowEmptyCommit);
            this.headRevision = res.revision;
        }
        finally {
            this.writeLock.unlock();
        }
        this.notifyWatchers(res.revision, res.parentTreeId, res.treeId);
        return res.revision;
    }

    /*
     * Exception decompiling
     */
    private CommitResult commit0(Revision prevRevision, Revision nextRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes, boolean allowEmpty) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int applyChanges(Revision baseRevision, ObjectId baseTreeId, DirCache dirCache, Iterable<Change<?>> changes) {
        int numEdits = 0;
        try (final ObjectInserter inserter = this.jGitRepository.newObjectInserter();
             ObjectReader reader = this.jGitRepository.newObjectReader();){
            if (baseTreeId != null) {
                DirCacheBuilder builder = dirCache.builder();
                builder.addTree(EMPTY_BYTE, 0, reader, (AnyObjectId)baseTreeId);
                builder.finish();
            }
            for (Change<?> change : changes) {
                String changePath = change.path().substring(1);
                final DirCacheEntry oldEntry = dirCache.getEntry(changePath);
                byte[] oldContent = oldEntry != null ? reader.open((AnyObjectId)oldEntry.getObjectId()).getBytes() : null;
                switch (change.type()) {
                    case UPSERT_JSON: {
                        Object oldJsonNode = oldContent != null ? Jackson.readTree((byte[])oldContent) : null;
                        final JsonNode newJsonNode = (JsonNode)change.content();
                        if (newJsonNode.equals(oldJsonNode)) break;
                        GitRepository.applyPathEdit(dirCache, new DirCacheEditor.PathEdit(changePath){

                            public void apply(DirCacheEntry ent) {
                                ent.setFileMode(FileMode.REGULAR_FILE);
                                ent.setObjectId((AnyObjectId)GitRepository.newBlob(inserter, newJsonNode));
                            }
                        });
                        ++numEdits;
                        break;
                    }
                    case UPSERT_TEXT: {
                        String sanitizedOldText = oldContent != null ? GitRepository.sanitizeText(new String(oldContent, StandardCharsets.UTF_8)) : null;
                        final String sanitizedNewText = GitRepository.sanitizeText(change.contentAsText());
                        if (sanitizedNewText.equals(sanitizedOldText)) break;
                        GitRepository.applyPathEdit(dirCache, new DirCacheEditor.PathEdit(changePath){

                            public void apply(DirCacheEntry ent) {
                                ent.setFileMode(FileMode.REGULAR_FILE);
                                ent.setObjectId((AnyObjectId)GitRepository.newBlob(inserter, sanitizedNewText.getBytes(StandardCharsets.UTF_8)));
                            }
                        });
                        ++numEdits;
                        break;
                    }
                    case REMOVE: {
                        if (oldEntry != null) {
                            GitRepository.applyPathEdit(dirCache, (DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(changePath));
                            ++numEdits;
                            break;
                        }
                        if (GitRepository.applyDirectoryEdits(dirCache, changePath, null, change)) {
                            ++numEdits;
                            break;
                        }
                        GitRepository.reportNonExistentEntry(change);
                        break;
                    }
                    case RENAME: {
                        String newPath = ((String)change.content()).substring(1);
                        if (dirCache.getEntry(newPath) != null) {
                            throw new ChangeConflictException("a file exists at the target path: " + change);
                        }
                        if (oldEntry != null) {
                            if (changePath.equals(newPath)) break;
                            DirCacheEditor editor = dirCache.editor();
                            editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(changePath));
                            editor.add(new DirCacheEditor.PathEdit(newPath){

                                public void apply(DirCacheEntry ent) {
                                    ent.setFileMode(oldEntry.getFileMode());
                                    ent.setObjectId((AnyObjectId)oldEntry.getObjectId());
                                }
                            });
                            editor.finish();
                            ++numEdits;
                            break;
                        }
                        if (GitRepository.applyDirectoryEdits(dirCache, changePath, newPath, change)) {
                            ++numEdits;
                            break;
                        }
                        GitRepository.reportNonExistentEntry(change);
                        break;
                    }
                    case APPLY_JSON_PATCH: {
                        JsonNode newJsonNode;
                        Object oldJsonNode = oldContent != null ? Jackson.readTree((byte[])oldContent) : Jackson.nullNode;
                        try {
                            newJsonNode = JsonPatch.fromJson((JsonNode)((JsonNode)change.content())).apply(oldJsonNode);
                        }
                        catch (Exception e) {
                            throw new ChangeConflictException("failed to apply JSON patch: " + change, (Throwable)e);
                        }
                        if (newJsonNode.equals(oldJsonNode)) break;
                        GitRepository.applyPathEdit(dirCache, new DirCacheEditor.PathEdit(changePath){

                            public void apply(DirCacheEntry ent) {
                                ent.setFileMode(FileMode.REGULAR_FILE);
                                ent.setObjectId((AnyObjectId)GitRepository.newBlob(inserter, newJsonNode));
                            }
                        });
                        ++numEdits;
                        break;
                    }
                    case APPLY_TEXT_PATCH: {
                        String newText;
                        List sanitizedOldTextLines;
                        String sanitizedOldText;
                        Patch patch = DiffUtils.parseUnifiedDiff((List)Util.stringToLines((String)GitRepository.sanitizeText((String)change.content())));
                        if (oldContent != null) {
                            sanitizedOldText = GitRepository.sanitizeText(new String(oldContent, StandardCharsets.UTF_8));
                            sanitizedOldTextLines = Util.stringToLines((String)sanitizedOldText);
                        } else {
                            sanitizedOldText = null;
                            sanitizedOldTextLines = Collections.emptyList();
                        }
                        try {
                            List newTextLines = DiffUtils.patch(sanitizedOldTextLines, (Patch)patch);
                            if (newTextLines.isEmpty()) {
                                newText = "";
                            } else {
                                StringJoiner joiner = new StringJoiner("\n", "", "\n");
                                for (String line : newTextLines) {
                                    joiner.add(line);
                                }
                                newText = joiner.toString();
                            }
                        }
                        catch (Exception e) {
                            throw new ChangeConflictException("failed to apply text patch: " + change, (Throwable)e);
                        }
                        if (newText.equals(sanitizedOldText)) break;
                        GitRepository.applyPathEdit(dirCache, new DirCacheEditor.PathEdit(changePath){

                            public void apply(DirCacheEntry ent) {
                                ent.setFileMode(FileMode.REGULAR_FILE);
                                ent.setObjectId((AnyObjectId)GitRepository.newBlob(inserter, newText.getBytes(StandardCharsets.UTF_8)));
                            }
                        });
                        ++numEdits;
                    }
                }
            }
        }
        catch (CentralDogmaException | IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException("failed to apply changes on revision " + baseRevision, e);
        }
        return numEdits;
    }

    private static String sanitizeText(String text) {
        if (text.indexOf(13) >= 0) {
            text = CR.matcher(text).replaceAll("");
        }
        if (!text.isEmpty() && !text.endsWith("\n")) {
            text = text + "\n";
        }
        return text;
    }

    private static void reportNonExistentEntry(Change<?> change) {
        throw new ChangeConflictException("non-existent file/directory: " + change);
    }

    private static ObjectId newBlob(ObjectInserter inserter, JsonNode content) {
        try {
            return GitRepository.newBlob(inserter, Jackson.writeValueAsBytes((Object)content));
        }
        catch (IOException e) {
            throw new StorageException("failed to serialize a JSON value: " + content, e);
        }
    }

    private static ObjectId newBlob(ObjectInserter inserter, byte[] content) {
        ObjectId id;
        try {
            id = inserter.insert(3, content);
        }
        catch (IOException e) {
            throw new StorageException("failed to create a new blob", e);
        }
        return id;
    }

    private static void applyPathEdit(DirCache dirCache, DirCacheEditor.PathEdit edit) {
        DirCacheEditor e = dirCache.editor();
        e.add(edit);
        e.finish();
    }

    private static boolean applyDirectoryEdits(DirCache dirCache, String oldDir, String newDir, Change<?> change) {
        if (!oldDir.endsWith("/")) {
            oldDir = oldDir + '/';
        }
        if (newDir != null && !newDir.endsWith("/")) {
            newDir = newDir + '/';
        }
        byte[] rawOldDir = Constants.encode((String)oldDir);
        byte[] rawNewDir = newDir != null ? Constants.encode((String)newDir) : null;
        int numEntries = dirCache.getEntryCount();
        DirCacheEditor editor = null;
        block0: for (int i = 0; i < numEntries; ++i) {
            final DirCacheEntry e = dirCache.getEntry(i);
            byte[] rawPath = e.getRawPath();
            if (rawNewDir != null) {
                boolean conflict = true;
                if (rawPath.length > rawNewDir.length) {
                    for (int j = 0; j < rawNewDir.length; ++j) {
                        if (rawNewDir[j] == rawPath[j]) continue;
                        conflict = false;
                        break;
                    }
                } else if (rawPath.length == rawNewDir.length - 1) {
                    for (int j = 0; j < rawNewDir.length - 1; ++j) {
                        if (rawNewDir[j] == rawPath[j]) continue;
                        conflict = false;
                        break;
                    }
                } else {
                    conflict = false;
                }
                if (conflict) {
                    throw new ChangeConflictException("target directory exists already: " + change);
                }
            }
            if (rawPath.length <= rawOldDir.length) continue;
            for (int j = 0; j < rawOldDir.length; ++j) {
                if (rawOldDir[j] != rawPath[j]) continue block0;
            }
            if (editor == null) {
                editor = dirCache.editor();
                editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(oldDir));
                if (newDir == null) break;
            }
            assert (newDir != null);
            String oldPath = e.getPathString();
            String newPath = newDir + oldPath.substring(oldDir.length());
            editor.add(new DirCacheEditor.PathEdit(newPath){

                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(e.getFileMode());
                    ent.setObjectId((AnyObjectId)e.getObjectId());
                }
            });
        }
        if (editor != null) {
            editor.finish();
            return true;
        }
        return false;
    }

    private void doRefUpdate(RevWalk revWalk, String ref, ObjectId commitId) throws IOException {
        GitRepository.doRefUpdate(this.jGitRepository, revWalk, ref, commitId);
    }

    @VisibleForTesting
    static void doRefUpdate(org.eclipse.jgit.lib.Repository jGitRepository, RevWalk revWalk, String ref, ObjectId commitId) throws IOException {
        Ref oldRef;
        if (ref.startsWith("refs/tags/") && (oldRef = jGitRepository.exactRef(ref)) != null) {
            throw new StorageException("tag ref exists already: " + ref);
        }
        RefUpdate refUpdate = jGitRepository.updateRef(ref);
        refUpdate.setNewObjectId((AnyObjectId)commitId);
        RefUpdate.Result res = refUpdate.update(revWalk);
        switch (res) {
            case NEW: 
            case FAST_FORWARD: {
                break;
            }
            default: {
                throw new StorageException("unexpected refUpdate state: " + res);
            }
        }
    }

    @Override
    public CompletableFuture<Revision> watch(Revision lastKnownRevision, String pathPattern) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(this.repositoryWorker, "executor");
        CompletableFuture<Revision> future = new CompletableFuture<Revision>();
        ((CompletableFuture)this.normalize(lastKnownRevision).thenAccept(normLastKnownRevision -> {
            Revision headRevision = this.cachedHeadRevision();
            PathPatternFilter filter = PathPatternFilter.of(pathPattern);
            if (!normLastKnownRevision.equals((Object)headRevision) && this.hasMatchingChanges((Revision)normLastKnownRevision, headRevision, filter)) {
                future.complete(headRevision);
            } else {
                this.commitWatchers.add((Revision)normLastKnownRevision, filter, future);
            }
        })).exceptionally(cause -> {
            future.completeExceptionally((Throwable)cause);
            return null;
        });
        return future;
    }

    private boolean hasMatchingChanges(Revision from, Revision to, PathPatternFilter filter) {
        try (RevWalk revWalk = new RevWalk(this.jGitRepository);){
            List<DiffEntry> diff = this.compareTrees(this.toTreeId(revWalk, from), this.toTreeId(revWalk, to), TreeFilter.ALL);
            for (DiffEntry e : diff) {
                String path;
                switch (e.getChangeType()) {
                    case ADD: {
                        path = e.getNewPath();
                        break;
                    }
                    case MODIFY: 
                    case DELETE: {
                        path = e.getOldPath();
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
                if (!filter.matches(path)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void notifyWatchers(Revision newRevision, ObjectId prevTreeId, ObjectId nextTreeId) {
        List<DiffEntry> diff = this.compareTrees(prevTreeId, nextTreeId, TreeFilter.ALL);
        block4: for (DiffEntry e : diff) {
            switch (e.getChangeType()) {
                case ADD: {
                    this.commitWatchers.notify(newRevision, e.getNewPath());
                    continue block4;
                }
                case MODIFY: 
                case DELETE: {
                    this.commitWatchers.notify(newRevision, e.getOldPath());
                    continue block4;
                }
            }
            throw new Error();
        }
    }

    private Revision cachedHeadRevision() {
        return this.headRevision;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Revision uncachedHeadRevision() {
        try (RevWalk revWalk = new RevWalk(this.jGitRepository);){
            ObjectId headRevisionId = this.jGitRepository.resolve(R_HEADS_MASTER);
            if (headRevisionId == null) throw new StorageException("failed to determine the HEAD: " + this.jGitRepository.getDirectory());
            RevCommit revCommit = revWalk.parseCommit((AnyObjectId)headRevisionId);
            Revision revision = CommitUtil.extractRevision(revCommit.getFullMessage());
            return revision;
        }
        catch (CentralDogmaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException("failed to get the current revision", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DiffEntry> compareTrees(ObjectId prevTreeId, ObjectId nextTreeId, TreeFilter filter) {
        try (DiffFormatter diffFormatter = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);){
            diffFormatter.setRepository(this.jGitRepository);
            diffFormatter.setPathFilter(filter);
            List list = diffFormatter.scan((AnyObjectId)prevTreeId, (AnyObjectId)nextTreeId);
            return list;
        }
        catch (IOException e) {
            throw new StorageException("failed to compare two trees: " + prevTreeId + " vs. " + nextTreeId, e);
        }
    }

    private ObjectId toTreeId(RevWalk revWalk, Revision revision) {
        ObjectId commitId = this.commitIdDatabase.get(revision);
        try {
            return revWalk.parseCommit((AnyObjectId)commitId).getTree().getId();
        }
        catch (IOException e) {
            throw new StorageException("failed to parse a commit: " + commitId, e);
        }
    }

    public void cloneTo(File newRepoDir) {
        this.cloneTo(newRepoDir, GitRepositoryFormat.V1);
    }

    public void cloneTo(File newRepoDir, BiConsumer<Integer, Integer> progressListener) {
        this.cloneTo(newRepoDir, GitRepositoryFormat.V1, progressListener);
    }

    public void cloneTo(File newRepoDir, GitRepositoryFormat format) {
        this.cloneTo(newRepoDir, format, (current, total) -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneTo(File newRepoDir, GitRepositoryFormat format, BiConsumer<Integer, Integer> progressListener) {
        Objects.requireNonNull(newRepoDir, "newRepoDir");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(progressListener, "progressListener");
        Revision endRevision = this.normalizeNow(Revision.HEAD);
        GitRepository newRepo = new GitRepository(this.parent, newRepoDir, format, this.repositoryWorker, this.creationTimeMillis(), this.author());
        progressListener.accept(1, endRevision.major());
        boolean success = false;
        try {
            Revision previousNonEmptyRevision = null;
            int i = 2;
            while (i <= endRevision.major()) {
                int batch = 16;
                List<Commit> commits = this.blockingHistory(new Revision(i), new Revision(Math.min(endRevision.major(), i + 16 - 1)), "/**", 16);
                Preconditions.checkState((!commits.isEmpty() ? 1 : 0) != 0, (Object)"empty commits");
                if (previousNonEmptyRevision == null) {
                    previousNonEmptyRevision = commits.get(0).revision().backward(1);
                }
                for (Commit c : commits) {
                    Revision revision = c.revision();
                    Preconditions.checkState((revision.major() == i ? 1 : 0) != 0, (String)"mismatching revision: %s (expected: %s)", (int)revision.major(), (int)i);
                    Revision baseRevision = revision.backward(1);
                    Collection<Change<?>> changes = this.blockingDiff(previousNonEmptyRevision, revision, "/**").values();
                    try {
                        newRepo.blockingCommit(baseRevision, c.when(), c.author(), c.summary(), c.detail(), c.markup(), changes, false);
                        previousNonEmptyRevision = revision;
                    }
                    catch (RedundantChangeException e) {
                        newRepo.blockingCommit(baseRevision, c.when(), c.author(), c.summary(), c.detail(), c.markup(), changes, true);
                    }
                    progressListener.accept(i, endRevision.major());
                    ++i;
                }
            }
            success = true;
        }
        finally {
            newRepo.close();
            if (!success) {
                GitRepository.deleteCruft(newRepoDir);
            }
        }
    }

    private static void deleteCruft(File repoDir) {
        try {
            Util.deleteFileTree((File)repoDir);
        }
        catch (IOException e) {
            logger.error("Failed to delete a half-created repository at: {}", (Object)repoDir, (Object)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dir", (Object)this.jGitRepository.getDirectory()).add("format", (Object)this.format).toString();
    }

    private static final class CommitResult {
        final Revision revision;
        final ObjectId parentTreeId;
        final ObjectId treeId;

        CommitResult(Revision revision, ObjectId parentTreeId, ObjectId treeId) {
            this.revision = revision;
            this.parentTreeId = parentTreeId;
            this.treeId = treeId;
        }
    }
}

