/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.GracefulShutdownTimeout;
import com.linecorp.centraldogma.server.ReplicationConfig;
import com.linecorp.centraldogma.server.TlsConfig;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.RepositoryCache;
import io.netty.util.NetUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

final class CentralDogmaConfig {
    private final File dataDir;
    private final List<ServerPort> ports;
    private final Integer numWorkers;
    private final Integer maxNumConnections;
    private final Long requestTimeoutMillis;
    private final Long idleTimeoutMillis;
    private final Integer maxFrameLength;
    private final TlsConfig tls;
    private final Integer numRepositoryWorkers;
    private final String repositoryCacheSpec;
    private final String sessionCacheSpec;
    private final boolean webAppEnabled;
    private final long webAppSessionTimeoutMillis;
    private final boolean mirroringEnabled;
    private final int numMirroringThreads;
    private final int maxNumFilesPerMirror;
    private final long maxNumBytesPerMirror;
    private final GracefulShutdownTimeout gracefulShutdownTimeout;
    private final ReplicationConfig replicationConfig;
    private final boolean securityEnabled;
    private final boolean csrfTokenRequiredForThrift;
    private final String accessLogFormat;
    private final Set<String> administrators;
    private final boolean caseSensitiveLoginNames;

    CentralDogmaConfig(@JsonProperty(value="dataDir", required=true) File dataDir, @JsonProperty(value="ports", required=true) @JsonDeserialize(contentUsing=ServerPortDeserializer.class) List<ServerPort> ports, @JsonProperty(value="tls") TlsConfig tls, @JsonProperty(value="numWorkers") Integer numWorkers, @JsonProperty(value="maxNumConnections") Integer maxNumConnections, @JsonProperty(value="requestTimeoutMillis") Long requestTimeoutMillis, @JsonProperty(value="idleTimeoutMillis") Long idleTimeoutMillis, @JsonProperty(value="maxFrameLength") Integer maxFrameLength, @JsonProperty(value="numRepositoryWorkers") Integer numRepositoryWorkers, @JsonProperty(value="cacheSpec") String cacheSpec, @JsonProperty(value="repositoryCacheSpec") String repositoryCacheSpec, @JsonProperty(value="sessionCacheSpec") String sessionCacheSpec, @JsonProperty(value="gracefulShutdownTimeout") GracefulShutdownTimeout gracefulShutdownTimeout, @JsonProperty(value="webAppEnabled") Boolean webAppEnabled, @JsonProperty(value="webAppSessionTimeoutMillis") Long webAppSessionTimeoutMillis, @JsonProperty(value="mirroringEnabled") Boolean mirroringEnabled, @JsonProperty(value="numMirroringThreads") Integer numMirroringThreads, @JsonProperty(value="maxNumFilesPerMirror") Integer maxNumFilesPerMirror, @JsonProperty(value="maxNumBytesPerMirror") Long maxNumBytesPerMirror, @JsonProperty(value="replication") ReplicationConfig replicationConfig, @JsonProperty(value="securityEnabled") Boolean securityEnabled, @JsonProperty(value="csrfTokenRequiredForThrift") Boolean csrfTokenRequiredForThrift, @JsonProperty(value="accessLogFormat") String accessLogFormat, @JsonProperty(value="administrators") Set<String> administrators, @JsonProperty(value="caseSensitiveLoginNames") Boolean caseSensitiveLoginNames) {
        this.dataDir = Objects.requireNonNull(dataDir, "dataDir");
        this.ports = ImmutableList.copyOf((Collection)Objects.requireNonNull(ports, "ports"));
        Preconditions.checkArgument((!ports.isEmpty() ? 1 : 0) != 0, (Object)"ports must have at least one port.");
        this.tls = tls;
        this.numWorkers = numWorkers;
        this.maxNumConnections = maxNumConnections;
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.maxFrameLength = maxFrameLength;
        this.numRepositoryWorkers = (Integer)MoreObjects.firstNonNull((Object)numRepositoryWorkers, (Object)16);
        Preconditions.checkArgument((this.numRepositoryWorkers > 0 ? 1 : 0) != 0, (String)"numRepositoryWorkers: %s (expected: > 0)", (Object)this.numRepositoryWorkers);
        this.repositoryCacheSpec = repositoryCacheSpec != null ? RepositoryCache.validateCacheSpec(repositoryCacheSpec) : RepositoryCache.validateCacheSpec((String)MoreObjects.firstNonNull((Object)cacheSpec, (Object)"maximumWeight=134217728,expireAfterAccess=5m"));
        this.sessionCacheSpec = RepositoryCache.validateCacheSpec((String)MoreObjects.firstNonNull((Object)sessionCacheSpec, (Object)"maximumSize=8192,expireAfterWrite=604800s"));
        this.webAppEnabled = (Boolean)MoreObjects.firstNonNull((Object)webAppEnabled, (Object)true);
        this.webAppSessionTimeoutMillis = (Long)MoreObjects.firstNonNull((Object)webAppSessionTimeoutMillis, (Object)604800000L);
        Preconditions.checkArgument((this.webAppSessionTimeoutMillis > 0L ? 1 : 0) != 0, (String)"webAppSessionTimeoutMillis: %s (expected: > 0)", (long)this.webAppSessionTimeoutMillis);
        this.mirroringEnabled = (Boolean)MoreObjects.firstNonNull((Object)mirroringEnabled, (Object)true);
        this.numMirroringThreads = (Integer)MoreObjects.firstNonNull((Object)numMirroringThreads, (Object)16);
        Preconditions.checkArgument((this.numMirroringThreads > 0 ? 1 : 0) != 0, (String)"numMirroringThreads: %s (expected: > 0)", (int)this.numMirroringThreads);
        this.maxNumFilesPerMirror = (Integer)MoreObjects.firstNonNull((Object)maxNumFilesPerMirror, (Object)8192);
        Preconditions.checkArgument((this.maxNumFilesPerMirror > 0 ? 1 : 0) != 0, (String)"maxNumFilesPerMirror: %s (expected: > 0)", (int)this.maxNumFilesPerMirror);
        this.maxNumBytesPerMirror = (Long)MoreObjects.firstNonNull((Object)maxNumBytesPerMirror, (Object)0x2000000L);
        Preconditions.checkArgument((this.maxNumBytesPerMirror > 0L ? 1 : 0) != 0, (String)"maxNumBytesPerMirror: %s (expected: > 0)", (long)this.maxNumBytesPerMirror);
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        this.replicationConfig = (ReplicationConfig)MoreObjects.firstNonNull((Object)replicationConfig, (Object)ReplicationConfig.NONE);
        this.securityEnabled = (Boolean)MoreObjects.firstNonNull((Object)securityEnabled, (Object)false);
        this.csrfTokenRequiredForThrift = (Boolean)MoreObjects.firstNonNull((Object)csrfTokenRequiredForThrift, (Object)true);
        this.accessLogFormat = accessLogFormat;
        this.administrators = administrators != null ? ImmutableSet.copyOf(administrators) : ImmutableSet.of();
        this.caseSensitiveLoginNames = (Boolean)MoreObjects.firstNonNull((Object)caseSensitiveLoginNames, (Object)false);
    }

    @JsonProperty
    File dataDir() {
        return this.dataDir;
    }

    @JsonProperty
    @JsonSerialize(contentUsing=ServerPortSerializer.class)
    List<ServerPort> ports() {
        return this.ports;
    }

    @Nullable
    @JsonProperty
    TlsConfig tls() {
        return this.tls;
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    Optional<Integer> numWorkers() {
        return Optional.ofNullable(this.numWorkers);
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    Optional<Integer> maxNumConnections() {
        return Optional.ofNullable(this.maxNumConnections);
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    Optional<Long> requestTimeoutMillis() {
        return Optional.ofNullable(this.requestTimeoutMillis);
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    Optional<Long> idleTimeoutMillis() {
        return Optional.ofNullable(this.idleTimeoutMillis);
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    Optional<Integer> maxFrameLength() {
        return Optional.ofNullable(this.maxFrameLength);
    }

    @JsonProperty
    int numRepositoryWorkers() {
        return this.numRepositoryWorkers;
    }

    @JsonProperty
    @Deprecated
    String cacheSpec() {
        return this.repositoryCacheSpec;
    }

    @JsonProperty
    String repositoryCacheSpec() {
        return this.repositoryCacheSpec;
    }

    @JsonProperty
    String sessionCacheSpec() {
        return this.sessionCacheSpec;
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    Optional<GracefulShutdownTimeout> gracefulShutdownTimeout() {
        return Optional.ofNullable(this.gracefulShutdownTimeout);
    }

    @JsonProperty
    boolean isWebAppEnabled() {
        return this.webAppEnabled;
    }

    @JsonProperty
    long webAppSessionTimeoutMillis() {
        return this.webAppSessionTimeoutMillis;
    }

    @JsonProperty
    boolean isMirroringEnabled() {
        return this.mirroringEnabled;
    }

    @JsonProperty
    int numMirroringThreads() {
        return this.numMirroringThreads;
    }

    @JsonProperty
    int maxNumFilesPerMirror() {
        return this.maxNumFilesPerMirror;
    }

    @JsonProperty
    long maxNumBytesPerMirror() {
        return this.maxNumBytesPerMirror;
    }

    @JsonProperty(value="replication")
    ReplicationConfig replicationConfig() {
        return this.replicationConfig;
    }

    @JsonProperty
    boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @JsonProperty
    boolean isCsrfTokenRequiredForThrift() {
        return this.csrfTokenRequiredForThrift;
    }

    @JsonProperty
    String accessLogFormat() {
        return this.accessLogFormat;
    }

    @JsonProperty
    Set<String> administrators() {
        return this.administrators;
    }

    @JsonProperty
    boolean caseSensitiveLoginNames() {
        return this.caseSensitiveLoginNames;
    }

    public String toString() {
        try {
            return Jackson.writeValueAsPrettyString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    static final class OptionalConverter
    extends StdConverter<Optional<?>, Object> {
        OptionalConverter() {
        }

        public Object convert(Optional<?> value) {
            return value.orElse(null);
        }
    }

    static final class ServerPortDeserializer
    extends JsonDeserializer<ServerPort> {
        ServerPortDeserializer() {
        }

        public ServerPort deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            JsonNode root = (JsonNode)p.getCodec().readTree(p);
            JsonNode localAddress = root.get("localAddress");
            if (localAddress == null || localAddress.getNodeType() != JsonNodeType.OBJECT) {
                return ServerPortDeserializer.fail(ctx, root);
            }
            JsonNode host = localAddress.get("host");
            if (host == null || host.getNodeType() != JsonNodeType.STRING) {
                return ServerPortDeserializer.fail(ctx, root);
            }
            JsonNode port = localAddress.get("port");
            if (port == null || port.getNodeType() != JsonNodeType.NUMBER) {
                return ServerPortDeserializer.fail(ctx, root);
            }
            ImmutableSet.Builder protocolsBuilder = ImmutableSet.builder();
            JsonNode protocols = root.get("protocols");
            if (protocols != null) {
                if (protocols.getNodeType() != JsonNodeType.ARRAY) {
                    return ServerPortDeserializer.fail(ctx, root);
                }
                protocols.elements().forEachRemaining(protocol -> protocolsBuilder.add((Object)SessionProtocol.of((String)protocol.textValue())));
            } else {
                JsonNode protocol2 = root.get("protocol");
                if (protocol2 == null || protocol2.getNodeType() != JsonNodeType.STRING) {
                    return ServerPortDeserializer.fail(ctx, root);
                }
                protocolsBuilder.add((Object)SessionProtocol.of((String)protocol2.textValue()));
            }
            String hostVal = host.textValue();
            int portVal = port.intValue();
            InetSocketAddress localAddressVal = "*".equals(hostVal) ? new InetSocketAddress(portVal) : new InetSocketAddress(hostVal, portVal);
            return new ServerPort(localAddressVal, (Iterable)protocolsBuilder.build());
        }

        private static ServerPort fail(DeserializationContext ctx, JsonNode root) throws JsonMappingException {
            ctx.reportInputMismatch(ServerPort.class, "invalid server port information: %s", new Object[]{root});
            throw new Error();
        }
    }

    static final class ServerPortSerializer
    extends JsonSerializer<ServerPort> {
        ServerPortSerializer() {
        }

        public void serialize(ServerPort value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String hs;
            InetSocketAddress localAddr = value.localAddress();
            int port = localAddr.getPort();
            String host = localAddr.getAddress().isAnyLocalAddress() ? "*" : (NetUtil.isValidIpV6Address((String)(hs = localAddr.getHostString())) ? NetUtil.toAddressString((InetAddress)localAddr.getAddress()) : hs);
            gen.writeStartObject();
            gen.writeObjectFieldStart("localAddress");
            gen.writeStringField("host", host);
            gen.writeNumberField("port", port);
            gen.writeEndObject();
            gen.writeArrayFieldStart("protocols");
            for (SessionProtocol protocol : value.protocols()) {
                gen.writeString(protocol.uriText());
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }
}

