/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.authentication;

import com.google.common.annotations.VisibleForTesting;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.server.internal.admin.authentication.User;
import io.netty.util.AttributeKey;
import java.util.Objects;

public final class AuthenticationUtil {
    @VisibleForTesting
    public static final AttributeKey<User> CURRENT_USER_KEY = AttributeKey.valueOf(AuthenticationUtil.class, (String)"CURRENT_USER");

    public static Author currentAuthor(ServiceRequestContext ctx) {
        User user = (User)ctx.attr(CURRENT_USER_KEY).get();
        assert (user != null);
        return user == User.DEFAULT ? Author.DEFAULT : new Author(user.name(), user.email());
    }

    public static Author currentAuthor() {
        return AuthenticationUtil.currentAuthor((ServiceRequestContext)RequestContext.current());
    }

    public static User currentUser(ServiceRequestContext ctx) {
        return (User)ctx.attr(CURRENT_USER_KEY).get();
    }

    public static User currentUser() {
        return AuthenticationUtil.currentUser((ServiceRequestContext)RequestContext.current());
    }

    public static void setCurrentUser(ServiceRequestContext ctx, User currentUser) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(currentUser, "currentUser");
        ctx.attr(CURRENT_USER_KEY).set((Object)currentUser);
    }

    private AuthenticationUtil() {
    }
}

