/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.google.common.collect.ImmutableList;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.api.v1.ChangeDto;
import com.linecorp.centraldogma.internal.api.v1.CommitDto;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDto;
import com.linecorp.centraldogma.internal.api.v1.EntryDto;
import com.linecorp.centraldogma.internal.api.v1.ProjectDto;
import com.linecorp.centraldogma.internal.api.v1.RepositoryDto;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.Objects;
import javax.annotation.Nullable;

final class DtoConverter {
    public static ProjectDto convert(Project project) {
        Objects.requireNonNull(project, "project");
        return new ProjectDto(project.name(), project.author(), project.creationTimeMillis());
    }

    public static RepositoryDto convert(Repository repository) {
        Objects.requireNonNull(repository, "repository");
        Revision headRevision = repository.normalizeNow(Revision.HEAD);
        String projectName = repository.parent().name();
        String repoName = repository.name();
        return new RepositoryDto(projectName, repoName, repository.author(), headRevision, repository.creationTimeMillis());
    }

    public static <T> EntryDto<T> convert(Repository repository, Entry<T> entry) {
        Objects.requireNonNull(entry, "entry");
        if (entry.hasContent()) {
            return DtoConverter.convert(repository, entry.path(), entry.type(), entry.content());
        }
        return DtoConverter.convert(repository, entry.path(), entry.type());
    }

    public static <T> EntryDto<T> convert(Repository repository, String path, EntryType type) {
        return DtoConverter.convert(repository, path, type, null);
    }

    public static <T> EntryDto<T> convert(Repository repository, String path, EntryType type, @Nullable T content) {
        Objects.requireNonNull(repository, "repository");
        return new EntryDto(Objects.requireNonNull(path, "path"), Objects.requireNonNull(type, "type"), repository.parent().name(), repository.name(), content);
    }

    public static CommitDto convert(Commit commit) {
        return DtoConverter.convert(commit, ImmutableList.of());
    }

    public static CommitDto convert(Commit commit, Iterable<EntryDto<?>> entries) {
        Objects.requireNonNull(commit, "commit");
        Objects.requireNonNull(entries, "entries");
        return DtoConverter.convert(commit.revision(), commit.author(), new CommitMessageDto(commit.summary(), commit.detail(), commit.markup()), commit.when(), entries);
    }

    public static CommitDto convert(Revision revision, Author author, CommitMessageDto commitMessage, long commitTimeMillis, Iterable<EntryDto<?>> entries) {
        return new CommitDto(revision, author, commitMessage, commitTimeMillis, (Iterable)ImmutableList.copyOf(entries));
    }

    public static <T> ChangeDto<T> convert(Change<T> change) {
        Objects.requireNonNull(change, "change");
        return new ChangeDto(change.path(), change.type(), change.content());
    }

    private DtoConverter() {
    }
}

