/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.annotation.ConsumeType;
import com.linecorp.armeria.server.annotation.Decorator;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.RequestObject;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.api.v1.CreateRepositoryRequest;
import com.linecorp.centraldogma.internal.api.v1.RepositoryDto;
import com.linecorp.centraldogma.server.internal.admin.authentication.User;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.HasReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.ProjectOwnersOnly;
import com.linecorp.centraldogma.server.internal.api.converter.CreateApiResponseConverter;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.metadata.MetadataService;
import com.linecorp.centraldogma.server.internal.metadata.ProjectRole;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class RepositoryServiceV1
extends AbstractService {
    private final MetadataService mds;

    public RepositoryServiceV1(ProjectManager projectManager, CommandExecutor executor, MetadataService mds) {
        super(projectManager, executor);
        this.mds = Objects.requireNonNull(mds, "mds");
    }

    @Get(value="/projects/{projectName}/repos")
    public CompletableFuture<List<RepositoryDto>> listRepositories(@RequestObject Project project, @Param(value="status") Optional<String> status, @RequestObject User user) {
        status.ifPresent(HttpApiUtil::checkStatusArgument);
        return this.mds.findRole(project.name(), user).handle((role, throwable) -> {
            boolean hasOwnerRole;
            boolean bl = hasOwnerRole = role == ProjectRole.OWNER;
            if (status.isPresent()) {
                if (hasOwnerRole) {
                    return (List)project.repos().listRemoved().stream().map(RepositoryDto::new).collect(ImmutableList.toImmutableList());
                }
                return (List)Exceptions.throwUnsafely((Throwable)HttpStatusException.of((HttpStatus)HttpStatus.FORBIDDEN));
            }
            return (List)project.repos().list().values().stream().filter(r -> user.isAdmin() || !"dogma".equals(r.name())).map(DtoConverter::convert).collect(ImmutableList.toImmutableList());
        });
    }

    @Post(value="/projects/{projectName}/repos")
    @ResponseConverter(value=CreateApiResponseConverter.class)
    @Decorator(value=ProjectOwnersOnly.class)
    public CompletableFuture<RepositoryDto> createRepository(@RequestObject Project project, @RequestObject CreateRepositoryRequest request, @RequestObject Author author) {
        return ((CompletableFuture)this.mds.addRepo(author, project.name(), request.name()).thenCompose(p -> this.execute(Command.createRepository(author, project.name(), request.name())))).handle((unused, cause) -> {
            try {
                if (cause == null) {
                    RepositoryDto repositoryDto = DtoConverter.convert((Repository)project.repos().get(request.name()));
                    return repositoryDto;
                }
                RepositoryDto repositoryDto = (RepositoryDto)Exceptions.throwUnsafely((Throwable)cause);
                return repositoryDto;
            }
            finally {
                if (cause != null) {
                    this.mds.removeRepo(author, project.name(), request.name());
                }
            }
        });
    }

    @Delete(value="/projects/{projectName}/repos/{repoName}")
    @Decorator(value=ProjectOwnersOnly.class)
    public CompletableFuture<Void> removeRepository(@Param(value="repoName") String repoName, @RequestObject Repository repository, @RequestObject Author author) {
        if ("meta".equals(repoName)) {
            throw HttpStatusException.of((HttpStatus)HttpStatus.FORBIDDEN);
        }
        return ((CompletableFuture)this.execute(Command.removeRepository(author, repository.parent().name(), repository.name())).thenCompose(unused -> this.mds.removeRepo(author, repository.parent().name(), repository.name()))).handle(HttpApiUtil::throwUnsafelyIfNonNull);
    }

    @ConsumeType(value="application/json-patch+json")
    @Patch(value="/projects/{projectName}/repos/{repoName}")
    @Decorator(value=ProjectOwnersOnly.class)
    public CompletableFuture<RepositoryDto> patchRepository(@Param(value="repoName") String repoName, @RequestObject Project project, @RequestObject JsonNode node, @RequestObject Author author) {
        HttpApiUtil.checkUnremoveArgument(node);
        return ((CompletableFuture)this.execute(Command.unremoveRepository(author, project.name(), repoName)).thenCompose(unused -> this.mds.restoreRepo(author, project.name(), repoName))).handle(HttpApiUtil.returnOrThrow(() -> DtoConverter.convert((Repository)project.repos().get(repoName))));
    }

    @Get(value="/projects/{projectName}/repos/{repoName}/revision/{revision}")
    @Decorator(value=HasReadPermission.class)
    public Map<String, Integer> normalizeRevision(@RequestObject Repository repository, @Param(value="revision") String revision) {
        Revision normalizedRevision = repository.normalizeNow(new Revision(revision));
        return ImmutableMap.of((Object)"revision", (Object)normalizedRevision.major());
    }
}

