/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Iterables;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.centraldogma.internal.Jackson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpApiResponseConverter
implements ResponseConverterFunction {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiResponseConverter.class);

    public HttpResponse convertResponse(ServiceRequestContext ctx, Object resObj) throws Exception {
        try {
            HttpRequest request = (HttpRequest)RequestContext.current().request();
            if (HttpMethod.DELETE == request.method() || resObj instanceof Iterable && Iterables.size((Iterable)((Iterable)resObj)) == 0) {
                return HttpResponse.of((HttpStatus)HttpStatus.NO_CONTENT);
            }
            HttpData httpData = HttpData.of((byte[])Jackson.writeValueAsBytes((Object)resObj));
            return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (HttpData)httpData);
        }
        catch (JsonProcessingException e) {
            logger.debug("Failed to convert a response:", (Throwable)e);
            return HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

