/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.server.internal.command.AbstractCommand;
import com.linecorp.centraldogma.server.internal.command.CommandType;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class RepositoryCommand<T>
extends AbstractCommand<T> {
    private final String projectName;
    private final String repositoryName;

    RepositoryCommand(CommandType commandType, @Nullable Long timestamp, @Nullable Author author, String projectName, String repositoryName) {
        super(commandType, timestamp, author);
        this.projectName = Objects.requireNonNull(projectName, "projectName");
        this.repositoryName = Objects.requireNonNull(repositoryName, "repositoryName");
    }

    @JsonProperty
    public final String projectName() {
        return this.projectName;
    }

    @JsonProperty
    public final String repositoryName() {
        return this.repositoryName;
    }

    @Override
    public final String executionPath() {
        return String.format("/%s/%s", this.projectName, this.repositoryName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RepositoryCommand)) {
            return false;
        }
        RepositoryCommand that = (RepositoryCommand)obj;
        return super.equals(that) && this.projectName.equals(that.projectName) && this.repositoryName.equals(that.repositoryName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projectName, this.repositoryName) * 31 + super.hashCode();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("projectName", (Object)this.projectName).add("repositoryName", (Object)this.repositoryName);
    }
}

