/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.linecorp.centraldogma.server.internal.admin.service.TokenNotFoundException;
import com.linecorp.centraldogma.server.internal.metadata.Token;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Tokens {
    static final String SECRET_PREFIX = "appToken-";
    private final Map<String, Token> appIds;
    private final Map<String, String> secrets;

    public Tokens() {
        this((Map<String, Token>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of());
    }

    @JsonCreator
    public Tokens(@JsonProperty(value="appIds") Map<String, Token> appIds, @JsonProperty(value="secrets") Map<String, String> secrets) {
        this.appIds = Objects.requireNonNull(appIds, "appIds");
        this.secrets = Objects.requireNonNull(secrets, "secrets");
    }

    @JsonProperty
    public Map<String, Token> appIds() {
        return this.appIds;
    }

    @JsonProperty
    public Map<String, String> secrets() {
        return this.secrets;
    }

    public Token get(String appId) {
        Token token = this.getOrDefault(appId, null);
        if (token != null) {
            return token;
        }
        throw new TokenNotFoundException("Application ID not found: " + appId);
    }

    public Token getOrDefault(String appId, @Nullable Token defaultValue) {
        Objects.requireNonNull(appId, "appId");
        Token token = this.appIds.get(appId);
        if (token != null) {
            return token;
        }
        return defaultValue;
    }

    public Token findBySecret(String secret) {
        Token token = this.findBySecretOrDefault(secret, null);
        if (token != null) {
            return token;
        }
        throw new TokenNotFoundException("Secret not found: " + secret);
    }

    public Token findBySecretOrDefault(String secret, @Nullable Token defaultValue) {
        Objects.requireNonNull(secret, "secret");
        if (!secret.startsWith(SECRET_PREFIX)) {
            return defaultValue;
        }
        String appId = this.secrets.get(secret);
        if (appId != null) {
            return this.getOrDefault(appId, defaultValue);
        }
        return defaultValue;
    }

    public Tokens withoutSecret() {
        Map<String, Token> appIds = this.appIds().values().stream().map(Token::withoutSecret).collect(Collectors.toMap(Token::id, Function.identity()));
        return new Tokens(appIds, (Map<String, String>)ImmutableMap.of());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appIds", this.appIds()).add("secrets", this.secrets()).toString();
    }

    public static boolean isValidSecret(String secret) {
        return secret != null && secret.startsWith(SECRET_PREFIX);
    }

    public static void validateSecret(String secret) {
        Preconditions.checkArgument((boolean)Tokens.isValidSecret(secret), (Object)("invalid secret: " + secret + " (secret must start with '" + SECRET_PREFIX + "')"));
    }
}

