/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.storage.StorageException;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOption;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryUtil;
import com.spotify.futures.CompletableFutures;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public interface Repository {
    public static final int DEFAULT_MAX_COMMITS = 1024;
    public static final String ALL_PATH = "/**";

    public Project parent();

    public String name();

    default public long creationTimeMillis() {
        try {
            List<Commit> history = this.history(Revision.INIT, Revision.INIT, ALL_PATH, 1).join();
            return history.get(0).when();
        }
        catch (CompletionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new StorageException("failed to retrieve the initial commit", cause);
        }
    }

    default public Author author() {
        try {
            List<Commit> history = this.history(Revision.INIT, Revision.INIT, ALL_PATH, 1).join();
            return history.get(0).author();
        }
        catch (CompletionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new StorageException("failed to retrieve the initial commit", cause);
        }
    }

    @Deprecated
    default public CompletableFuture<Revision> normalize(Revision revision) {
        try {
            return CompletableFuture.completedFuture(this.normalizeNow(revision));
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    public Revision normalizeNow(Revision var1);

    public RevisionRange normalizeNow(Revision var1, Revision var2);

    default public CompletableFuture<Boolean> exists(Revision revision, String path) {
        Util.validateFilePath((String)path, (String)"path");
        return this.find(revision, path, RepositoryUtil.EXISTS_FIND_OPTIONS).thenApply(result -> !result.isEmpty());
    }

    default public CompletableFuture<Entry<?>> get(Revision revision, String path) {
        return this.getOrNull(revision, path).thenApply(entry -> {
            if (entry == null) {
                throw new EntryNotFoundException(revision, path);
            }
            return entry;
        });
    }

    default public <T> CompletableFuture<Entry<T>> get(Revision revision, Query<T> query) {
        return this.getOrNull(revision, query).thenApply(res -> {
            if (res == null) {
                throw new EntryNotFoundException(revision, query.path());
            }
            return res;
        });
    }

    default public CompletableFuture<Entry<?>> getOrNull(Revision revision, String path) {
        Util.validateFilePath((String)path, (String)"path");
        return this.find(revision, path, RepositoryUtil.GET_FIND_OPTIONS).thenApply(findResult -> (Entry)findResult.get(path));
    }

    default public <T> CompletableFuture<Entry<T>> getOrNull(Revision revision, Query<T> query) {
        Objects.requireNonNull(query, "query");
        Objects.requireNonNull(revision, "revision");
        return this.getOrNull(revision, query.path()).thenApply(entry -> {
            if (entry == null) {
                return null;
            }
            EntryType entryType = entry.type();
            if (!query.type().supportedEntryTypes().contains(entryType)) {
                throw new QueryExecutionException("unsupported entry type: " + entryType);
            }
            Object entryContent = entry.content();
            try {
                return Entry.of((Revision)entry.revision(), (String)query.path(), (EntryType)entryType, (Object)query.apply(entryContent));
            }
            catch (CentralDogmaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new QueryExecutionException((Throwable)e);
            }
        });
    }

    default public CompletableFuture<Map<String, Entry<?>>> find(Revision revision, String pathPattern) {
        return this.find(revision, pathPattern, (Map<FindOption<?>, ?>)ImmutableMap.of());
    }

    public CompletableFuture<Map<String, Entry<?>>> find(Revision var1, String var2, Map<FindOption<?>, ?> var3);

    default public CompletableFuture<Change<?>> diff(Revision from, Revision to, Query<?> query) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(query, "query");
        RevisionRange range = this.normalizeNow(from, to).toAscending();
        String path = query.path();
        CompletableFuture<Entry<?>> fromEntryFuture = this.getOrNull(range.from(), path);
        CompletableFuture<Entry<?>> toEntryFuture = this.getOrNull(range.to(), path);
        CompletableFuture future = CompletableFutures.combine(fromEntryFuture, toEntryFuture, (fromEntry, toEntry) -> {
            Query castQuery = query;
            if (fromEntry != null) {
                if (toEntry == null) {
                    return Change.ofRemoval((String)path);
                }
            } else {
                if (toEntry != null) {
                    EntryType toEntryType = toEntry.type();
                    if (!query.type().supportedEntryTypes().contains(toEntryType)) {
                        throw new QueryExecutionException("unsupported entry type: " + toEntryType);
                    }
                    Object toContent = castQuery.apply(toEntry.content());
                    switch (toEntryType) {
                        case JSON: {
                            return Change.ofJsonUpsert((String)path, (JsonNode)((JsonNode)toContent));
                        }
                        case TEXT: {
                            return Change.ofTextUpsert((String)path, (String)((String)toContent));
                        }
                    }
                    throw new Error();
                }
                throw new EntryNotFoundException(path + " (" + from + ", " + to + ')');
            }
            EntryType entryType = fromEntry.type();
            if (!query.type().supportedEntryTypes().contains(entryType)) {
                throw new QueryExecutionException("unsupported entry type: " + entryType);
            }
            if (entryType != toEntry.type()) {
                throw new QueryExecutionException("mismatching entry type: " + entryType + " != " + toEntry.type());
            }
            Object fromContent = castQuery.apply(fromEntry.content());
            Object toContent = castQuery.apply(toEntry.content());
            switch (entryType) {
                case JSON: {
                    return Change.ofJsonPatch((String)path, (JsonNode)((JsonNode)fromContent), (JsonNode)((JsonNode)toContent));
                }
                case TEXT: {
                    return Change.ofTextPatch((String)path, (String)((String)fromContent), (String)((String)toContent));
                }
            }
            throw new Error();
        }).toCompletableFuture();
        return (CompletableFuture)Util.unsafeCast(future);
    }

    public CompletableFuture<Map<String, Change<?>>> diff(Revision var1, Revision var2, String var3);

    default public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision baseRevision, Change<?> ... changes) {
        Objects.requireNonNull(changes, "changes");
        return this.previewDiff(baseRevision, Arrays.asList(changes));
    }

    public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision var1, Iterable<Change<?>> var2);

    default public CompletableFuture<Revision> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, Iterable<Change<?>> changes) {
        return this.commit(baseRevision, commitTimeMillis, author, summary, "", Markup.PLAINTEXT, changes);
    }

    default public CompletableFuture<Revision> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, Change<?> ... changes) {
        return this.commit(baseRevision, commitTimeMillis, author, summary, "", Markup.PLAINTEXT, changes);
    }

    default public CompletableFuture<Revision> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Change<?> ... changes) {
        Objects.requireNonNull(changes, "changes");
        return this.commit(baseRevision, commitTimeMillis, author, summary, detail, markup, Arrays.asList(changes));
    }

    public CompletableFuture<Revision> commit(Revision var1, long var2, Author var4, String var5, String var6, Markup var7, Iterable<Change<?>> var8);

    default public CompletableFuture<List<Commit>> history(Revision from, Revision to, String pathPattern) {
        return this.history(from, to, pathPattern, 1024);
    }

    public CompletableFuture<List<Commit>> history(Revision var1, Revision var2, String var3, int var4);

    public CompletableFuture<Revision> watch(Revision var1, String var2);

    default public <T> CompletableFuture<Entry<T>> watch(Revision lastKnownRevision, Query<T> query) {
        return RepositoryUtil.watch(this, lastKnownRevision, query);
    }
}

