/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableCall;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepositoryCache {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryCache.class);
    final AsyncLoadingCache<CacheableCall, Object> cache;
    private final String cacheSpec;

    public static String validateCacheSpec(String cacheSpec) {
        if (cacheSpec == null) {
            return null;
        }
        try {
            CaffeineSpec.parse((String)cacheSpec);
            return cacheSpec;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("cacheSpec: " + cacheSpec + " (" + e.getMessage() + ')');
        }
    }

    public RepositoryCache(String cacheSpec) {
        this.cacheSpec = Objects.requireNonNull(RepositoryCache.validateCacheSpec(cacheSpec), "cacheSpec");
        Caffeine builder = Caffeine.from((String)cacheSpec);
        if (cacheSpec.contains("maximumWeight=")) {
            builder.weigher(CacheableCall::weigh);
        }
        this.cache = builder.recordStats().buildAsync((key, executor) -> {
            logger.debug("Cache miss: {}", key);
            return key.execute();
        });
    }

    public CacheStats stats() {
        return this.cache.synchronous().stats();
    }

    public void clear() {
        this.cache.synchronous().invalidateAll();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("spec", (Object)this.cacheSpec).add("stats", (Object)this.stats()).toString();
    }
}

