/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.DecoratingServiceFunction;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.server.internal.admin.authentication.AuthenticationUtil;
import com.linecorp.centraldogma.server.internal.admin.authentication.User;
import com.linecorp.centraldogma.server.internal.api.auth.AbstractRoleCheckingDecorator;
import com.linecorp.centraldogma.server.internal.metadata.MetadataService;
import com.linecorp.centraldogma.server.internal.metadata.MetadataServiceInjector;
import com.linecorp.centraldogma.server.internal.metadata.Permission;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

abstract class AbstractPermissionCheckingDecorator
implements DecoratingServiceFunction<HttpRequest, HttpResponse> {
    AbstractPermissionCheckingDecorator() {
    }

    public final HttpResponse serve(Service<HttpRequest, HttpResponse> delegate, ServiceRequestContext ctx, HttpRequest req) throws Exception {
        MetadataService mds = MetadataServiceInjector.getMetadataService(ctx);
        User user = AuthenticationUtil.currentUser(ctx);
        String projectName = ctx.pathParam("projectName");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"no project name is specified");
        String repoName = ctx.pathParam("repoName");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repoName) ? 1 : 0) != 0, (Object)"no repository name is specified");
        if ("dogma".equals(repoName)) {
            return AbstractPermissionCheckingDecorator.serveInternalRepo(delegate, ctx, req, mds, user, projectName);
        }
        return this.serveUserRepo(delegate, ctx, req, mds, user, projectName, repoName);
    }

    private static HttpResponse serveInternalRepo(Service<HttpRequest, HttpResponse> delegate, ServiceRequestContext ctx, HttpRequest req, MetadataService mds, User user, String projectName) throws Exception {
        if (user.isAdmin()) {
            return (HttpResponse)delegate.serve(ctx, (Request)req);
        }
        return HttpResponse.from((CompletionStage)mds.findRole(projectName, user).handle((role, cause) -> {
            if (cause != null) {
                return AbstractRoleCheckingDecorator.handleException(cause);
            }
            if (!user.isAdmin()) {
                throw HttpStatusException.of((HttpStatus)HttpStatus.FORBIDDEN);
            }
            try {
                return (HttpResponse)delegate.serve(ctx, (Request)req);
            }
            catch (Exception e) {
                return (HttpResponse)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
    }

    private HttpResponse serveUserRepo(Service<HttpRequest, HttpResponse> delegate, ServiceRequestContext ctx, HttpRequest req, MetadataService mds, User user, String projectName, String repoName) throws Exception {
        CompletableFuture<Collection<Permission>> f;
        try {
            f = mds.findPermissions(projectName, repoName, user);
        }
        catch (Throwable cause2) {
            return AbstractRoleCheckingDecorator.handleException(cause2);
        }
        return HttpResponse.from(f.handle((permission, cause) -> {
            if (cause != null) {
                return AbstractRoleCheckingDecorator.handleException(cause);
            }
            if (!this.hasPermission((Collection<Permission>)permission)) {
                throw HttpStatusException.of((HttpStatus)HttpStatus.FORBIDDEN);
            }
            try {
                return (HttpResponse)delegate.serve(ctx, (Request)req);
            }
            catch (Exception e) {
                return (HttpResponse)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
    }

    protected abstract boolean hasPermission(Collection<Permission> var1);
}

