/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.google.common.base.Throwables;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.storage.StorageException;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOption;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableFindCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableFindLatestRevCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableHistoryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableMultiDiffCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableQueryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableSingleDiffCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.RepositoryCache;
import com.spotify.futures.CompletableFutures;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

final class CachingRepository
implements Repository {
    private static final CancellationException CANCELLATION_EXCEPTION = (CancellationException)Exceptions.clearTrace((Throwable)new CancellationException("watch cancelled by caller"));
    private final Repository repo;
    private final AsyncLoadingCache<CacheableCall, Object> cache;
    private final Commit firstCommit;

    CachingRepository(Repository repo, RepositoryCache cache) {
        this.repo = Objects.requireNonNull(repo, "repo");
        this.cache = Objects.requireNonNull(cache, (String)"cache").cache;
        try {
            List<Commit> history = repo.history(Revision.INIT, Revision.INIT, "/**", 1).join();
            this.firstCommit = history.get(0);
        }
        catch (CompletionException e) {
            Throwable cause = Exceptions.peel((Throwable)e);
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new StorageException("failed to retrieve the initial commit", cause);
        }
    }

    @Override
    public long creationTimeMillis() {
        return this.firstCommit.when();
    }

    @Override
    public Author author() {
        return this.firstCommit.author();
    }

    @Override
    public <T> CompletableFuture<Entry<T>> getOrNull(Revision revision, Query<T> query) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(query, "query");
        CompletableFuture<T> future = this.normalizeAndCompose(revision, rev -> this.cache.get((Object)new CacheableQueryCall(this.repo, (Revision)rev, query)).thenApply(result -> result != CacheableQueryCall.EMPTY ? result : null));
        return (CompletableFuture)Util.unsafeCast(future);
    }

    @Override
    public CompletableFuture<Map<String, Entry<?>>> find(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(options, "options");
        CompletableFuture future = this.normalizeAndCompose(revision, rev -> this.cache.get((Object)new CacheableFindCall(this.repo, (Revision)rev, pathPattern, options)));
        return (CompletableFuture)Util.unsafeCast(future);
    }

    @Override
    public CompletableFuture<List<Commit>> history(Revision from, Revision to, String pathPattern, int maxCommits) {
        RevisionRange range;
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        if (maxCommits <= 0) {
            throw new IllegalArgumentException("maxCommits: " + maxCommits + " (expected: > 0)");
        }
        try {
            range = this.normalizeNow(from, to);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
        int actualMaxCommits = Math.min(maxCommits, Math.abs(range.from().major() - range.to().major()) + 1);
        return (CompletableFuture)Util.unsafeCast((Object)this.cache.get((Object)new CacheableHistoryCall(this.repo, range.from(), range.to(), pathPattern, actualMaxCommits)));
    }

    @Override
    public CompletableFuture<Change<?>> diff(Revision from, Revision to, Query<?> query) {
        RevisionRange range;
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(query, "query");
        try {
            range = this.normalizeNow(from, to).toAscending();
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
        return (CompletableFuture)Util.unsafeCast((Object)this.cache.get((Object)new CacheableSingleDiffCall(this.repo, range.from(), range.to(), query)));
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> diff(Revision from, Revision to, String pathPattern) {
        RevisionRange range;
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        try {
            range = this.normalizeNow(from, to).toAscending();
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
        return (CompletableFuture)Util.unsafeCast((Object)this.cache.get((Object)new CacheableMultiDiffCall(this.repo, range.from(), range.to(), pathPattern)));
    }

    @Override
    public CompletableFuture<Revision> findLatestRevision(Revision lastKnownRevision, String pathPattern) {
        RevisionRange range;
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        try {
            range = this.normalizeNow(lastKnownRevision, Revision.HEAD);
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
        if (range.from().equals((Object)range.to())) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage future = this.cache.get((Object)new CacheableFindLatestRevCall(this.repo, range.from(), range.to(), pathPattern)).thenApply(result -> result != CacheableFindLatestRevCall.EMPTY ? result : null);
        return (CompletableFuture)Util.unsafeCast((Object)future);
    }

    @Override
    public CompletableFuture<Revision> watch(Revision lastKnownRevision, String pathPattern) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        CompletableFuture<Revision> latestRevFuture = this.findLatestRevision(lastKnownRevision, pathPattern);
        if (latestRevFuture.isCompletedExceptionally() || latestRevFuture.getNow(null) != null) {
            return latestRevFuture;
        }
        CompletableFuture<Revision> future = new CompletableFuture<Revision>();
        latestRevFuture.whenComplete((latestRevision, cause) -> {
            if (cause != null) {
                future.completeExceptionally((Throwable)cause);
                return;
            }
            if (latestRevision != null) {
                future.complete((Revision)latestRevision);
                return;
            }
            CompletableFuture<Revision> watchFuture = this.repo.watch(lastKnownRevision, pathPattern);
            watchFuture.whenComplete((watchResult, watchCause) -> {
                if (watchCause == null) {
                    future.complete((Revision)watchResult);
                } else {
                    future.completeExceptionally((Throwable)watchCause);
                }
            });
            future.whenComplete((unused1, unused2) -> watchFuture.completeExceptionally(CANCELLATION_EXCEPTION));
        });
        return future;
    }

    @Override
    public Project parent() {
        return this.repo.parent();
    }

    @Override
    public String name() {
        return this.repo.name();
    }

    @Override
    public Revision normalizeNow(Revision revision) {
        return this.repo.normalizeNow(revision);
    }

    @Override
    public RevisionRange normalizeNow(Revision from, Revision to) {
        return this.repo.normalizeNow(from, to);
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision baseRevision, Iterable<Change<?>> changes) {
        Objects.requireNonNull(baseRevision, "baseRevision");
        return this.repo.previewDiff(baseRevision, changes);
    }

    @Override
    public CompletableFuture<Revision> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes) {
        return this.repo.commit(baseRevision, commitTimeMillis, author, summary, detail, markup, changes);
    }

    private <T> CompletableFuture<T> normalizeAndCompose(Revision revision, Function<Revision, CompletableFuture<T>> function) {
        return this.normalize(revision).thenCompose(function);
    }
}

