/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.server.internal.admin.service.TokenNotFoundException;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import java.util.Map;

public final class HttpApiExceptionHandler
implements ExceptionHandlerFunction {
    private static final Map<Class<?>, ExceptionHandlerFunction> exceptionHandlers;

    public HttpResponse handleException(RequestContext ctx, HttpRequest req, Throwable cause) {
        if (cause instanceof HttpStatusException || cause instanceof HttpResponseException) {
            return (HttpResponse)ExceptionHandlerFunction.fallthrough();
        }
        ExceptionHandlerFunction func = exceptionHandlers.get(cause.getClass());
        if (func != null) {
            return func.handleException(ctx, req, cause);
        }
        if (cause instanceof IllegalArgumentException) {
            return HttpApiUtil.newResponse(HttpStatus.BAD_REQUEST, cause);
        }
        return HttpApiUtil.newResponse(HttpStatus.INTERNAL_SERVER_ERROR, cause);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ChangeConflictException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.CONFLICT, cause, "The given changeset or revision has a conflict.")).put(EntryNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.NOT_FOUND, cause, "Entry '%s' does not exist.", cause.getMessage())).put(ProjectExistsException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.CONFLICT, cause, "Project '%s' exists already.", cause.getMessage())).put(ProjectNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.NOT_FOUND, cause, "Project '%s' does not exist.", cause.getMessage())).put(RedundantChangeException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.CONFLICT, cause, "The given changeset does not change anything.")).put(RepositoryExistsException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.CONFLICT, cause, "Repository '%s' exists already.", cause.getMessage())).put(RepositoryMetadataException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.INTERNAL_SERVER_ERROR, cause)).put(RepositoryNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.NOT_FOUND, cause, "Repository '%s' does not exist.", cause.getMessage())).put(RevisionNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.NOT_FOUND, cause, "Revision %s does not exist.", cause.getMessage())).put(TokenNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse(HttpStatus.NOT_FOUND, cause, "Token '%s' does not exist.", cause.getMessage()));
        exceptionHandlers = builder.build();
    }
}

