/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.server.internal.admin.authentication.AuthenticationUtil;
import com.linecorp.centraldogma.server.internal.admin.authentication.User;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.Objects;

public final class HttpApiRequestConverter
implements RequestConverterFunction {
    private final ProjectManager projectManager;

    public HttpApiRequestConverter(ProjectManager projectManager) {
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
    }

    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpMessage request, Class<?> expectedResultType) throws Exception {
        if (expectedResultType == Project.class) {
            String projectName = ctx.pathParam("projectName");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"project name should not be null or empty.");
            return this.projectManager.get(projectName);
        }
        if (expectedResultType == Repository.class) {
            String projectName = ctx.pathParam("projectName");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"project name should not be null or empty.");
            String repositoryName = ctx.pathParam("repoName");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repositoryName) ? 1 : 0) != 0, (Object)"repository name should not be null or empty.");
            if ("dogma".equals(repositoryName) && !AuthenticationUtil.currentUser(ctx).isAdmin()) {
                return HttpApiUtil.throwResponse(HttpStatus.FORBIDDEN, "Repository '%s/%s' can be accessed only by an administrator.", projectName, "dogma");
            }
            return ((Project)this.projectManager.get(projectName)).repos().get(repositoryName);
        }
        if (expectedResultType == Author.class) {
            return AuthenticationUtil.currentAuthor(ctx);
        }
        if (expectedResultType == User.class) {
            return AuthenticationUtil.currentUser(ctx);
        }
        return RequestConverterFunction.fallthrough();
    }
}

