/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.plugin;

import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.plugin.PluginException;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.io.ByteArrayOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Plugin {
    private static final EventExecutor jsEventLoop = new DefaultEventExecutor((ThreadFactory)new DefaultThreadFactory("plugin-event-loop", true));
    private static final String SCRIPT_UNSAFE = Plugin.readScriptResource("unsafe.js");
    private static final String SCRIPT_POLYFILL_CONSOLE = Plugin.readScriptResource("polyfill-console.js");
    private static final String SCRIPT_POLYFILL_TIMEOUT = Plugin.readScriptResource("polyfill-timeout.js");
    private static final String SCRIPT_REQUIRE = Plugin.readScriptResource("require-2.1.22.js");
    private static final String SCRIPT_REQUIRE_OVERRIDES = Plugin.readScriptResource("require-overrides.js");
    private static final String SCRIPT_STARTUP = Plugin.readScriptResource("startup.js");
    private static final String LOGGER_NAME_PREFIX = "scripts.";
    private final ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
    private final ScriptObjectMirror plugin;
    private final ScriptObjectMirror unsafe;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readScriptResource(String filename) {
        try (InputStream in = Plugin.class.getResourceAsStream(filename);){
            String string = Plugin.readScriptResource(filename, in);
            return string;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static String readScriptResource(String filename, InputStream in) throws IOException {
        int readBytes;
        byte[] buf = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream(buf.length);
        while ((readBytes = in.read(buf)) >= 0) {
            out.write(buf, 0, readBytes);
        }
        return "load({  name: '" + filename + "',  script: \"" + Plugin.escapeJavaScript(out.toString(StandardCharsets.UTF_8.name())) + '\"' + "});";
    }

    private static String escapeJavaScript(String script) {
        StringBuilder buf = new StringBuilder(script.length() * 3 / 2);
        int length = script.length();
        block13: for (int i = 0; i < length; ++i) {
            char ch = script.charAt(i);
            if (ch > '\u0fff') {
                buf.append("\\u");
                buf.append(Integer.toHexString(ch));
                continue;
            }
            if (ch > '\u00ff') {
                buf.append("\\u0");
                buf.append(Integer.toHexString(ch));
                continue;
            }
            if (ch > '\u007f') {
                buf.append("\\u00");
                buf.append(Integer.toHexString(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        buf.append('\\');
                        buf.append('b');
                        break;
                    }
                    case '\n': {
                        buf.append('\\');
                        buf.append('n');
                        break;
                    }
                    case '\t': {
                        buf.append('\\');
                        buf.append('t');
                        break;
                    }
                    case '\f': {
                        buf.append('\\');
                        buf.append('f');
                        break;
                    }
                    case '\r': {
                        buf.append('\\');
                        buf.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            buf.append("\\u00");
                        } else {
                            buf.append("\\u000");
                        }
                        buf.append(Integer.toHexString(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    continue block13;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    continue block13;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    continue block13;
                }
                case '/': {
                    buf.append('\\');
                    buf.append('/');
                    continue block13;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    Plugin(Project project, Revision revision, String path) throws Exception {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(path, "path");
        this.engine.eval(SCRIPT_UNSAFE);
        this.unsafe = (ScriptObjectMirror)this.engine.get("__UNSAFE__");
        this.unsafe.put("pluginRepository", (Object)project.metaRepo());
        this.unsafe.put("pluginRevision", (Object)revision);
        this.unsafe.put("pluginPath", (Object)path);
        this.unsafe.put("eventLoop", (Object)jsEventLoop);
        Logger pluginLogger = LoggerFactory.getLogger((String)Plugin.loggerName(path));
        this.unsafe.put("logger", (Object)pluginLogger);
        String pluginInitPromiseKey = "pluginInitPromise";
        DefaultPromise pluginInitPromise = new DefaultPromise(jsEventLoop);
        this.unsafe.put("pluginInitPromise", (Object)pluginInitPromise);
        jsEventLoop.submit(() -> {
            pluginLogger.info("Loading plugin: {} (revision: {})", (Object)path, (Object)revision.text());
            this.engine.eval(SCRIPT_POLYFILL_CONSOLE);
            this.engine.eval(SCRIPT_POLYFILL_TIMEOUT);
            this.engine.eval(SCRIPT_REQUIRE);
            this.engine.eval(SCRIPT_REQUIRE_OVERRIDES);
            this.engine.eval(SCRIPT_STARTUP);
            return null;
        }).syncUninterruptibly();
        this.plugin = (ScriptObjectMirror)pluginInitPromise.syncUninterruptibly().getNow();
    }

    private static String loggerName(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return "scripts.__UNKNOWN__";
        }
        StringBuilder buf = new StringBuilder(filePath.length() + 8).append(LOGGER_NAME_PREFIX);
        char ch = filePath.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            buf.append(ch);
        } else if (ch != '/') {
            buf.append('_');
        }
        for (int i = 1; i < filePath.length(); ++i) {
            ch = filePath.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                buf.append(ch);
                continue;
            }
            if (ch == '/') {
                buf.append('.');
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    boolean hasFunction(String funcName) {
        Object member = this.plugin.get((Object)funcName);
        if (!(member instanceof JSObject)) {
            return false;
        }
        return ((JSObject)member).isFunction();
    }

    Object invoke(String funcName, Object ... args) throws InterruptedException {
        Object result;
        Object[] invokeArgs = new Object[args.length + 2];
        invokeArgs[0] = this.plugin;
        invokeArgs[1] = funcName;
        int i = 2;
        for (int j = 0; j < args.length; ++j) {
            invokeArgs[i] = args[j];
            ++i;
        }
        try {
            result = jsEventLoop.submit(() -> this.unsafe.callMember("invoke", invokeArgs)).get();
        }
        catch (ExecutionException e) {
            throw new PluginException(e.getCause());
        }
        if (!(result instanceof Future)) {
            return result;
        }
        Future future = (Future)result;
        return future.sync().getNow();
    }
}

