/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class SafeProjectManager
implements ProjectManager {
    private final ProjectManager delegate;

    public SafeProjectManager(ProjectManager delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public CacheStats cacheStats() {
        return this.delegate().cacheStats();
    }

    @Override
    public void close(Supplier<CentralDogmaException> failureCauseSupplier) {
        this.delegate().close(failureCauseSupplier);
    }

    @Override
    public boolean exists(String name) {
        SafeProjectManager.validateProjectName(name);
        return this.delegate().exists(name);
    }

    @Override
    public Project get(String name) {
        SafeProjectManager.validateProjectName(name);
        return (Project)this.delegate().get(name);
    }

    @Override
    public Project create(String name, long creationTimeMillis, Author author) {
        SafeProjectManager.validateProjectName(name);
        return (Project)this.delegate().create(name, creationTimeMillis, author);
    }

    @Override
    public Map<String, Project> list() {
        Map list = this.delegate().list();
        LinkedHashMap ret = new LinkedHashMap(list.size());
        for (Map.Entry entry : list.entrySet()) {
            if (!SafeProjectManager.isValidProjectName(((Project)entry.getValue()).name())) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public Set<String> listRemoved() {
        return this.delegate().listRemoved();
    }

    @Override
    public void remove(String name) {
        SafeProjectManager.validateProjectName(name);
        this.delegate().remove(name);
    }

    @Override
    public Project unremove(String name) {
        SafeProjectManager.validateProjectName(name);
        return (Project)this.delegate().unremove(name);
    }

    @Override
    public void ensureOpen() {
        this.delegate().ensureOpen();
    }

    protected final ProjectManager delegate() {
        return this.delegate;
    }

    protected static void validateProjectName(String name) {
        if (!SafeProjectManager.isValidProjectName(name)) {
            throw new IllegalArgumentException("Illegal access to project '" + name + '\'');
        }
    }

    protected static boolean isValidProjectName(String name) {
        return name != null && !"dogma".equals(name);
    }
}

