/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.support.shiro;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.realm.activedirectory.ActiveDirectoryRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;

public class SearchFirstActiveDirectoryRealm
extends ActiveDirectoryRealm {
    private static final Pattern USERNAME_PLACEHOLDER = Pattern.compile("\\{0}");
    private static final String DEFAULT_SEARCH_FILTER = "cn={0}";
    private static final int DEFAULT_SEARCH_TIMEOUT_MILLIS = (int)Duration.ofSeconds(10L).toMillis();
    @Nullable
    private String searchFilter = "cn={0}";
    private int searchTimeoutMillis = DEFAULT_SEARCH_TIMEOUT_MILLIS;

    @Nullable
    protected String getSearchFilter() {
        return this.searchFilter;
    }

    protected void setSearchFilter(String searchFilter) {
        this.searchFilter = Objects.requireNonNull(searchFilter, "searchFilter");
    }

    public int getSearchTimeoutMillis() {
        return this.searchTimeoutMillis;
    }

    protected void setSearchTimeoutMillis(int searchTimeoutMillis) {
        Preconditions.checkArgument((searchTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"searchTimeoutMillis should be 0 or positive number");
        this.searchTimeoutMillis = searchTimeoutMillis;
    }

    @Nullable
    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        try {
            return this.queryForAuthenticationInfo0(token, ldapContextFactory);
        }
        catch (ServiceUnavailableException e) {
            return this.queryForAuthenticationInfo0(token, ldapContextFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AuthenticationInfo queryForAuthenticationInfo0(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        UsernamePasswordToken upToken = SearchFirstActiveDirectoryRealm.ensureUsernamePasswordToken(token);
        String userDn = this.findUserDn(ldapContextFactory, upToken.getUsername());
        if (userDn == null) {
            return null;
        }
        LdapContext ctx = null;
        try {
            ctx = ldapContextFactory.getLdapContext((Object)userDn, (Object)upToken.getPassword());
        }
        catch (AuthenticationException e) {
            AuthenticationInfo authenticationInfo;
            try {
                authenticationInfo = null;
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
            LdapUtils.closeContext((LdapContext)ctx);
            return authenticationInfo;
        }
        LdapUtils.closeContext((LdapContext)ctx);
        return this.buildAuthenticationInfo(upToken.getUsername(), upToken.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String findUserDn(LdapContextFactory ldapContextFactory, String username) throws NamingException {
        LdapContext ctx = null;
        try {
            NamingEnumeration<SearchResult> result;
            block8: {
                String string;
                ctx = ldapContextFactory.getSystemLdapContext();
                SearchControls ctrl = new SearchControls();
                ctrl.setCountLimit(1L);
                ctrl.setSearchScope(2);
                ctrl.setTimeLimit(this.searchTimeoutMillis);
                String filter = this.searchFilter != null ? USERNAME_PLACEHOLDER.matcher(this.searchFilter).replaceAll(username) : username;
                result = ctx.search(this.searchBase, filter, ctrl);
                try {
                    if (result.hasMore()) break block8;
                    string = null;
                }
                catch (Throwable throwable) {
                    result.close();
                    throw throwable;
                }
                result.close();
                return string;
            }
            String string = result.next().getNameInNamespace();
            result.close();
            return string;
        }
        finally {
            LdapUtils.closeContext((LdapContext)ctx);
        }
    }

    private static UsernamePasswordToken ensureUsernamePasswordToken(AuthenticationToken token) {
        if (token instanceof UsernamePasswordToken) {
            return (UsernamePasswordToken)token;
        }
        throw new IllegalArgumentException("Token '" + token.getClass().getName() + "' is not supported.");
    }
}

