/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.google.common.collect.ImmutableSet;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.centraldogma.server.CentralDogma;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.GracefulShutdownTimeout;
import com.linecorp.centraldogma.server.ReplicationConfig;
import com.linecorp.centraldogma.server.TlsConfig;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.RepositoryCache;
import java.io.File;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.shiro.config.Ini;

public final class CentralDogmaBuilder {
    private static final ServerPort DEFAULT_PORT = new ServerPort(36462, new SessionProtocol[]{SessionProtocol.HTTP});
    static final int DEFAULT_NUM_REPOSITORY_WORKERS = 16;
    static final int DEFAULT_NUM_MIRRORING_THREADS = 16;
    static final int DEFAULT_MAX_NUM_FILES_PER_MIRROR = 8192;
    static final long DEFAULT_MAX_NUM_BYTES_PER_MIRROR = 0x2000000L;
    static final long DEFAULT_WEB_APP_SESSION_TIMEOUT_MILLIS = 604800000L;
    static final String DEFAULT_REPOSITORY_CACHE_SPEC = "maximumWeight=134217728,expireAfterAccess=5m";
    static final String DEFAULT_SESSION_CACHE_SPEC = "maximumSize=8192,expireAfterWrite=604800s";
    private final List<ServerPort> ports = new ArrayList<ServerPort>(2);
    private TlsConfig tls;
    private Integer numWorkers;
    private Integer maxNumConnections;
    private Long requestTimeoutMillis;
    private Long idleTimeoutMillis;
    private Integer maxFrameLength;
    private final File dataDir;
    private int numRepositoryWorkers = 16;
    @Nullable
    private String repositoryCacheSpec = "maximumWeight=134217728,expireAfterAccess=5m";
    @Nullable
    private String sessionCacheSpec = "maximumSize=8192,expireAfterWrite=604800s";
    private boolean webAppEnabled = true;
    private long webAppSessionTimeoutMillis = 604800000L;
    private boolean mirroringEnabled = true;
    private int numMirroringThreads = 16;
    private int maxNumFilesPerMirror = 8192;
    private long maxNumBytesPerMirror = 0x2000000L;
    @Nullable
    private GracefulShutdownTimeout gracefulShutdownTimeout;
    private ReplicationConfig replicationConfig = ReplicationConfig.NONE;
    @Nullable
    private Ini securityConfig;
    private String accessLogFormat;
    private final ImmutableSet.Builder<String> administrators = new ImmutableSet.Builder();
    private boolean caseSensitiveLoginNames;

    public CentralDogmaBuilder(File dataDir) {
        this.dataDir = Objects.requireNonNull(dataDir, "dataDir");
        if (dataDir.exists() && !dataDir.isDirectory()) {
            throw new IllegalArgumentException("dataDir: " + dataDir + " (not a directory)");
        }
    }

    public CentralDogmaBuilder port(int port, SessionProtocol protocol) {
        return this.port(new ServerPort(port, new SessionProtocol[]{protocol}));
    }

    public CentralDogmaBuilder port(InetSocketAddress localAddress, SessionProtocol protocol) {
        return this.port(new ServerPort(localAddress, new SessionProtocol[]{protocol}));
    }

    public CentralDogmaBuilder port(ServerPort port) {
        this.ports.add(Objects.requireNonNull(port, "port"));
        return this;
    }

    public CentralDogmaBuilder tls(TlsConfig tls) {
        this.tls = Objects.requireNonNull(tls, "tls");
        return this;
    }

    public CentralDogmaBuilder numWorkers(int numWorkers) {
        this.numWorkers = numWorkers;
        return this;
    }

    public CentralDogmaBuilder maxNumConnections(int maxNumConnections) {
        this.maxNumConnections = maxNumConnections;
        return this;
    }

    public CentralDogmaBuilder requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    public CentralDogmaBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = requestTimeoutMillis;
        return this;
    }

    public CentralDogmaBuilder idleTimeout(Duration idleTimeout) {
        return this.idleTimeoutMillis(Objects.requireNonNull(idleTimeout, "idleTimeout").toMillis());
    }

    public CentralDogmaBuilder idleTimeoutMillis(long idleTimeoutMillis) {
        this.idleTimeoutMillis = idleTimeoutMillis;
        return this;
    }

    public CentralDogmaBuilder maxFrameLength(int maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
        return this;
    }

    public CentralDogmaBuilder numRepositoryWorkers(int numRepositoryWorkers) {
        this.numRepositoryWorkers = numRepositoryWorkers;
        return this;
    }

    @Deprecated
    public CentralDogmaBuilder cacheSpec(String cacheSpec) {
        this.repositoryCacheSpec = RepositoryCache.validateCacheSpec(cacheSpec);
        return this;
    }

    public CentralDogmaBuilder repositoryCacheSpec(String repositoryCacheSpec) {
        this.repositoryCacheSpec = RepositoryCache.validateCacheSpec(repositoryCacheSpec);
        return this;
    }

    public CentralDogmaBuilder sessionCacheSpec(String sessionCacheSpec) {
        this.sessionCacheSpec = RepositoryCache.validateCacheSpec(sessionCacheSpec);
        return this;
    }

    public CentralDogmaBuilder webAppEnabled(boolean webAppEnabled) {
        this.webAppEnabled = webAppEnabled;
        return this;
    }

    public CentralDogmaBuilder webAppSessionTimeoutMillis(long webAppSessionTimeoutMillis) {
        this.webAppSessionTimeoutMillis = webAppSessionTimeoutMillis;
        return this;
    }

    public CentralDogmaBuilder webAppSessionTimeout(Duration webAppSessionTimeout) {
        return this.webAppSessionTimeoutMillis(Objects.requireNonNull(webAppSessionTimeout, "webAppSessionTimeout").toMillis());
    }

    public CentralDogmaBuilder mirroringEnabled(boolean mirroringEnabled) {
        this.mirroringEnabled = mirroringEnabled;
        return this;
    }

    public CentralDogmaBuilder numMirroringThreads(int numMirroringThreads) {
        this.numMirroringThreads = numMirroringThreads;
        return this;
    }

    public CentralDogmaBuilder maxNumFilesPerMirror(int maxNumFilesPerMirror) {
        this.maxNumFilesPerMirror = maxNumFilesPerMirror;
        return this;
    }

    public CentralDogmaBuilder maxNumBytesPerMirror(long maxNumBytesPerMirror) {
        this.maxNumBytesPerMirror = maxNumBytesPerMirror;
        return this;
    }

    public CentralDogmaBuilder gracefulShutdownTimeout(GracefulShutdownTimeout gracefulShutdownTimeout) {
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        return this;
    }

    public CentralDogmaBuilder replication(ReplicationConfig replicationConfig) {
        this.replicationConfig = Objects.requireNonNull(replicationConfig, "replicationConfig");
        return this;
    }

    public CentralDogmaBuilder securityConfig(Ini securityConfig) {
        Objects.requireNonNull(securityConfig, "securityConfig");
        Ini iniCopy = new Ini();
        iniCopy.putAll((Map)securityConfig);
        this.securityConfig = iniCopy;
        return this;
    }

    public CentralDogmaBuilder accessLogFormat(String accessLogFormat) {
        this.accessLogFormat = Objects.requireNonNull(accessLogFormat, "accessLogFormat");
        return this;
    }

    public CentralDogmaBuilder administrators(String ... administrators) {
        Objects.requireNonNull(administrators, "administrators");
        for (String administrator : administrators) {
            this.administrators.add((Object)administrator);
        }
        return this;
    }

    public CentralDogmaBuilder administrators(Iterable<String> administrators) {
        Objects.requireNonNull(administrators, "administrators");
        this.administrators.addAll(administrators);
        return this;
    }

    public CentralDogmaBuilder caseSensitiveLoginNames(boolean caseSensitiveLoginNames) {
        this.caseSensitiveLoginNames = caseSensitiveLoginNames;
        return this;
    }

    public CentralDogma build() {
        return new CentralDogma(this.buildConfig(), this.securityConfig);
    }

    private CentralDogmaConfig buildConfig() {
        List<ServerPort> ports = !this.ports.isEmpty() ? this.ports : Collections.singletonList(DEFAULT_PORT);
        return new CentralDogmaConfig(this.dataDir, ports, this.tls, this.numWorkers, this.maxNumConnections, this.requestTimeoutMillis, this.idleTimeoutMillis, this.maxFrameLength, this.numRepositoryWorkers, null, this.repositoryCacheSpec, this.sessionCacheSpec, this.gracefulShutdownTimeout, this.webAppEnabled, this.webAppSessionTimeoutMillis, this.mirroringEnabled, this.numMirroringThreads, this.maxNumFilesPerMirror, this.maxNumBytesPerMirror, this.replicationConfig, this.securityConfig != null, null, this.accessLogFormat, (Set<String>)this.administrators.build(), this.caseSensitiveLoginNames);
    }
}

