/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.armeria.server.annotation.Decorator;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.RequestConverter;
import com.linecorp.armeria.server.annotation.RequestObject;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDto;
import com.linecorp.centraldogma.internal.api.v1.EntryDto;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.WatchService;
import com.linecorp.centraldogma.server.internal.api.auth.HasReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.HasWritePermission;
import com.linecorp.centraldogma.server.internal.api.converter.ChangesRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.CommitMessageRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.QueryRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.WatchRequestConverter;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOption;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@RequestConverter(value=CommitMessageRequestConverter.class)
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class ContentServiceV1
extends AbstractService {
    private final WatchService watchService;

    public ContentServiceV1(ProjectManager projectManager, CommandExecutor executor, WatchService watchService) {
        super(projectManager, executor);
        this.watchService = Objects.requireNonNull(watchService, "watchService");
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/list(?<path>(|/.*))$")
    @Decorator(value=HasReadPermission.class)
    public CompletableFuture<List<EntryDto<?>>> listFiles(@Param(value="path") String path, @Param(value="revision") @Default(value="-1") String revision, @RequestObject Repository repository) {
        String normalizedPath = ContentServiceV1.normalizePath(path);
        CompletableFuture future = new CompletableFuture();
        ContentServiceV1.listFiles(repository, normalizedPath, repository.normalizeNow(new Revision(revision)), FindOptions.NO_FETCH_CONTENT, future);
        return future;
    }

    private static void listFiles(Repository repository, String pathPattern, Revision normalizedRevision, Map<FindOption<?>, ?> options, CompletableFuture<List<EntryDto<?>>> result) {
        repository.find(normalizedRevision, pathPattern, options).handle(Functions.voidFunction((entries, thrown) -> {
            if (thrown != null) {
                result.completeExceptionally((Throwable)thrown);
                return;
            }
            if (Util.isValidFilePath((String)pathPattern) && entries.size() == 1 && ((Entry)entries.values().iterator().next()).type() == EntryType.DIRECTORY) {
                ContentServiceV1.listFiles(repository, pathPattern + "/*", normalizedRevision, options, result);
            } else {
                result.complete((List)entries.values().stream().map(entry -> DtoConverter.convert(repository, entry)).collect(ImmutableList.toImmutableList()));
            }
        }));
    }

    private static String normalizePath(String path) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            return "/*";
        }
        if (Util.isValidFilePath((String)path)) {
            return path;
        }
        if (Util.isValidDirPath((String)path)) {
            if (path.endsWith("/")) {
                return path + '*';
            }
            return path + "/*";
        }
        return path;
    }

    @Post(value="/projects/{projectName}/repos/{repoName}/contents")
    @Decorator(value=HasWritePermission.class)
    public CompletableFuture<PushResultDto> commit(@Param(value="revision") @Default(value="-1") String revision, @RequestObject Repository repository, @RequestObject Author author, @RequestObject CommitMessageDto commitMessage, @RequestObject(value=ChangesRequestConverter.class) Iterable<Change<?>> changes) {
        Revision normalizedRevision = repository.normalizeNow(new Revision(revision));
        CompletableFuture<Map<String, Change<?>>> changesFuture = repository.previewDiff(normalizedRevision, changes);
        return changesFuture.thenCompose(previewDiffs -> {
            long commitTimeMillis = System.currentTimeMillis();
            if (previewDiffs.isEmpty()) {
                throw new RedundantChangeException();
            }
            return this.push(commitTimeMillis, author, repository, normalizedRevision, commitMessage, previewDiffs.values()).toCompletableFuture().thenApply(rrev -> DtoConverter.convert(rrev, commitTimeMillis));
        });
    }

    private CompletableFuture<Revision> push(long commitTimeMills, Author author, Repository repository, Revision revision, CommitMessageDto commitMessage, Iterable<Change<?>> changes) {
        String summary = commitMessage.summary();
        String detail = commitMessage.detail();
        Markup markup = commitMessage.markup();
        return this.execute(Command.push((Long)commitTimeMills, author, repository.parent().name(), repository.name(), revision, summary, detail, markup, changes));
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/contents(?<path>(|/.*))$")
    @Decorator(value=HasReadPermission.class)
    public CompletableFuture<?> getFiles(@Param(value="path") String path, @Param(value="revision") @Default(value="-1") String revision, @RequestObject Repository repository, @RequestObject(value=WatchRequestConverter.class) Optional<WatchRequestConverter.WatchRequest> watchRequest, @RequestObject(value=QueryRequestConverter.class) Optional<Query<?>> query) {
        String normalizedPath = ContentServiceV1.normalizePath(path);
        if (watchRequest.isPresent()) {
            Revision lastKnownRevision = watchRequest.get().lastKnownRevision();
            long timeOutMillis = watchRequest.get().timeoutMillis();
            if (query.isPresent()) {
                return this.watchFile(repository, lastKnownRevision, query.get(), timeOutMillis);
            }
            return this.watchRepository(repository, lastKnownRevision, normalizedPath, timeOutMillis);
        }
        if (query.isPresent()) {
            return repository.get(new Revision(revision), query.get()).handle(HttpApiUtil.returnOrThrow(result -> DtoConverter.convert(repository, result)));
        }
        CompletableFuture future = new CompletableFuture();
        ContentServiceV1.listFiles(repository, normalizedPath, repository.normalizeNow(new Revision(revision)), ImmutableMap.of(), future);
        return future;
    }

    private CompletableFuture<?> watchFile(Repository repository, Revision lastKnownRevision, Query<?> query, long timeOutMillis) {
        CompletableFuture<Entry<?>> future = this.watchService.watchFile(repository, lastKnownRevision, query, timeOutMillis);
        return ((CompletableFuture)future.thenCompose(result -> ContentServiceV1.handleWatchFileSuccess(repository, query, result))).exceptionally(ContentServiceV1::handleWatchFailure);
    }

    private static CompletableFuture<Object> handleWatchFileSuccess(Repository repository, Query<?> query, Entry<?> entry) {
        Revision revision = entry.revision();
        EntryDto<?> entryDto = DtoConverter.convert(repository, entry);
        return repository.history(revision, revision, query.path()).thenApply(commits -> DtoConverter.convert((Commit)commits.get(0), entryDto));
    }

    private static CompletableFuture<Object> handleWatchRepositorySuccess(Repository repository, Revision revision, String pathPattern) {
        return repository.history(revision, revision, pathPattern).thenApply(commits -> DtoConverter.convert((Commit)commits.get(0), null));
    }

    private static Object handleWatchFailure(Throwable thrown) {
        if (Throwables.getRootCause((Throwable)thrown) instanceof CancellationException) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_MODIFIED);
        }
        return Exceptions.throwUnsafely((Throwable)thrown);
    }

    private CompletableFuture<?> watchRepository(Repository repository, Revision lastKnownRevision, String pathPattern, long timeOutMillis) {
        CompletableFuture<Revision> future = this.watchService.watchRepository(repository, lastKnownRevision, pathPattern, timeOutMillis);
        return ((CompletableFuture)future.thenCompose(revision -> ContentServiceV1.handleWatchRepositorySuccess(repository, revision, pathPattern))).exceptionally(ContentServiceV1::handleWatchFailure);
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/commits(?<revision>(|/.*))$")
    @Decorator(value=HasReadPermission.class)
    public CompletableFuture<?> listCommits(@Param(value="revision") String revision, @Param(value="path") @Default(value="/**") String path, @Param(value="to") Optional<String> to, @Param(value="maxCommits") Optional<Integer> maxCommits, @RequestObject Repository repository) {
        Revision toRevision;
        Revision fromRevision;
        if (Strings.isNullOrEmpty((String)revision) || "/".equalsIgnoreCase(revision)) {
            fromRevision = Revision.HEAD;
            toRevision = to.map(Revision::new).orElse(Revision.INIT);
        } else {
            fromRevision = new Revision(revision.substring(1));
            toRevision = to.map(Revision::new).orElse(fromRevision);
        }
        RevisionRange range = repository.normalizeNow(fromRevision, toRevision).toDescending();
        int maxCommits0 = maxCommits.map(integer -> Math.min(integer, 1024)).orElse(1024);
        return repository.history(range.from(), range.to(), ContentServiceV1.normalizePath(path), maxCommits0).thenApply(commits -> {
            boolean toList = Strings.isNullOrEmpty((String)revision) || "/".equalsIgnoreCase(revision) || to.isPresent();
            return ContentServiceV1.objectOrList(commits, toList, DtoConverter::convert);
        });
    }

    @Get(value="/projects/{projectName}/repos/{repoName}/compare")
    @Decorator(value=HasReadPermission.class)
    public CompletableFuture<?> getDiff(@Param(value="pathPattern") @Default(value="/**") String pathPattern, @Param(value="from") @Default(value="1") String from, @Param(value="to") @Default(value="head") String to, @RequestObject Repository repository, @RequestObject(value=QueryRequestConverter.class) Optional<Query<?>> query) {
        if (query.isPresent()) {
            return repository.diff(new Revision(from), new Revision(to), query.get()).thenApply(DtoConverter::convert);
        }
        return repository.diff(new Revision(from), new Revision(to), ContentServiceV1.normalizePath(pathPattern)).thenApply(changeMap -> (ImmutableList)changeMap.values().stream().map(DtoConverter::convert).collect(ImmutableList.toImmutableList()));
    }

    private static <T> Object objectOrList(Collection<T> collection, boolean toList, Function<T, ?> converter) {
        if (collection.isEmpty()) {
            return ImmutableList.of();
        }
        if (toList) {
            return collection.stream().map(converter).collect(ImmutableList.toImmutableList());
        }
        return converter.apply(Iterables.getOnlyElement(collection));
    }
}

