/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public final class WatchService {
    private static final CancellationException CANCELLATION_EXCEPTION = (CancellationException)Exceptions.clearTrace((Throwable)new CancellationException("watch timed out"));
    private static final double JITTER_RATE = 0.2;
    private final Set<CompletableFuture<?>> pendingFutures = Collections.newSetFromMap(new ConcurrentHashMap());

    public CompletableFuture<Revision> watchRepository(Repository repo, Revision lastKnownRevision, String pathPattern, long timeoutMillis) {
        CompletableFuture<Revision> result = repo.watch(lastKnownRevision, pathPattern);
        if (result.isDone()) {
            return result;
        }
        this.scheduleTimeout(result, timeoutMillis);
        return result;
    }

    public <T> CompletableFuture<Entry<T>> watchFile(Repository repo, Revision lastKnownRevision, Query<T> query, long timeoutMillis) {
        CompletableFuture<Entry<T>> result = repo.watch(lastKnownRevision, query);
        if (result.isDone()) {
            return result;
        }
        this.scheduleTimeout(result, timeoutMillis);
        return result;
    }

    private <T> void scheduleTimeout(CompletableFuture<T> result, long timeoutMillis) {
        ScheduledFuture timeoutFuture;
        this.pendingFutures.add(result);
        if (timeoutMillis > 0L) {
            timeoutMillis = WatchService.applyJitter(timeoutMillis);
            EventLoop eventLoop = RequestContext.current().eventLoop();
            timeoutFuture = eventLoop.schedule(() -> result.completeExceptionally(CANCELLATION_EXCEPTION), timeoutMillis, TimeUnit.MILLISECONDS);
        } else {
            timeoutFuture = null;
        }
        result.whenComplete((revision, cause) -> {
            if (timeoutFuture != null) {
                timeoutFuture.cancel(true);
            }
            this.pendingFutures.remove(result);
        });
    }

    private static long applyJitter(long timeoutMillis) {
        double rate = ThreadLocalRandom.current().nextDouble(0.8, 1.001);
        if (rate < 1.0) {
            return (long)((double)timeoutMillis * rate);
        }
        return timeoutMillis;
    }
}

