/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.metadata;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.jsonpatch.AddOperation;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchOperation;
import com.linecorp.centraldogma.internal.jsonpatch.RemoveIfExistsOperation;
import com.linecorp.centraldogma.internal.jsonpatch.RemoveOperation;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceOperation;
import com.linecorp.centraldogma.internal.jsonpatch.TestAbsenceOperation;
import com.linecorp.centraldogma.server.internal.admin.authentication.User;
import com.linecorp.centraldogma.server.internal.admin.authentication.UserWithToken;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.metadata.HolderWithRevision;
import com.linecorp.centraldogma.server.internal.metadata.Member;
import com.linecorp.centraldogma.server.internal.metadata.PerRolePermissions;
import com.linecorp.centraldogma.server.internal.metadata.Permission;
import com.linecorp.centraldogma.server.internal.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.internal.metadata.ProjectRole;
import com.linecorp.centraldogma.server.internal.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.internal.metadata.RepositoryUtil;
import com.linecorp.centraldogma.server.internal.metadata.Token;
import com.linecorp.centraldogma.server.internal.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.internal.metadata.Tokens;
import com.linecorp.centraldogma.server.internal.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.project.SafeProjectManager;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class MetadataService
extends AbstractService {
    public static final String METADATA_JSON = "/metadata.json";
    static final String TOKEN_JSON = "/tokens.json";
    private static final JsonPointer PROJECT_REMOVAL = JsonPointer.compile((String)"/removal");
    private final RepositoryUtil<ProjectMetadata> metadataRepo;
    private final RepositoryUtil<Tokens> tokenRepo;

    public MetadataService(ProjectManager projectManager, CommandExecutor executor) {
        super(projectManager, executor);
        this.metadataRepo = new RepositoryUtil<ProjectMetadata>(projectManager, executor, entry -> RepositoryUtil.convertWithJackson(entry, ProjectMetadata.class));
        this.tokenRepo = new RepositoryUtil<Tokens>(projectManager, executor, entry -> RepositoryUtil.convertWithJackson(entry, Tokens.class));
    }

    public CompletableFuture<ProjectMetadata> getProject(String projectName) {
        Objects.requireNonNull(projectName, "projectName");
        return this.fetchMetadata(projectName).thenApply(HolderWithRevision::object);
    }

    private CompletableFuture<HolderWithRevision<ProjectMetadata>> fetchMetadata(String projectName) {
        return this.metadataRepo.fetch(projectName, "dogma", METADATA_JSON);
    }

    public CompletableFuture<Revision> removeProject(Author author, String projectName) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new TestAbsenceOperation(PROJECT_REMOVAL), new AddOperation(PROJECT_REMOVAL, Jackson.valueToTree((Object)UserAndTimestamp.of(author)))}));
        return this.metadataRepo.push(projectName, "dogma", author, "Remove the project: " + projectName, change);
    }

    public CompletableFuture<Revision> restoreProject(Author author, String projectName) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)new RemoveOperation(PROJECT_REMOVAL).toJsonNode());
        return this.metadataRepo.push(projectName, "dogma", author, "Restore the project: " + projectName, change);
    }

    public CompletableFuture<Member> getMember(String projectName, User user) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(user, "user");
        return this.getProject(projectName).thenApply(project -> project.memberOrDefault(user.id(), null));
    }

    public CompletableFuture<Revision> addMember(Author author, String projectName, User member, ProjectRole projectRole) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(member, "member");
        Objects.requireNonNull(projectRole, "projectRole");
        Member newMember = new Member(member, projectRole, UserAndTimestamp.of(author));
        JsonPointer path = JsonPointer.compile((String)("/members/" + newMember.id()));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new TestAbsenceOperation(path), new AddOperation(path, Jackson.valueToTree((Object)newMember))}));
        String commitSummary = "Add a member '" + newMember.id() + "' to the project " + projectName;
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> removeMember(Author author, String projectName, User member) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(member, "member");
        String commitSummary = "Remove the member '" + member.id() + "' from the project " + projectName;
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, () -> this.fetchMetadata(projectName).thenApply(metadataWithRevision -> {
            ImmutableList.Builder patches = ImmutableList.builder();
            ((ProjectMetadata)metadataWithRevision.object()).repos().values().stream().filter(r -> r.perUserPermissions().containsKey(member.id())).forEach(r -> patches.add((Object)new RemoveOperation(MetadataService.perUserPermissionPointer(r.name(), member.id()))));
            patches.add((Object)new RemoveOperation(JsonPointer.compile((String)("/members/" + member.id()))));
            Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)Jackson.valueToTree((Object)patches.build()));
            return HolderWithRevision.of(change, metadataWithRevision.revision());
        }));
    }

    public CompletableFuture<Revision> updateMemberRole(Author author, String projectName, User member, ProjectRole projectRole) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(member, "member");
        Objects.requireNonNull(projectRole, "projectRole");
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)new ReplaceOperation(JsonPointer.compile((String)("/members/" + member.id() + "/role")), Jackson.valueToTree((Object)((Object)projectRole))).toJsonNode());
        String commitSummary = "Updates the role of the member '" + member.id() + "' as '" + (Object)((Object)projectRole) + "' for the project " + projectName;
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<RepositoryMetadata> getRepo(String projectName, String repoName) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        return this.getProject(projectName).thenApply(project -> project.repo(repoName));
    }

    public CompletableFuture<Revision> addRepo(Author author, String projectName, String repoName) {
        return this.addRepo(author, projectName, repoName, PerRolePermissions.DEFAULT);
    }

    public CompletableFuture<Revision> addRepo(Author author, String projectName, String repoName, PerRolePermissions permission) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(permission, "permission");
        JsonPointer path = JsonPointer.compile((String)("/repos/" + repoName));
        RepositoryMetadata newRepositoryMetadata = new RepositoryMetadata(repoName, UserAndTimestamp.of(author), permission);
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new TestAbsenceOperation(path), new AddOperation(path, Jackson.valueToTree((Object)newRepositoryMetadata))}));
        String commitSummary = "Add a repo '" + newRepositoryMetadata.id() + "' to the project " + projectName;
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change).handle((revision, cause) -> {
            if (cause != null) {
                if (Exceptions.peel((Throwable)cause) instanceof ChangeConflictException) {
                    throw new RepositoryExistsException(repoName);
                }
                return (Revision)Exceptions.throwUnsafely((Throwable)cause);
            }
            return revision;
        });
    }

    public CompletableFuture<Revision> removeRepo(Author author, String projectName, String repoName) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        JsonPointer path = JsonPointer.compile((String)("/repos/" + repoName + "/removal"));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new TestAbsenceOperation(path), new AddOperation(path, Jackson.valueToTree((Object)UserAndTimestamp.of(author)))}));
        String commitSummary = "Remove the repo '" + repoName + "' from the project " + projectName;
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> restoreRepo(Author author, String projectName, String repoName) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)new RemoveOperation(JsonPointer.compile((String)("/repos/" + repoName + "/removal"))).toJsonNode());
        String commitSummary = "Restore the repo '" + repoName + "' from the project " + projectName;
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> updatePerRolePermissions(Author author, String projectName, String repoName, PerRolePermissions perRolePermissions) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(perRolePermissions, "perRolePermissions");
        JsonPointer path = JsonPointer.compile((String)("/repos/" + repoName + "/perRolePermissions"));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)new ReplaceOperation(path, Jackson.valueToTree((Object)perRolePermissions)).toJsonNode());
        String commitSummary = "Update the role permission of the '" + repoName + "' in the project " + projectName;
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> addToken(Author author, String projectName, Token token, ProjectRole role) {
        return this.addToken(author, projectName, Objects.requireNonNull(token, "token").appId(), role);
    }

    public CompletableFuture<Revision> addToken(Author author, String projectName, String appId, ProjectRole role) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(appId, "appId");
        Objects.requireNonNull(role, "role");
        return this.getTokens().thenCompose(tokens -> {
            Token token = tokens.appIds().get(appId);
            Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)("Token not found: " + appId));
            TokenRegistration registration = new TokenRegistration(appId, role, UserAndTimestamp.of(author));
            JsonPointer path = JsonPointer.compile((String)("/tokens/" + registration.id()));
            Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new TestAbsenceOperation(path), new AddOperation(path, Jackson.valueToTree((Object)registration))}));
            String commitSummary = "Add a token '" + registration.id() + "' to the project " + projectName + " with a role '" + (Object)((Object)role) + '\'';
            return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
        });
    }

    public CompletableFuture<Revision> removeToken(Author author, String projectName, Token token) {
        return this.removeToken(author, projectName, Objects.requireNonNull(token, "token").appId());
    }

    public CompletableFuture<Revision> removeToken(Author author, String projectName, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(appId, "appId");
        return this.removeToken(projectName, author, appId, false);
    }

    private CompletableFuture<Revision> removeToken(String projectName, Author author, String appId, boolean quiet) {
        String commitSummary = "Remove the token '" + appId + "' from the project " + projectName;
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, () -> this.fetchMetadata(projectName).thenApply(metadataWithRevision -> {
            ImmutableList.Builder patches = ImmutableList.builder();
            ProjectMetadata metadata = (ProjectMetadata)metadataWithRevision.object();
            metadata.repos().values().stream().filter(repo -> repo.perTokenPermissions().containsKey(appId)).forEach(r -> patches.add((Object)new RemoveOperation(MetadataService.perTokenPermissionPointer(r.name(), appId))));
            if (quiet) {
                patches.add((Object)new RemoveIfExistsOperation(JsonPointer.compile((String)("/tokens/" + appId))));
            } else {
                patches.add((Object)new RemoveOperation(JsonPointer.compile((String)("/tokens/" + appId))));
            }
            Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)Jackson.valueToTree((Object)patches.build()));
            return HolderWithRevision.of(change, metadataWithRevision.revision());
        }));
    }

    public CompletableFuture<Revision> updateTokenRole(Author author, String projectName, Token token, ProjectRole role) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(token, "token");
        Objects.requireNonNull(role, "role");
        TokenRegistration registration = new TokenRegistration(token.appId(), role, UserAndTimestamp.of(author));
        JsonPointer path = JsonPointer.compile((String)("/tokens/" + registration.id()));
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)new ReplaceOperation(path, Jackson.valueToTree((Object)registration)).toJsonNode());
        String commitSummary = "Update the role of a token '" + token.appId() + "' as '" + (Object)((Object)role) + "' for the project " + projectName;
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Revision> addPerUserPermission(Author author, String projectName, String repoName, User member, Collection<Permission> permission) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(member, "member");
        Objects.requireNonNull(permission, "permission");
        return this.getProject(projectName).thenCompose(project -> {
            MetadataService.ensureProjectMember(project, member);
            return this.addPermissionAtPointer(author, projectName, MetadataService.perUserPermissionPointer(repoName, member.id()), permission, "Add permission of '" + member.id() + "' as '" + permission + "' to the project " + projectName);
        });
    }

    public CompletableFuture<Revision> removePerUserPermission(Author author, String projectName, String repoName, User member) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(member, "member");
        String memberId = member.id();
        return this.removePermissionAtPointer(author, projectName, MetadataService.perUserPermissionPointer(repoName, memberId), "Remove permission of the '" + memberId + "' from the project " + projectName);
    }

    public CompletableFuture<Revision> updatePerUserPermission(Author author, String projectName, String repoName, User member, Collection<Permission> permission) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(member, "member");
        Objects.requireNonNull(permission, "permission");
        String memberId = member.id();
        return this.replacePermissionAtPointer(author, projectName, MetadataService.perUserPermissionPointer(repoName, memberId), permission, "Update permission of the '" + memberId + "' as '" + permission + "' for the project " + projectName);
    }

    public CompletableFuture<Revision> addPerTokenPermission(Author author, String projectName, String repoName, String appId, Collection<Permission> permission) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(appId, "appId");
        Objects.requireNonNull(permission, "permission");
        return this.getProject(projectName).thenCompose(project -> {
            MetadataService.ensureProjectToken(project, appId);
            return this.addPermissionAtPointer(author, projectName, MetadataService.perTokenPermissionPointer(repoName, appId), permission, "Add permission of the token '" + appId + "' as '" + permission + "' to the project " + projectName);
        });
    }

    public CompletableFuture<Revision> removePerTokenPermission(Author author, String projectName, String repoName, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(appId, "appId");
        return this.removePermissionAtPointer(author, projectName, MetadataService.perTokenPermissionPointer(repoName, appId), "Remove permission of the token '" + appId + "' from the project " + projectName);
    }

    public CompletableFuture<Revision> updatePerTokenPermission(Author author, String projectName, String repoName, String appId, Collection<Permission> permission) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(appId, "appId");
        Objects.requireNonNull(permission, "permission");
        return this.replacePermissionAtPointer(author, projectName, MetadataService.perTokenPermissionPointer(repoName, appId), permission, "Update permission of the token '" + appId + "' as '" + permission + "' for the project " + projectName);
    }

    private CompletableFuture<Revision> addPermissionAtPointer(Author author, String projectName, JsonPointer path, Collection<Permission> permission, String commitSummary) {
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new TestAbsenceOperation(path), new AddOperation(path, Jackson.valueToTree(permission))}));
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    private CompletableFuture<Revision> removePermissionAtPointer(Author author, String projectName, JsonPointer path, String commitSummary) {
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)new RemoveOperation(path).toJsonNode());
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    private CompletableFuture<Revision> replacePermissionAtPointer(Author author, String projectName, JsonPointer path, Collection<Permission> permission, String commitSummary) {
        Change change = Change.ofJsonPatch((String)METADATA_JSON, (JsonNode)new ReplaceOperation(path, Jackson.valueToTree(permission)).toJsonNode());
        return this.metadataRepo.push(projectName, "dogma", author, commitSummary, change);
    }

    public CompletableFuture<Collection<Permission>> findPermissions(String projectName, String repoName, User user) {
        Objects.requireNonNull(user, "user");
        if (user.isAdmin()) {
            return CompletableFuture.completedFuture(PerRolePermissions.ALL_PERMISSION);
        }
        if (user instanceof UserWithToken) {
            return this.findPermissions(projectName, repoName, ((UserWithToken)user).token().appId());
        }
        return this.findPermissions0(projectName, repoName, user);
    }

    public CompletableFuture<Collection<Permission>> findPermissions(String projectName, String repoName, String appId) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(appId, "appId");
        return this.getProject(projectName).thenApply(metadata -> {
            RepositoryMetadata repositoryMetadata = metadata.repo(repoName);
            TokenRegistration registration = metadata.tokens().getOrDefault(appId, null);
            if (registration == null) {
                return repositoryMetadata.perRolePermissions().guest();
            }
            Collection<Permission> p = repositoryMetadata.perTokenPermissions().get(registration.id());
            if (p != null) {
                return p;
            }
            return MetadataService.findPerRolePermissions(repositoryMetadata, registration.role());
        });
    }

    private CompletableFuture<Collection<Permission>> findPermissions0(String projectName, String repoName, User user) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(user, "user");
        return this.getProject(projectName).thenApply(metadata -> {
            RepositoryMetadata repositoryMetadata = metadata.repo(repoName);
            Member member = metadata.memberOrDefault(user.id(), null);
            if (member == null) {
                return repositoryMetadata.perRolePermissions().guest();
            }
            Collection<Permission> p = repositoryMetadata.perUserPermissions().get(member.id());
            if (p != null) {
                return p;
            }
            return MetadataService.findPerRolePermissions(repositoryMetadata, member.role());
        });
    }

    private static Collection<Permission> findPerRolePermissions(RepositoryMetadata repositoryMetadata, ProjectRole role) {
        switch (role) {
            case OWNER: {
                return repositoryMetadata.perRolePermissions().owner();
            }
            case MEMBER: {
                return repositoryMetadata.perRolePermissions().member();
            }
        }
        return repositoryMetadata.perRolePermissions().guest();
    }

    public CompletableFuture<ProjectRole> findRole(String projectName, User user) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(user, "user");
        if (user.isAdmin()) {
            return CompletableFuture.completedFuture(ProjectRole.OWNER);
        }
        return this.getProject(projectName).thenApply(project -> {
            if (user instanceof UserWithToken) {
                TokenRegistration registration = project.tokens().getOrDefault(((UserWithToken)user).token().id(), null);
                return registration != null ? registration.role() : ProjectRole.GUEST;
            }
            Member member = project.memberOrDefault(user.id(), null);
            return member != null ? member.role() : ProjectRole.GUEST;
        });
    }

    public CompletableFuture<Tokens> getTokens() {
        return this.tokenRepo.fetch("dogma", "dogma", TOKEN_JSON).thenApply(HolderWithRevision::object);
    }

    public CompletableFuture<Revision> createToken(Author author, String appId) {
        return this.createToken(author, appId, false);
    }

    public CompletableFuture<Revision> createToken(Author author, String appId, boolean isAdmin) {
        return this.createToken(author, appId, "appToken-" + UUID.randomUUID(), isAdmin);
    }

    public CompletableFuture<Revision> createToken(Author author, String appId, String secret) {
        return this.createToken(author, appId, secret, false);
    }

    public CompletableFuture<Revision> createToken(Author author, String appId, String secret, boolean isAdmin) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        Objects.requireNonNull(secret, "secret");
        Preconditions.checkArgument((boolean)secret.startsWith("appToken-"), (Object)"secret must start with: appToken-");
        Token newToken = new Token(appId, secret, isAdmin, UserAndTimestamp.of(author));
        JsonPointer appIdPath = JsonPointer.compile((String)("/appIds/" + newToken.id()));
        JsonPointer secretPath = JsonPointer.compile((String)("/secrets/" + newToken.secret()));
        Change change = Change.ofJsonPatch((String)TOKEN_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new TestAbsenceOperation(appIdPath), new TestAbsenceOperation(secretPath), new AddOperation(appIdPath, Jackson.valueToTree((Object)newToken)), new AddOperation(secretPath, Jackson.valueToTree((Object)newToken.id()))}));
        return this.tokenRepo.push("dogma", "dogma", author, "Add a token: '" + newToken.id(), change);
    }

    public CompletableFuture<Revision> destroyToken(Author author, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        Collection<Project> projects = new SafeProjectManager(this.projectManager()).list().values();
        CompletableFuture[] futures = new CompletableFuture[projects.size()];
        int i = 0;
        for (Project p : projects) {
            futures[i++] = this.removeToken(p.name(), author, appId, true).toCompletableFuture();
        }
        return CompletableFuture.allOf(futures).thenCompose(unused -> this.tokenRepo.push("dogma", "dogma", author, "Remove the token: '" + appId, () -> this.tokenRepo.fetch("dogma", "dogma", TOKEN_JSON).thenApply(tokens -> {
            Token token = ((Tokens)tokens.object()).get(appId);
            JsonPointer appIdPath = JsonPointer.compile((String)("/appIds/" + appId));
            JsonPointer secretPath = JsonPointer.compile((String)("/secrets/" + token.secret()));
            Change change = Change.ofJsonPatch((String)TOKEN_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new RemoveOperation(appIdPath), new RemoveIfExistsOperation(secretPath)}));
            return HolderWithRevision.of(change, tokens.revision());
        })));
    }

    public CompletableFuture<Revision> activateToken(Author author, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        return this.tokenRepo.push("dogma", "dogma", author, "Enable the token: '" + appId, () -> this.tokenRepo.fetch("dogma", "dogma", TOKEN_JSON).thenApply(tokens -> {
            Token token = ((Tokens)tokens.object()).get(appId);
            JsonPointer removalPath = JsonPointer.compile((String)("/appIds/" + appId + "/deactivation"));
            JsonPointer secretPath = JsonPointer.compile((String)("/secrets/" + token.secret()));
            Change change = Change.ofJsonPatch((String)TOKEN_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new RemoveOperation(removalPath), new AddOperation(secretPath, Jackson.valueToTree((Object)appId))}));
            return HolderWithRevision.of(change, tokens.revision());
        }));
    }

    public CompletableFuture<Revision> deactivateToken(Author author, String appId) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(appId, "appId");
        return this.tokenRepo.push("dogma", "dogma", author, "Disable the token: '" + appId, () -> this.tokenRepo.fetch("dogma", "dogma", TOKEN_JSON).thenApply(tokens -> {
            Token token = ((Tokens)tokens.object()).get(appId);
            JsonPointer removalPath = JsonPointer.compile((String)("/appIds/" + appId + "/deactivation"));
            JsonPointer secretPath = JsonPointer.compile((String)("/secrets/" + token.secret()));
            Change change = Change.ofJsonPatch((String)TOKEN_JSON, (JsonNode)JsonPatchOperation.asJsonArray((JsonPatchOperation[])new JsonPatchOperation[]{new TestAbsenceOperation(removalPath), new AddOperation(removalPath, Jackson.valueToTree((Object)UserAndTimestamp.of(author))), new RemoveOperation(secretPath)}));
            return HolderWithRevision.of(change, tokens.revision());
        }));
    }

    public CompletableFuture<Token> findTokenByAppId(String appId) {
        Objects.requireNonNull(appId, "appId");
        return this.tokenRepo.fetch("dogma", "dogma", TOKEN_JSON).thenApply(tokens -> ((Tokens)tokens.object()).get(appId));
    }

    public CompletableFuture<Token> findTokenBySecret(String secret) {
        Objects.requireNonNull(secret, "secret");
        Tokens.validateSecret(secret);
        return this.tokenRepo.fetch("dogma", "dogma", TOKEN_JSON).thenApply(tokens -> ((Tokens)tokens.object()).findBySecret(secret));
    }

    private static void ensureProjectMember(ProjectMetadata project, User user) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(user, "user");
        Preconditions.checkArgument((boolean)project.members().values().stream().anyMatch(member -> member.login().equals(user.id())), (Object)(user.id() + " is not a member of the project " + project.name()));
    }

    private static void ensureProjectToken(ProjectMetadata project, String appId) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(appId, "appId");
        Preconditions.checkArgument((boolean)project.tokens().containsKey(appId), (Object)(appId + " is not a token of the project " + project.name()));
    }

    private static JsonPointer perUserPermissionPointer(String repoName, String memberId) {
        return JsonPointer.compile((String)("/repos/" + repoName + "/perUserPermissions/" + memberId));
    }

    private static JsonPointer perTokenPermissionPointer(String repoName, String appId) {
        return JsonPointer.compile((String)("/repos/" + repoName + "/perTokenPermissions/" + appId));
    }
}

