/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.linecorp.centraldogma.server.MirrorException;
import com.linecorp.centraldogma.server.MirroringService;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.mirror.Mirror;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.spotify.futures.FuturesExtra;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMirroringService
implements MirroringService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMirroringService.class);
    private static final Duration TICK = Duration.ofSeconds(1L);
    private final File workDir;
    private final ProjectManager projectManager;
    private final int numThreads;
    private final int maxNumFilesPerMirror;
    private final long maxNumBytesPerMirror;
    private volatile CommandExecutor commandExecutor;
    private volatile ListeningScheduledExecutorService scheduler;
    private volatile ListeningExecutorService worker;
    private ZonedDateTime lastExecutionTime;

    public DefaultMirroringService(File workDir, ProjectManager projectManager, int numThreads, int maxNumFilesPerMirror, long maxNumBytesPerMirror) {
        this.workDir = Objects.requireNonNull(workDir, "workDir");
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (String)"numThreads: %s (expected: > 0)", (int)numThreads);
        Preconditions.checkArgument((maxNumFilesPerMirror > 0 ? 1 : 0) != 0, (String)"maxNumFilesPerMirror: %s (expected: > 0)", (int)maxNumFilesPerMirror);
        Preconditions.checkArgument((maxNumBytesPerMirror > 0L ? 1 : 0) != 0, (String)"maxNumBytesPerMirror: %s (expected: > 0)", (long)maxNumBytesPerMirror);
        this.numThreads = numThreads;
        this.maxNumFilesPerMirror = maxNumFilesPerMirror;
        this.maxNumBytesPerMirror = maxNumBytesPerMirror;
    }

    public boolean isStarted() {
        return this.scheduler != null;
    }

    public synchronized void start(CommandExecutor commandExecutor) {
        if (this.isStarted()) {
            return;
        }
        this.commandExecutor = Objects.requireNonNull(commandExecutor, "commandExecutor");
        this.scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("mirroring-scheduler", true)));
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        this.worker = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(0, this.numThreads, 90L, TimeUnit.SECONDS, workQueue, (ThreadFactory)new DefaultThreadFactory("mirroring-worker", true), (rejectedTask, executor) -> {
            try {
                workQueue.put(rejectedTask);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }));
        ListenableScheduledFuture future = this.scheduler.scheduleWithFixedDelay(this::schedulePendingMirrors, TICK.getSeconds(), TICK.getSeconds(), TimeUnit.SECONDS);
        FuturesExtra.addFailureCallback((ListenableFuture)future, cause -> logger.error("Git-to-CD mirroring scheduler stopped due to an unexpected exception:", cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        ListeningScheduledExecutorService scheduler = this.scheduler;
        ListeningExecutorService worker = this.worker;
        try {
            boolean interrupted;
            boolean bl = interrupted = DefaultMirroringService.terminate((ExecutorService)scheduler) || DefaultMirroringService.terminate((ExecutorService)worker);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.scheduler = null;
            this.worker = null;
        }
    }

    private static boolean terminate(ExecutorService executor) {
        if (executor == null) {
            return false;
        }
        boolean interrupted = false;
        while (true) {
            executor.shutdownNow();
            try {
                if (!executor.awaitTermination(1L, TimeUnit.MINUTES)) continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        return interrupted;
    }

    private void schedulePendingMirrors() {
        ZonedDateTime now = ZonedDateTime.now();
        if (this.lastExecutionTime == null) {
            this.lastExecutionTime = now.minus(TICK);
        }
        ZonedDateTime currentLastExecutionTime = this.lastExecutionTime;
        this.lastExecutionTime = now;
        this.projectManager.list().values().stream().map(Project::metaRepo).flatMap(r -> {
            try {
                return r.mirrors().stream();
            }
            catch (Exception e) {
                logger.warn("Failed to load the mirror list from: {}", (Object)r.parent().name(), (Object)e);
                return Stream.empty();
            }
        }).filter(m -> m.nextExecutionTime(currentLastExecutionTime).compareTo(now) < 0).forEach(m -> {
            ListenableFuture future = this.worker.submit(() -> this.run((Mirror)m, true));
            FuturesExtra.addFailureCallback((ListenableFuture)future, cause -> logger.warn("Unexpected Git-to-CD mirroring failure: {}", m, cause));
        });
    }

    @Override
    public CompletableFuture<Void> mirror() {
        if (this.commandExecutor == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> this.projectManager.list().values().forEach(p -> p.metaRepo().mirrors().forEach(m -> this.run((Mirror)m, false))), (Executor)this.worker);
    }

    private void run(Mirror m, boolean logOnFailure) {
        logger.info("Mirroring: {}", (Object)m);
        try {
            m.mirror(this.workDir, this.commandExecutor, this.maxNumFilesPerMirror, this.maxNumBytesPerMirror);
        }
        catch (Exception e) {
            if (logOnFailure) {
                logger.warn("Unexpected exception while mirroring: {}", (Object)m, (Object)e);
            }
            if (e instanceof MirrorException) {
                throw (MirrorException)e;
            }
            throw new MirrorException(e);
        }
    }
}

