/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.metadata.Member;
import com.linecorp.centraldogma.server.internal.metadata.PerRolePermissions;
import com.linecorp.centraldogma.server.internal.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.internal.metadata.ProjectRole;
import com.linecorp.centraldogma.server.internal.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.internal.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.internal.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.internal.plugin.PluginManager;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.repository.DefaultMetaRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryManager;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CachingRepositoryManager;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepositoryManager;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultProject
implements Project {
    private static final Logger logger = LoggerFactory.getLogger(DefaultProject.class);
    private final String name;
    final RepositoryManager repos;
    private final AtomicReference<MetaRepository> metaRepo = new AtomicReference();
    private PluginManager plugins;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultProject(File rootDir, Executor repositoryWorker, @Nullable RepositoryCache cache) {
        Objects.requireNonNull(rootDir, "rootDir");
        Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        if (!rootDir.exists()) {
            throw new ProjectNotFoundException(rootDir.toString());
        }
        this.name = rootDir.getName();
        this.repos = this.newRepoManager(rootDir, repositoryWorker, cache);
        boolean success = false;
        try {
            this.createReservedRepos(System.currentTimeMillis());
            success = true;
        }
        finally {
            if (!success) {
                this.repos.close(() -> new CentralDogmaException("failed to initialize internal repositories"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultProject(File rootDir, Executor repositoryWorker, @Nullable RepositoryCache cache, long creationTimeMillis, Author author) {
        Objects.requireNonNull(rootDir, "rootDir");
        Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        if (rootDir.exists()) {
            throw new ProjectExistsException(rootDir.getName());
        }
        this.name = rootDir.getName();
        this.repos = this.newRepoManager(rootDir, repositoryWorker, cache);
        boolean success = false;
        try {
            this.createReservedRepos(creationTimeMillis);
            this.initializeMetadata(creationTimeMillis, author);
            success = true;
        }
        finally {
            if (!success) {
                this.repos.close(() -> new CentralDogmaException("failed to initialize internal repositories"));
            }
        }
    }

    private RepositoryManager newRepoManager(File rootDir, Executor repositoryWorker, @Nullable RepositoryCache cache) {
        GitRepositoryManager gitRepos = new GitRepositoryManager(this, rootDir, repositoryWorker);
        return cache == null ? gitRepos : new CachingRepositoryManager((RepositoryManager)gitRepos, cache);
    }

    private void createReservedRepos(long creationTimeMillis) {
        if (!this.repos.exists("dogma")) {
            try {
                this.repos.create("dogma", creationTimeMillis, Author.SYSTEM);
            }
            catch (RepositoryExistsException repositoryExistsException) {
                // empty catch block
            }
        }
        if (!this.repos.exists("meta")) {
            try {
                this.repos.create("meta", creationTimeMillis, Author.SYSTEM);
            }
            catch (RepositoryExistsException repositoryExistsException) {
                // empty catch block
            }
        }
    }

    private void initializeMetadata(long creationTimeMillis, Author author) {
        Revision headRev;
        if (this.name.equals("dogma")) {
            return;
        }
        Repository dogmaRepo = (Repository)this.repos.get("dogma");
        if (!dogmaRepo.exists(headRev = dogmaRepo.normalizeNow(Revision.HEAD), "/metadata.json").join().booleanValue()) {
            logger.info("Initializing metadata: {}", (Object)this.name);
            UserAndTimestamp userAndTimestamp = UserAndTimestamp.of(author);
            RepositoryMetadata repo = new RepositoryMetadata("meta", userAndTimestamp, PerRolePermissions.DEFAULT);
            Member member = new Member(author, ProjectRole.OWNER, userAndTimestamp);
            ProjectMetadata metadata = new ProjectMetadata(this.name, (Map<String, RepositoryMetadata>)ImmutableMap.of((Object)repo.id(), (Object)repo), (Map<String, Member>)ImmutableMap.of((Object)member.id(), (Object)member), (Map<String, TokenRegistration>)ImmutableMap.of(), userAndTimestamp, null);
            dogmaRepo.commit(headRev, creationTimeMillis, Author.SYSTEM, "Initialize metadata", "", Markup.PLAINTEXT, Change.ofJsonUpsert((String)"/metadata.json", (JsonNode)Jackson.valueToTree((Object)metadata))).join();
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public MetaRepository metaRepo() {
        MetaRepository metaRepo = this.metaRepo.get();
        if (metaRepo != null) {
            return metaRepo;
        }
        metaRepo = new DefaultMetaRepository((Repository)this.repos.get("meta"));
        if (this.metaRepo.compareAndSet(null, metaRepo)) {
            return metaRepo;
        }
        return this.metaRepo.get();
    }

    @Override
    public RepositoryManager repos() {
        return this.repos;
    }

    @Override
    public synchronized PluginManager plugins() {
        if (this.plugins != null) {
            return this.plugins;
        }
        this.plugins = new PluginManager(this);
        return this.plugins;
    }

    public String toString() {
        return Util.simpleTypeName(this.getClass()) + '(' + this.repos + ')';
    }
}

