/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.thrift;

import com.google.common.base.MoreObjects;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.thrift.Author;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaConstants;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaException;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaService;
import com.linecorp.centraldogma.internal.thrift.Change;
import com.linecorp.centraldogma.internal.thrift.Comment;
import com.linecorp.centraldogma.internal.thrift.DiffFileResult;
import com.linecorp.centraldogma.internal.thrift.ErrorCode;
import com.linecorp.centraldogma.internal.thrift.GetFileResult;
import com.linecorp.centraldogma.internal.thrift.NamedQuery;
import com.linecorp.centraldogma.internal.thrift.Plugin;
import com.linecorp.centraldogma.internal.thrift.Query;
import com.linecorp.centraldogma.internal.thrift.Schema;
import com.linecorp.centraldogma.internal.thrift.WatchFileResult;
import com.linecorp.centraldogma.internal.thrift.WatchRepositoryResult;
import com.linecorp.centraldogma.server.internal.api.WatchService;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.metadata.MetadataService;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import com.linecorp.centraldogma.server.internal.thrift.CentralDogmaExceptions;
import com.linecorp.centraldogma.server.internal.thrift.Converter;
import com.spotify.futures.CompletableFutures;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.thrift.async.AsyncMethodCallback;

public class CentralDogmaServiceImpl
implements CentralDogmaService.AsyncIface {
    private static final IllegalArgumentException RESERVED_REPOSITORY_EXCEPTION = (IllegalArgumentException)Exceptions.clearTrace((Throwable)new IllegalArgumentException("The repository is reserved by system and thus cannot be created or removed."));
    private final ProjectManager projectManager;
    private final CommandExecutor executor;
    private final WatchService watchService;
    private final MetadataService mds;

    public CentralDogmaServiceImpl(ProjectManager projectManager, CommandExecutor executor, WatchService watchService, MetadataService mds) {
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.watchService = Objects.requireNonNull(watchService, "watchService");
        this.mds = Objects.requireNonNull(mds, "mds");
    }

    private static void handle(CompletableFuture<?> future, AsyncMethodCallback resultHandler) {
        future.handle((res, cause) -> {
            if (cause != null) {
                resultHandler.onError((Exception)Converter.convert(cause));
            } else {
                resultHandler.onComplete(res);
            }
            return null;
        });
    }

    private static void handle(Callable<?> task, AsyncMethodCallback resultHandler) {
        try {
            resultHandler.onComplete(task.call());
        }
        catch (Throwable cause) {
            resultHandler.onError((Exception)Converter.convert(cause));
        }
    }

    private static void handleAsVoidResult(CompletableFuture<?> future, AsyncMethodCallback resultHandler) {
        future.handle((res, cause) -> {
            if (cause != null) {
                resultHandler.onError((Exception)Converter.convert(cause));
            } else {
                resultHandler.onComplete(null);
            }
            return null;
        });
    }

    public void createProject(String name, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(this.executor.execute(Command.createProject(com.linecorp.centraldogma.common.Author.SYSTEM, name)), resultHandler);
    }

    public void removeProject(String name, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(this.mds.removeProject(com.linecorp.centraldogma.common.Author.SYSTEM, name).thenCompose(unused -> this.executor.execute(Command.removeProject(com.linecorp.centraldogma.common.Author.SYSTEM, name))), resultHandler);
    }

    public void unremoveProject(String name, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handleAsVoidResult(this.executor.execute(Command.unremoveProject(com.linecorp.centraldogma.common.Author.SYSTEM, name)).thenCompose(unused -> this.mds.restoreProject(com.linecorp.centraldogma.common.Author.SYSTEM, name)), resultHandler);
    }

    public void listProjects(AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(() -> {
            Map projects = this.projectManager.list();
            ArrayList ret = new ArrayList(projects.size());
            projects.forEach((key, value) -> ret.add(Converter.convert(key, value)));
            return ret;
        }, resultHandler);
    }

    public void listRemovedProjects(AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(this.projectManager::listRemoved, resultHandler);
    }

    public void createRepository(String projectName, String repositoryName, AsyncMethodCallback resultHandler) {
        if (Project.isReservedRepoName(repositoryName)) {
            resultHandler.onError((Exception)Converter.convert(RESERVED_REPOSITORY_EXCEPTION));
            return;
        }
        CentralDogmaServiceImpl.handleAsVoidResult(this.executor.execute(Command.createRepository(com.linecorp.centraldogma.common.Author.SYSTEM, projectName, repositoryName)).thenCompose(unused -> this.mds.addRepo(com.linecorp.centraldogma.common.Author.SYSTEM, projectName, repositoryName)), resultHandler);
    }

    public void removeRepository(String projectName, String repositoryName, AsyncMethodCallback resultHandler) {
        if (Project.isReservedRepoName(repositoryName)) {
            resultHandler.onError((Exception)Converter.convert(RESERVED_REPOSITORY_EXCEPTION));
            return;
        }
        CentralDogmaServiceImpl.handleAsVoidResult(this.executor.execute(Command.removeRepository(com.linecorp.centraldogma.common.Author.SYSTEM, projectName, repositoryName)).thenCompose(unused -> this.mds.removeRepo(com.linecorp.centraldogma.common.Author.SYSTEM, projectName, repositoryName)), resultHandler);
    }

    public void unremoveRepository(String projectName, String repositoryName, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handleAsVoidResult(this.executor.execute(Command.unremoveRepository(com.linecorp.centraldogma.common.Author.SYSTEM, projectName, repositoryName)).thenCompose(unused -> this.mds.restoreRepo(com.linecorp.centraldogma.common.Author.SYSTEM, projectName, repositoryName)), resultHandler);
    }

    public void listRepositories(String projectName, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(CompletableFutures.allAsList(((Project)this.projectManager.get(projectName)).repos().list().entrySet().stream().map(e -> Converter.convert((String)e.getKey(), (Repository)e.getValue())).collect(Collectors.toList())), resultHandler);
    }

    public void listRemovedRepositories(String projectName, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(() -> ((Project)this.projectManager.get(projectName)).repos().listRemoved(), resultHandler);
    }

    public void normalizeRevision(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision revision, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(((Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName)).normalize(Converter.convert(revision)).thenApply(Converter::convert), resultHandler);
    }

    public void listFiles(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision revision, String pathPattern, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(((Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName)).find(Converter.convert(revision), pathPattern, FindOptions.NO_FETCH_CONTENT).thenApply(entries -> {
            ArrayList ret = new ArrayList(entries.size());
            entries.forEach((path, entry) -> ret.add(new com.linecorp.centraldogma.internal.thrift.Entry(path, Converter.convert(entry.type()))));
            return ret;
        }), resultHandler);
    }

    public void getFiles(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision revision, String pathPattern, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(((Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName)).find(Converter.convert(revision), pathPattern).thenApply(entries -> {
            ArrayList ret = new ArrayList(entries.size());
            ret.addAll(entries.entrySet().stream().map(e -> Converter.convert((Entry)e.getValue())).collect(Collectors.toList()));
            return ret;
        }), resultHandler);
    }

    public void getHistory(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision from, com.linecorp.centraldogma.internal.thrift.Revision to, String pathPattern, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(((Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName)).history(Converter.convert(from), Converter.convert(to), pathPattern).thenApply(commits -> commits.stream().map(Converter::convert).collect(Collectors.toList())), resultHandler);
    }

    public void getDiffs(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision from, com.linecorp.centraldogma.internal.thrift.Revision to, String pathPattern, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(((Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName)).diff(Converter.convert(from), Converter.convert(to), pathPattern).thenApply(diffs -> Converter.convert(diffs.values(), Converter::convert)), resultHandler);
    }

    public void getPreviewDiffs(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision baseRevision, List<Change> changes, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(((Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName)).previewDiff(Converter.convert(baseRevision), Converter.convert(changes, Converter::convert)).thenApply(diffs -> Converter.convert(diffs.values(), Converter::convert)), resultHandler);
    }

    public void push(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision baseRevision, Author author, String summary, Comment detail, List<Change> changes, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(((CompletableFuture)this.executor.execute(Command.push(Converter.convert(author), projectName, repositoryName, Converter.convert(baseRevision), summary, detail.getContent(), Converter.convert(detail.getMarkup()), Converter.convert(changes, Converter::convert))).thenCompose(newRev -> ((Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName)).history((Revision)newRev, (Revision)newRev, "/**"))).thenApply(commits -> Converter.convert((Commit)commits.get(0))), resultHandler);
    }

    public void getFile(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision revision, Query query, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(((Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName)).get(Converter.convert(revision), Converter.convert(query)).thenApply(res -> new GetFileResult(Converter.convert(res.type()), res.contentAsText())), resultHandler);
    }

    public void diffFile(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision from, com.linecorp.centraldogma.internal.thrift.Revision to, Query query, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.handle(((Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName)).diff(Converter.convert(from), Converter.convert(to), Converter.convert(query)).thenApply(change -> new DiffFileResult(Converter.convert(change.type()), (String)MoreObjects.firstNonNull((Object)change.contentAsText(), (Object)""))), resultHandler);
    }

    public void watchRepository(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision lastKnownRevision, String pathPattern, long timeoutMillis, AsyncMethodCallback resultHandler) {
        if (timeoutMillis <= 0L) {
            CentralDogmaServiceImpl.rejectInvalidWatchTimeout("watchRepository", resultHandler);
            return;
        }
        Repository repo = (Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName);
        CompletableFuture<Revision> future = this.watchService.watchRepository(repo, Converter.convert(lastKnownRevision), pathPattern, timeoutMillis);
        CentralDogmaServiceImpl.handleWatchRepositoryResult(future, resultHandler);
    }

    private static void handleWatchRepositoryResult(CompletableFuture<Revision> future, AsyncMethodCallback resultHandler) {
        future.handle(Functions.voidFunction((res, cause) -> {
            if (cause == null) {
                WatchRepositoryResult wrr = new WatchRepositoryResult();
                wrr.setRevision(Converter.convert(res));
                resultHandler.onComplete((Object)wrr);
            } else if (cause instanceof CancellationException) {
                resultHandler.onComplete((Object)CentralDogmaConstants.EMPTY_WATCH_REPOSITORY_RESULT);
            } else {
                CentralDogmaServiceImpl.logAndInvokeOnError("watchRepository", resultHandler, cause);
            }
        }));
    }

    public void watchFile(String projectName, String repositoryName, com.linecorp.centraldogma.internal.thrift.Revision lastKnownRevision, Query query, long timeoutMillis, AsyncMethodCallback resultHandler) {
        if (timeoutMillis <= 0L) {
            CentralDogmaServiceImpl.rejectInvalidWatchTimeout("watchFile", resultHandler);
            return;
        }
        Repository repo = (Repository)((Project)this.projectManager.get(projectName)).repos().get(repositoryName);
        CompletableFuture<Entry<Object>> future = this.watchService.watchFile(repo, Converter.convert(lastKnownRevision), Converter.convert(query), timeoutMillis);
        CentralDogmaServiceImpl.handleWatchFileResult(future, resultHandler);
    }

    private static void rejectInvalidWatchTimeout(String operationName, AsyncMethodCallback resultHandler) {
        CentralDogmaException cde = new CentralDogmaException(ErrorCode.BAD_REQUEST);
        CentralDogmaExceptions.log(operationName, cde);
        resultHandler.onError((Exception)cde);
    }

    private static void handleWatchFileResult(CompletableFuture<Entry<Object>> future, AsyncMethodCallback resultHandler) {
        future.handle(Functions.voidFunction((res, cause) -> {
            if (cause == null) {
                WatchFileResult wfr = new WatchFileResult();
                wfr.setRevision(Converter.convert(res.revision()));
                wfr.setType(Converter.convert(res.type()));
                wfr.setContent(res.contentAsText());
                resultHandler.onComplete((Object)wfr);
            } else if (cause instanceof CancellationException) {
                resultHandler.onComplete((Object)CentralDogmaConstants.EMPTY_WATCH_FILE_RESULT);
            } else {
                CentralDogmaServiceImpl.logAndInvokeOnError("watchFile", resultHandler, cause);
            }
        }));
    }

    private static void logAndInvokeOnError(String operationName, AsyncMethodCallback resultHandler, Throwable cause) {
        CentralDogmaException cde = Converter.convert(cause);
        CentralDogmaExceptions.log(operationName, cde);
        resultHandler.onError((Exception)cde);
    }

    public void getSchema(String projectName, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void saveSchema(String projectName, Schema schema, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void getNamedQuery(String projectName, String name, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void saveNamedQuery(String projectName, NamedQuery namedQuery, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void removeNamedQuery(String projectName, String name, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void listNamedQueries(String projectName, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void getPlugin(String projectName, String pluginName, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void savePlugin(String projectName, Plugin plugin, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void removePlugin(String projectName, String pluginName, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void listPlugins(String projectName, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void listPluginOperations(String projectName, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void performPluginOperation(String projectName, String pluginName, String operationName, String params, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void queryByNamedQuery(String projectName, String namedQuery, com.linecorp.centraldogma.internal.thrift.Revision revision, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    public void listSubscribers(String projectName, String repositoryName, String path, AsyncMethodCallback resultHandler) {
        CentralDogmaServiceImpl.unimplemented(resultHandler);
    }

    private static void unimplemented(AsyncMethodCallback resultHandler) {
        resultHandler.onError((Exception)new CentralDogmaException(ErrorCode.UNIMPLEMENTED));
    }
}

