/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.command;

import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.replication.ReplicationException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public abstract class AbstractCommandExecutor
implements CommandExecutor {
    private final String replicaId;
    private final AtomicReference<State> state = new AtomicReference<State>(State.CREATED);

    protected AbstractCommandExecutor(String replicaId) {
        this.replicaId = Objects.requireNonNull(replicaId, "replicaId");
    }

    @Override
    public final String replicaId() {
        return this.replicaId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start(@Nullable Runnable onTakeLeadership, @Nullable Runnable onReleaseLeadership) {
        this.checkState(State.CREATED);
        boolean started = false;
        try {
            this.doStart(onTakeLeadership, onReleaseLeadership);
            this.enterState(State.CREATED, State.STARTED);
            started = true;
        }
        finally {
            if (!started) {
                this.doStop();
            }
        }
    }

    protected abstract void doStart(@Nullable Runnable var1, @Nullable Runnable var2);

    @Override
    public final void stop() {
        if (this.state.getAndSet(State.STOPPED) == State.STARTED) {
            this.doStop();
        }
    }

    protected abstract void doStop();

    @Override
    public boolean isStarted() {
        return this.state.get() == State.STARTED;
    }

    @Override
    public final <T> CompletableFuture<T> execute(Command<T> command) {
        return this.execute(this.replicaId, command);
    }

    @Override
    public final <T> CompletableFuture<T> execute(String replicaId, Command<T> command) {
        Objects.requireNonNull(replicaId, "replicaId");
        Objects.requireNonNull(command, "command");
        if (!this.isStarted()) {
            throw new IllegalStateException("running in read-only mode");
        }
        try {
            return this.doExecute(replicaId, command);
        }
        catch (Throwable t) {
            CompletableFuture f = new CompletableFuture();
            f.completeExceptionally(t);
            return f;
        }
    }

    protected abstract <T> CompletableFuture<T> doExecute(String var1, Command<T> var2) throws Exception;

    private void checkState(State expected) {
        if (this.state.get() != expected) {
            try {
                throw new ReplicationException("invalid state: " + (Object)((Object)this.state.get()));
            }
            catch (Throwable throwable) {
                this.stop();
                throw throwable;
            }
        }
    }

    private void enterState(State oldState, State newState) {
        if (!this.state.compareAndSet(oldState, newState)) {
            try {
                throw new ReplicationException("invalid state " + (Object)((Object)this.state.get()));
            }
            catch (Throwable throwable) {
                this.stop();
                throw throwable;
            }
        }
    }

    private static enum State {
        CREATED,
        STARTED,
        STOPPED;

    }
}

