/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.metadata.Permission;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;

public class PerRolePermissions {
    public static final Collection<Permission> ALL_PERMISSION = EnumSet.allOf(Permission.class);
    public static final Collection<Permission> READ_WRITE = EnumSet.of(Permission.READ, Permission.WRITE);
    public static final Collection<Permission> READ_ONLY = EnumSet.of(Permission.READ);
    public static final Collection<Permission> NO_PERMISSION = EnumSet.noneOf(Permission.class);
    public static final PerRolePermissions DEFAULT = new PerRolePermissions(READ_WRITE, READ_WRITE, READ_WRITE);
    private final Collection<Permission> owner;
    private final Collection<Permission> member;
    private final Collection<Permission> guest;

    public static PerRolePermissions ofPublic() {
        return new PerRolePermissions(READ_WRITE, READ_WRITE, READ_WRITE);
    }

    public static PerRolePermissions ofPrivate() {
        return new PerRolePermissions(READ_WRITE, READ_WRITE, NO_PERMISSION);
    }

    @JsonCreator
    public PerRolePermissions(@JsonProperty(value="owner") Collection<Permission> owner, @JsonProperty(value="member") Collection<Permission> member, @JsonProperty(value="guest") Collection<Permission> guest) {
        this.owner = PerRolePermissions.copyOf(Objects.requireNonNull(owner, "owner"));
        this.member = PerRolePermissions.copyOf(Objects.requireNonNull(member, "member"));
        this.guest = PerRolePermissions.copyOf(Objects.requireNonNull(guest, "guest"));
    }

    private static EnumSet<Permission> copyOf(Collection<Permission> input) {
        if (input.isEmpty()) {
            return EnumSet.noneOf(Permission.class);
        }
        return EnumSet.copyOf(input);
    }

    @JsonProperty
    public Collection<Permission> owner() {
        return this.owner;
    }

    @JsonProperty
    public Collection<Permission> member() {
        return this.member;
    }

    @JsonProperty
    public Collection<Permission> guest() {
        return this.guest;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("owner", this.owner()).add("member", this.member()).add("guest", this.guest()).toString();
    }
}

