/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.authentication;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.RepositoryCache;
import com.linecorp.centraldogma.server.support.shiro.FileBasedSessionDAO;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.cache.AbstractCacheManager;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;

public final class CentralDogmaSecurityManager
implements SecurityManager {
    private final FileBasedSessionDAO sessionDao;
    private final CentralDogmaSessionManager sessionManager;
    private final SecurityManager delegate;

    public CentralDogmaSecurityManager(File dataDir, Ini securityConfig, long sessionTimeoutMillis, final String sessionCacheSpec) {
        try {
            this.sessionDao = new FileBasedSessionDAO(new File(dataDir, "_sessions").toPath());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        Preconditions.checkArgument((sessionTimeoutMillis > 0L ? 1 : 0) != 0, (String)"sessionTimeoutMillis: %s (expected: > 0)", (long)sessionTimeoutMillis);
        this.sessionManager = new CentralDogmaSessionManager(this.sessionDao, sessionTimeoutMillis);
        RepositoryCache.validateCacheSpec(sessionCacheSpec);
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(securityConfig){

            protected SecurityManager createDefaultInstance() {
                DefaultSecurityManager securityManager = new DefaultSecurityManager();
                securityManager.setSessionManager((SessionManager)CentralDogmaSecurityManager.this.sessionManager);
                securityManager.setCacheManager((CacheManager)new CaffeineCacheManager(sessionCacheSpec));
                return securityManager;
            }
        };
        this.delegate = (SecurityManager)factory.getInstance();
    }

    public void enableSessionValidation() {
        this.sessionManager.setSessionValidationSchedulerEnabled(true);
        this.sessionManager.enableSessionValidation();
    }

    public void disableSessionValidation() {
        this.sessionManager.setSessionValidationSchedulerEnabled(false);
        this.sessionManager.disableSessionValidation();
    }

    public long globalSessionTimeout() {
        return this.sessionManager.getGlobalSessionTimeout();
    }

    public boolean sessionExists(String sessionId) {
        return this.sessionDao.exists(sessionId);
    }

    public SimpleSession getSerializableSession(String sessionId) {
        return this.sessionDao.readSession((Serializable)((Object)sessionId));
    }

    public void createSession(SimpleSession session) {
        this.sessionDao.create((Session)session);
    }

    public void removeSession(String sessionId) {
        this.sessionDao.delete(sessionId);
    }

    public Subject login(Subject subject, AuthenticationToken authenticationToken) {
        return this.delegate.login(subject, authenticationToken);
    }

    public void logout(Subject subject) {
        this.delegate.logout(subject);
    }

    public Subject createSubject(SubjectContext context) {
        return this.delegate.createSubject(context);
    }

    public Session start(SessionContext context) {
        return this.sessionManager.start(context);
    }

    public Session getSession(SessionKey key) {
        return this.sessionManager.getSession(key);
    }

    public AuthenticationInfo authenticate(AuthenticationToken authenticationToken) {
        return this.delegate.authenticate(authenticationToken);
    }

    public boolean isPermitted(PrincipalCollection principals, String permission) {
        return this.delegate.isPermitted(principals, permission);
    }

    public boolean isPermitted(PrincipalCollection subjectPrincipal, Permission permission) {
        return this.delegate.isPermitted(subjectPrincipal, permission);
    }

    public boolean[] isPermitted(PrincipalCollection subjectPrincipal, String ... permissions) {
        return this.delegate.isPermitted(subjectPrincipal, permissions);
    }

    public boolean[] isPermitted(PrincipalCollection subjectPrincipal, List<Permission> permissions) {
        return this.delegate.isPermitted(subjectPrincipal, permissions);
    }

    public boolean isPermittedAll(PrincipalCollection subjectPrincipal, String ... permissions) {
        return this.delegate.isPermittedAll(subjectPrincipal, permissions);
    }

    public boolean isPermittedAll(PrincipalCollection subjectPrincipal, Collection<Permission> permissions) {
        return this.delegate.isPermittedAll(subjectPrincipal, permissions);
    }

    public void checkPermission(PrincipalCollection subjectPrincipal, String permission) {
        this.delegate.checkPermission(subjectPrincipal, permission);
    }

    public void checkPermission(PrincipalCollection subjectPrincipal, Permission permission) {
        this.delegate.checkPermission(subjectPrincipal, permission);
    }

    public void checkPermissions(PrincipalCollection subjectPrincipal, String ... permissions) {
        this.delegate.checkPermissions(subjectPrincipal, permissions);
    }

    public void checkPermissions(PrincipalCollection subjectPrincipal, Collection<Permission> permissions) {
        this.delegate.checkPermissions(subjectPrincipal, permissions);
    }

    public boolean hasRole(PrincipalCollection subjectPrincipal, String roleIdentifier) {
        return this.delegate.hasRole(subjectPrincipal, roleIdentifier);
    }

    public boolean[] hasRoles(PrincipalCollection subjectPrincipal, List<String> roleIdentifiers) {
        return this.delegate.hasRoles(subjectPrincipal, roleIdentifiers);
    }

    public boolean hasAllRoles(PrincipalCollection subjectPrincipal, Collection<String> roleIdentifiers) {
        return this.delegate.hasAllRoles(subjectPrincipal, roleIdentifiers);
    }

    public void checkRole(PrincipalCollection subjectPrincipal, String roleIdentifier) {
        this.delegate.checkRole(subjectPrincipal, roleIdentifier);
    }

    public void checkRoles(PrincipalCollection subjectPrincipal, Collection<String> roleIdentifiers) {
        this.delegate.checkRoles(subjectPrincipal, roleIdentifiers);
    }

    public void checkRoles(PrincipalCollection subjectPrincipal, String ... roleIdentifiers) {
        this.delegate.checkRoles(subjectPrincipal, roleIdentifiers);
    }

    private static final class CaffeineCacheWrapper
    implements Cache<Object, Object> {
        private final com.github.benmanes.caffeine.cache.Cache<Object, Object> cache;

        CaffeineCacheWrapper(Caffeine<Object, Object> caffeine) {
            this.cache = caffeine.build();
        }

        @Nullable
        public Object get(Object key) {
            return this.cache.getIfPresent(key);
        }

        @Nullable
        public Object put(Object key, Object value) {
            Object prevValue = this.cache.getIfPresent(key);
            this.cache.put(key, value);
            return prevValue;
        }

        @Nullable
        public Object remove(Object key) {
            Object prevValue = this.cache.getIfPresent(key);
            this.cache.invalidate(key);
            return prevValue;
        }

        public void clear() {
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }

        public int size() {
            return Ints.saturatedCast((long)this.cache.estimatedSize());
        }

        public Set<Object> keys() {
            return this.cache.asMap().keySet();
        }

        public Collection<Object> values() {
            return this.cache.asMap().values();
        }
    }

    private static final class CaffeineCacheManager
    extends AbstractCacheManager {
        private final Caffeine<Object, Object> caffeine;

        CaffeineCacheManager(String sessionCacheSpec) {
            this.caffeine = Caffeine.from((String)sessionCacheSpec);
        }

        protected Cache<?, ?> createCache(String unused) {
            return new CaffeineCacheWrapper(this.caffeine);
        }
    }

    private static final class CentralDogmaSessionManager
    extends DefaultSessionManager {
        CentralDogmaSessionManager(SessionDAO sessionDao, long sessionTimeoutMillis) {
            this.setSessionDAO(sessionDao);
            this.setSessionValidationInterval(Duration.ofHours(1L).toMillis());
            this.setGlobalSessionTimeout(sessionTimeoutMillis);
        }

        protected synchronized void enableSessionValidation() {
            super.enableSessionValidation();
        }

        protected synchronized void disableSessionValidation() {
            super.disableSessionValidation();
        }
    }
}

