/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.command.CommandType;
import com.linecorp.centraldogma.server.internal.command.CreateProjectCommand;
import com.linecorp.centraldogma.server.internal.command.CreateRepositoryCommand;
import com.linecorp.centraldogma.server.internal.command.CreateSessionCommand;
import com.linecorp.centraldogma.server.internal.command.PushCommand;
import com.linecorp.centraldogma.server.internal.command.RemoveNamedQueryCommand;
import com.linecorp.centraldogma.server.internal.command.RemovePluginCommand;
import com.linecorp.centraldogma.server.internal.command.RemoveProjectCommand;
import com.linecorp.centraldogma.server.internal.command.RemoveRepositoryCommand;
import com.linecorp.centraldogma.server.internal.command.RemoveSessionCommand;
import com.linecorp.centraldogma.server.internal.command.SaveNamedQueryCommand;
import com.linecorp.centraldogma.server.internal.command.SavePluginCommand;
import com.linecorp.centraldogma.server.internal.command.UnremoveProjectCommand;
import com.linecorp.centraldogma.server.internal.command.UnremoveRepositoryCommand;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.shiro.session.mgt.SimpleSession;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CreateProjectCommand.class, name="CREATE_PROJECT"), @JsonSubTypes.Type(value=RemoveProjectCommand.class, name="REMOVE_PROJECT"), @JsonSubTypes.Type(value=UnremoveProjectCommand.class, name="UNREMOVE_PROJECT"), @JsonSubTypes.Type(value=CreateRepositoryCommand.class, name="CREATE_REPOSITORY"), @JsonSubTypes.Type(value=RemoveRepositoryCommand.class, name="REMOVE_REPOSITORY"), @JsonSubTypes.Type(value=UnremoveRepositoryCommand.class, name="UNREMOVE_REPOSITORY"), @JsonSubTypes.Type(value=PushCommand.class, name="PUSH"), @JsonSubTypes.Type(value=SaveNamedQueryCommand.class, name="SAVE_NAMED_QUERY"), @JsonSubTypes.Type(value=RemoveNamedQueryCommand.class, name="REMOVE_NAMED_QUERY"), @JsonSubTypes.Type(value=SavePluginCommand.class, name="SAVE_PLUGIN"), @JsonSubTypes.Type(value=RemovePluginCommand.class, name="REMOVE_PLUGIN"), @JsonSubTypes.Type(value=CreateSessionCommand.class, name="CREATE_SESSIONS"), @JsonSubTypes.Type(value=RemoveSessionCommand.class, name="REMOVE_SESSIONS")})
public interface Command<T> {
    public static Command<Void> createProject(Author author, String name) {
        return Command.createProject(null, author, name);
    }

    public static Command<Void> createProject(@Nullable Long timestamp, Author author, String name) {
        Objects.requireNonNull(author, "author");
        return new CreateProjectCommand(timestamp, author, name);
    }

    public static Command<Void> removeProject(Author author, String name) {
        return Command.removeProject(null, author, name);
    }

    public static Command<Void> removeProject(@Nullable Long timestamp, Author author, String name) {
        Objects.requireNonNull(author, "author");
        return new RemoveProjectCommand(timestamp, author, name);
    }

    public static Command<Void> unremoveProject(Author author, String name) {
        return Command.unremoveProject(null, author, name);
    }

    public static Command<Void> unremoveProject(@Nullable Long timestamp, Author author, String name) {
        Objects.requireNonNull(author, "author");
        return new UnremoveProjectCommand(timestamp, author, name);
    }

    public static Command<Void> createRepository(Author author, String projectName, String repositoryName) {
        return Command.createRepository(null, author, projectName, repositoryName);
    }

    public static Command<Void> createRepository(@Nullable Long timestamp, Author author, String projectName, String repositoryName) {
        Objects.requireNonNull(author, "author");
        return new CreateRepositoryCommand(timestamp, author, projectName, repositoryName);
    }

    public static Command<Void> removeRepository(Author author, String projectName, String repositoryName) {
        return Command.removeRepository(null, author, projectName, repositoryName);
    }

    public static Command<Void> removeRepository(@Nullable Long timestamp, Author author, String projectName, String repositoryName) {
        Objects.requireNonNull(author, "author");
        return new RemoveRepositoryCommand(timestamp, author, projectName, repositoryName);
    }

    public static Command<Void> unremoveRepository(Author author, String projectName, String repositoryName) {
        return Command.unremoveRepository(null, author, projectName, repositoryName);
    }

    public static Command<Void> unremoveRepository(@Nullable Long timestamp, Author author, String projectName, String repositoryName) {
        Objects.requireNonNull(author, "author");
        return new UnremoveRepositoryCommand(timestamp, author, projectName, repositoryName);
    }

    public static Command<Revision> push(Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Change<?> ... changes) {
        return Command.push(null, author, projectName, repositoryName, baseRevision, summary, detail, markup, changes);
    }

    public static Command<Revision> push(@Nullable Long timestamp, Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Change<?> ... changes) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(changes, "changes");
        return new PushCommand(timestamp, author, projectName, repositoryName, baseRevision, summary, detail, markup, Arrays.asList(changes));
    }

    public static Command<Revision> push(Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Iterable<Change<?>> changes) {
        return Command.push(null, author, projectName, repositoryName, baseRevision, summary, detail, markup, changes);
    }

    public static Command<Revision> push(@Nullable Long timestamp, Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Iterable<Change<?>> changes) {
        Objects.requireNonNull(author, "author");
        return new PushCommand(timestamp, author, projectName, repositoryName, baseRevision, summary, detail, markup, changes);
    }

    public static Command<Void> saveNamedQuery(Author author, String projectName, String queryName, boolean enabled, String repositoryName, Query<?> query, String comment, Markup markup) {
        return Command.saveNamedQuery(null, author, projectName, queryName, enabled, repositoryName, query, comment, markup);
    }

    public static Command<Void> saveNamedQuery(@Nullable Long timestamp, Author author, String projectName, String queryName, boolean enabled, String repositoryName, Query<?> query, String comment, Markup markup) {
        Objects.requireNonNull(author, "author");
        return new SaveNamedQueryCommand(timestamp, author, projectName, queryName, enabled, repositoryName, query, comment, markup);
    }

    public static Command<Void> removeNamedQuery(Author author, String projectName, String name) {
        return Command.removeNamedQuery(null, author, projectName, name);
    }

    public static Command<Void> removeNamedQuery(@Nullable Long timestamp, Author author, String projectName, String name) {
        Objects.requireNonNull(author, "author");
        return new RemoveNamedQueryCommand(timestamp, author, projectName, name);
    }

    public static Command<Void> savePlugin(Author author, String projectName, String pluginName, String path) {
        return Command.savePlugin(null, author, projectName, pluginName, path);
    }

    public static Command<Void> savePlugin(@Nullable Long timestamp, Author author, String projectName, String pluginName, String path) {
        Objects.requireNonNull(author, "author");
        return new SavePluginCommand(timestamp, author, projectName, pluginName, path);
    }

    public static Command<Void> removePlugin(Author author, String projectName, String pluginName) {
        return Command.removePlugin(null, author, projectName, pluginName);
    }

    public static Command<Void> removePlugin(@Nullable Long timestamp, Author author, String projectName, String pluginName) {
        Objects.requireNonNull(author, "author");
        return new RemovePluginCommand(timestamp, author, projectName, pluginName);
    }

    public static Command<Void> createSession(SimpleSession session) {
        return new CreateSessionCommand(null, null, session);
    }

    public static Command<Void> removeSession(String sessionId) {
        return new RemoveSessionCommand(null, null, sessionId);
    }

    public CommandType type();

    @JsonProperty
    public long timestamp();

    @JsonProperty
    public Author author();

    public String executionPath();
}

