/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.command;

import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class ForwardingCommandExecutor
implements CommandExecutor {
    private final CommandExecutor delegate;

    protected ForwardingCommandExecutor(CommandExecutor delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    protected <T extends CommandExecutor> T delegate() {
        return (T)((CommandExecutor)Util.unsafeCast((Object)this.delegate));
    }

    @Override
    public String replicaId() {
        return this.delegate().replicaId();
    }

    @Override
    public void start(@Nullable Runnable onTakeLeadership, @Nullable Runnable onReleaseLeadership) {
        this.delegate().start(onTakeLeadership, onReleaseLeadership);
    }

    @Override
    public void stop() {
        this.delegate().stop();
    }

    @Override
    public boolean isStarted() {
        return this.delegate().isStarted();
    }

    @Override
    public <T> CompletableFuture<T> execute(Command<T> command) {
        return this.delegate().execute(command);
    }

    @Override
    public <T> CompletableFuture<T> execute(String replicaId, Command<T> command) {
        return this.delegate().execute(replicaId, command);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.delegate() + ')';
    }
}

