/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.command;

import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.admin.authentication.CentralDogmaSecurityManager;
import com.linecorp.centraldogma.server.internal.command.AbstractCommandExecutor;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CreateProjectCommand;
import com.linecorp.centraldogma.server.internal.command.CreateRepositoryCommand;
import com.linecorp.centraldogma.server.internal.command.CreateSessionCommand;
import com.linecorp.centraldogma.server.internal.command.PushCommand;
import com.linecorp.centraldogma.server.internal.command.RemoveProjectCommand;
import com.linecorp.centraldogma.server.internal.command.RemoveRepositoryCommand;
import com.linecorp.centraldogma.server.internal.command.RemoveSessionCommand;
import com.linecorp.centraldogma.server.internal.command.RepositoryCommand;
import com.linecorp.centraldogma.server.internal.command.UnremoveProjectCommand;
import com.linecorp.centraldogma.server.internal.command.UnremoveRepositoryCommand;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.shiro.session.mgt.SimpleSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneCommandExecutor
extends AbstractCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneCommandExecutor.class);
    private final ProjectManager projectManager;
    private final CentralDogmaSecurityManager securityManager;
    private final Executor repositoryWorker;
    private volatile Runnable onReleaseLeadership;

    public StandaloneCommandExecutor(ProjectManager projectManager, @Nullable CentralDogmaSecurityManager securityManager, Executor repositoryWorker) {
        this("none", projectManager, securityManager, repositoryWorker);
    }

    public StandaloneCommandExecutor(String replicaId, ProjectManager projectManager, @Nullable CentralDogmaSecurityManager securityManager, Executor repositoryWorker) {
        super(replicaId);
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.securityManager = securityManager;
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
    }

    @Override
    protected void doStart(@Nullable Runnable onTakeLeadership, @Nullable Runnable onReleaseLeadership) {
        this.onReleaseLeadership = onReleaseLeadership;
        if (onTakeLeadership != null) {
            onTakeLeadership.run();
        }
    }

    @Override
    protected void doStop() {
        Runnable onReleaseLeadership = this.onReleaseLeadership;
        if (onReleaseLeadership != null) {
            this.onReleaseLeadership = null;
            onReleaseLeadership.run();
        }
    }

    @Override
    protected <T> CompletableFuture<T> doExecute(String replicaId, Command<T> command) throws Exception {
        if (command instanceof CreateProjectCommand) {
            return this.createProject((CreateProjectCommand)command);
        }
        if (command instanceof RemoveProjectCommand) {
            return this.removeProject((RemoveProjectCommand)command);
        }
        if (command instanceof UnremoveProjectCommand) {
            return this.unremoveProject((UnremoveProjectCommand)command);
        }
        if (command instanceof CreateRepositoryCommand) {
            return this.createRepository((CreateRepositoryCommand)command);
        }
        if (command instanceof RemoveRepositoryCommand) {
            return this.removeRepository((RemoveRepositoryCommand)command);
        }
        if (command instanceof UnremoveRepositoryCommand) {
            return this.unremoveRepository((UnremoveRepositoryCommand)command);
        }
        if (command instanceof PushCommand) {
            return this.push((PushCommand)command);
        }
        if (command instanceof CreateSessionCommand) {
            return this.createSession(replicaId, (CreateSessionCommand)command);
        }
        if (command instanceof RemoveSessionCommand) {
            return this.removeSession(replicaId, (RemoveSessionCommand)command);
        }
        throw new UnsupportedOperationException(command.toString());
    }

    private CompletableFuture<Void> createProject(CreateProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.create(c.projectName(), c.timestamp(), c.author());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> removeProject(RemoveProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.remove(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> unremoveProject(UnremoveProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.unremove(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> createRepository(CreateRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().create(c.repositoryName(), c.timestamp(), c.author());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> removeRepository(RemoveRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().remove(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> unremoveRepository(UnremoveRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().unremove(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Revision> push(PushCommand c) {
        return this.repo(c).commit(c.baseRevision(), c.timestamp(), c.author(), c.summary(), c.detail(), c.markup(), c.changes());
    }

    private Repository repo(RepositoryCommand<?> c) {
        return (Repository)((Project)this.projectManager.get(c.projectName())).repos().get(c.repositoryName());
    }

    private CompletableFuture<Void> createSession(String replicaId, CreateSessionCommand c) {
        if (this.securityManager == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.replicaId().equals(replicaId)) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> {
            SimpleSession session = c.session();
            try {
                this.securityManager.createSession(session);
            }
            catch (Throwable t) {
                logger.warn("Failed to replicate a session creation: {}", (Object)session, (Object)t);
            }
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> removeSession(String replicaId, RemoveSessionCommand c) {
        if (this.securityManager == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.replicaId().equals(replicaId)) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> {
            String sessionId = c.sessionId();
            try {
                this.securityManager.removeSession(sessionId);
            }
            catch (Throwable t) {
                logger.warn("Failed to replicate a session removal: {}", (Object)sessionId, (Object)t);
            }
            return null;
        }, this.repositoryWorker);
    }
}

