/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.admin.authentication.User;
import com.linecorp.centraldogma.server.internal.metadata.Identifiable;
import com.linecorp.centraldogma.server.internal.metadata.ProjectRole;
import com.linecorp.centraldogma.server.internal.metadata.UserAndTimestamp;
import java.util.Objects;

public class Member
implements Identifiable {
    private final String login;
    private final ProjectRole role;
    private final UserAndTimestamp creation;

    public Member(User user, ProjectRole role, UserAndTimestamp creation) {
        this(Objects.requireNonNull(user, "user").id(), role, creation);
    }

    public Member(Author author, ProjectRole role, UserAndTimestamp creation) {
        this(Objects.requireNonNull(author, "author").email(), role, creation);
    }

    @JsonCreator
    public Member(@JsonProperty(value="login") String login, @JsonProperty(value="role") ProjectRole role, @JsonProperty(value="creation") UserAndTimestamp creation) {
        this.login = Util.toEmailAddress((String)login, (String)"login");
        this.role = Objects.requireNonNull(role, "role");
        this.creation = Objects.requireNonNull(creation, "creation");
    }

    @Override
    public String id() {
        return this.login;
    }

    @JsonProperty
    public String login() {
        return this.login;
    }

    @JsonProperty
    public ProjectRole role() {
        return this.role;
    }

    @JsonProperty
    public UserAndTimestamp creation() {
        return this.creation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("login", (Object)this.login()).add("role", (Object)this.role()).add("creation", (Object)this.creation()).toString();
    }
}

