/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableCall;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class CacheableSingleDiffCall
extends CacheableCall<Change<?>> {
    final Revision from;
    final Revision to;
    final Query<?> query;
    final int hashCode;

    CacheableSingleDiffCall(Repository repo, Revision from, Revision to, Query<?> query) {
        super(repo);
        this.from = Objects.requireNonNull(from, "from");
        this.to = Objects.requireNonNull(to, "to");
        this.query = Objects.requireNonNull(query, "query");
        this.hashCode = Objects.hash(from, to, query) * 31 + System.identityHashCode(repo);
        assert (!from.isRelative());
        assert (!to.isRelative());
    }

    @Override
    int weigh(Change<?> value) {
        int weight = 0;
        weight += this.query.path().length();
        for (String e : this.query.expressions()) {
            weight += e.length();
        }
        weight += value.path().length();
        String content = value.contentAsText();
        if (content != null) {
            weight += content.length();
        }
        return weight;
    }

    @Override
    CompletableFuture<Change<?>> execute() {
        return this.repo.diff(this.from, this.to, this.query);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableSingleDiffCall that = (CacheableSingleDiffCall)o;
        return this.from.equals((Object)that.from) && this.to.equals((Object)that.to) && this.query.equals(that.query);
    }

    @Override
    void toString(MoreObjects.ToStringHelper helper) {
        helper.add("from", (Object)this.from).add("to", (Object)this.to).add("query", this.query);
    }
}

