/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateApiResponseConverter
implements ResponseConverterFunction {
    private static final Logger logger = LoggerFactory.getLogger(CreateApiResponseConverter.class);

    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object resObj, HttpHeaders trailingHeaders) throws Exception {
        try {
            ResponseHeadersBuilder builder = headers.toBuilder();
            if (builder.contentType() == null) {
                builder.contentType(MediaType.JSON_UTF_8);
            }
            JsonNode jsonNode = Jackson.valueToTree((Object)resObj);
            if (builder.get((CharSequence)HttpHeaderNames.LOCATION) == null) {
                String url = jsonNode.get("url").asText();
                ((ObjectNode)jsonNode).remove("url");
                builder.add((CharSequence)HttpHeaderNames.LOCATION, url);
            }
            return HttpResponse.of((ResponseHeaders)builder.build(), (HttpData)HttpData.wrap((byte[])Jackson.writeValueAsBytes((Object)jsonNode)), (HttpHeaders)trailingHeaders);
        }
        catch (JsonProcessingException e) {
            logger.debug("Failed to convert a response:", (Throwable)e);
            return HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.INTERNAL_SERVER_ERROR, e);
        }
    }
}

