/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.server.MirrorException;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.mirror.AbstractMirror;
import com.linecorp.centraldogma.server.internal.mirror.GitWithAuth;
import com.linecorp.centraldogma.server.internal.mirror.MirrorState;
import com.linecorp.centraldogma.server.internal.mirror.credential.PasswordMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.PublicKeyMirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RemoteSetUrlCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitMirror
extends AbstractMirror {
    private static final Logger logger = LoggerFactory.getLogger(GitMirror.class);
    private static final Pattern DISALLOWED_CHARS = Pattern.compile("[^-_a-zA-Z]");
    private static final Pattern CONSECUTIVE_UNDERSCORES = Pattern.compile("_+");
    private static final int GIT_TIMEOUT_SECS = 10;

    public GitMirror(Cron schedule, MirrorDirection direction, MirrorCredential credential, Repository localRepo, String localPath, URI remoteRepoUri, String remotePath, String remoteBranch) {
        super(schedule, direction, credential, localRepo, localPath, remoteRepoUri, remotePath, remoteBranch);
    }

    @Override
    protected void mirrorLocalToRemote(File workDir, int maxNumFiles, long maxNumBytes) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void mirrorRemoteToLocal(File workDir, CommandExecutor executor, int maxNumFiles, long maxNumBytes) throws Exception {
        HashMap<String, Change> changes = new HashMap<String, Change>();
        try (Git git = this.openGit(workDir);){
            String summary;
            FetchCommand fetch = git.fetch();
            String refName = "refs/heads/" + this.remoteBranch();
            FetchResult fetchResult = ((FetchCommand)fetch.setRefSpecs(new RefSpec[]{new RefSpec(refName)}).setCheckFetchedObjects(true).setRemoveDeletedRefs(true).setTagOpt(TagOpt.NO_TAGS).setTimeout(10)).call();
            ObjectId id = fetchResult.getAdvertisedRef(refName).getObjectId();
            RefUpdate refUpdate = git.getRepository().updateRef(refName);
            refUpdate.setNewObjectId((AnyObjectId)id);
            refUpdate.update();
            Revision localRev = this.localRepo().normalizeNow(Revision.HEAD);
            try (ObjectReader reader = git.getRepository().newObjectReader();
                 TreeWalk treeWalk = new TreeWalk(reader);
                 RevWalk revWalk = new RevWalk(reader);){
                treeWalk.addTree((AnyObjectId)revWalk.parseTree((AnyObjectId)id).getId());
                String mirrorStatePath = this.localPath() + "mirror_state.json";
                Entry<?> mirrorState = this.localRepo().getOrNull(localRev, mirrorStatePath).join();
                String localSourceRevision = mirrorState == null || mirrorState.type() != EntryType.JSON ? null : ((MirrorState)Jackson.treeToValue((TreeNode)((TreeNode)mirrorState.content()), MirrorState.class)).sourceRevision();
                String abbrId = reader.abbreviate((AnyObjectId)id).name();
                if (id.name().equals(localSourceRevision)) {
                    logger.info("Repository '{}' already at {}, {}#{}", new Object[]{this.localRepo().name(), abbrId, this.remoteRepoUri(), this.remoteBranch()});
                    return;
                }
                changes.put(mirrorStatePath, Change.ofJsonUpsert((String)mirrorStatePath, (String)("{ \"sourceRevision\": \"" + id.name() + "\" }")));
                summary = "Mirror " + abbrId + ", " + this.remoteRepoUri() + '#' + this.remoteBranch() + " to the repository '" + this.localRepo().name() + '\'';
                logger.info(summary);
                long numFiles = 0L;
                long numBytes = 0L;
                while (treeWalk.next()) {
                    String localPath;
                    FileMode fileMode = treeWalk.getFileMode();
                    String path2 = '/' + treeWalk.getPathString();
                    if (fileMode == FileMode.TREE) {
                        if (path2.startsWith(this.remotePath())) {
                            treeWalk.enterSubtree();
                            continue;
                        }
                        int pathLen = path2.length() + 1;
                        if (pathLen == this.remotePath().length() && this.remotePath().startsWith(path2)) {
                            treeWalk.enterSubtree();
                            continue;
                        }
                        if (pathLen >= this.remotePath().length() || !this.remotePath().startsWith(path2 + '/')) continue;
                        treeWalk.enterSubtree();
                        continue;
                    }
                    if (fileMode != FileMode.REGULAR_FILE && fileMode != FileMode.EXECUTABLE_FILE || !path2.startsWith(this.remotePath()) || !Util.isValidFilePath((String)(localPath = this.localPath() + path2.substring(this.remotePath().length())))) continue;
                    if (++numFiles > (long)maxNumFiles) {
                        throw new MirrorException("mirror contains more than " + maxNumFiles + " file(s)");
                    }
                    ObjectId objectId = treeWalk.getObjectId(0);
                    long contentLength = reader.getObjectSize((AnyObjectId)objectId, -1);
                    if (numBytes > maxNumBytes - contentLength) {
                        throw new MirrorException("mirror contains more than " + maxNumBytes + " byte(s)");
                    }
                    numBytes += contentLength;
                    byte[] content = reader.open((AnyObjectId)objectId).getBytes();
                    switch (EntryType.guessFromPath((String)localPath)) {
                        case JSON: {
                            JsonNode jsonNode = Jackson.readTree((byte[])content);
                            changes.putIfAbsent(localPath, Change.ofJsonUpsert((String)localPath, (JsonNode)jsonNode));
                            break;
                        }
                        case TEXT: {
                            String strVal = new String(content, StandardCharsets.UTF_8);
                            changes.putIfAbsent(localPath, Change.ofTextUpsert((String)localPath, (String)strVal));
                        }
                    }
                }
            }
            Map<String, Entry<?>> oldEntries = this.localRepo().find(localRev, this.localPath() + "**", FindOptions.FIND_ALL_WITHOUT_CONTENT).join();
            oldEntries.keySet().removeAll(changes.keySet());
            oldEntries.forEach((path, entry) -> {
                if (entry.type() != EntryType.DIRECTORY && !changes.containsKey(path)) {
                    changes.put((String)path, Change.ofRemoval((String)path));
                }
            });
            executor.execute(Command.push(MIRROR_AUTHOR, this.localRepo().parent().name(), this.localRepo().name(), Revision.HEAD, summary, "", Markup.PLAINTEXT, changes.values())).join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Git openGit(File workDir) throws Exception {
        String jGitUri;
        String scheme = this.remoteRepoUri().getScheme();
        if (scheme.startsWith("git+")) {
            if (scheme.equals("git+ssh")) {
                String username = this.credential() instanceof PasswordMirrorCredential ? ((PasswordMirrorCredential)this.credential()).username() : (this.credential() instanceof PublicKeyMirrorCredential ? ((PublicKeyMirrorCredential)this.credential()).username() : null);
                assert (!this.remoteRepoUri().getRawAuthority().contains("@")) : this.remoteRepoUri().getRawAuthority();
                jGitUri = username != null ? "ssh://" + username + '@' + this.remoteRepoUri().getRawAuthority() + this.remoteRepoUri().getRawPath() : "ssh://" + this.remoteRepoUri().getRawAuthority() + this.remoteRepoUri().getRawPath();
            } else {
                jGitUri = this.remoteRepoUri().toASCIIString().substring(4);
            }
        } else {
            jGitUri = this.remoteRepoUri().toASCIIString();
        }
        File repoDir = new File(workDir, CONSECUTIVE_UNDERSCORES.matcher(DISALLOWED_CHARS.matcher(this.remoteRepoUri().toASCIIString()).replaceAll("_")).replaceAll("_"));
        GitWithAuth git = new GitWithAuth(this, repoDir);
        boolean success = false;
        try {
            URIish uri = new URIish(jGitUri);
            RemoteSetUrlCommand remoteSetUrl = git.remoteSetUrl();
            remoteSetUrl.setRemoteName("origin");
            remoteSetUrl.setRemoteUri(uri);
            remoteSetUrl.setUriType(RemoteSetUrlCommand.UriType.FETCH);
            remoteSetUrl.call();
            remoteSetUrl.setUriType(RemoteSetUrlCommand.UriType.PUSH);
            remoteSetUrl.call();
            success = true;
            GitWithAuth gitWithAuth = git;
            return gitWithAuth;
        }
        finally {
            if (!success) {
                git.close();
            }
        }
    }
}

