/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror.credential;

import com.linecorp.centraldogma.internal.shaded.guava.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;

final class MirrorCredentialUtil {
    private static final String BASE64_PREFIX = "base64:";
    private static final BaseEncoding base64 = BaseEncoding.base64();

    static byte[] decodeBase64(String value, String name) {
        Objects.requireNonNull(value, name);
        return base64.decode((CharSequence)value);
    }

    @Nullable
    static byte[] decodeBase64OrUtf8(@Nullable String value, String name) {
        if (value == null) {
            return null;
        }
        if (value.startsWith(BASE64_PREFIX)) {
            return MirrorCredentialUtil.decodeBase64(value.substring(BASE64_PREFIX.length()), name);
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    static String requireNonEmpty(String value, String name) {
        Objects.requireNonNull(value, name);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty.");
        }
        return value;
    }

    static byte[] requireNonEmpty(byte[] value, String name) {
        Objects.requireNonNull(value, name);
        if (value.length == 0) {
            throw new IllegalArgumentException(name + " is empty.");
        }
        return value;
    }

    private MirrorCredentialUtil() {
    }
}

