/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.CommandType;
import com.linecorp.centraldogma.server.command.RepositoryCommand;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class AbstractPushCommand<T>
extends RepositoryCommand<T> {
    private final Revision baseRevision;
    private final String summary;
    private final String detail;
    private final Markup markup;
    private final List<Change<?>> changes;

    AbstractPushCommand(CommandType type, @Nullable Long timestamp, @Nullable Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Iterable<Change<?>> changes) {
        super(type, timestamp, author, projectName, repositoryName);
        this.baseRevision = Objects.requireNonNull(baseRevision, "baseRevision");
        this.summary = Objects.requireNonNull(summary, "summary");
        this.detail = Objects.requireNonNull(detail, "detail");
        this.markup = Objects.requireNonNull(markup, "markup");
        Objects.requireNonNull(changes, "changes");
        this.changes = ImmutableList.copyOf(changes);
    }

    @JsonProperty
    public Revision baseRevision() {
        return this.baseRevision;
    }

    @JsonProperty
    public String summary() {
        return this.summary;
    }

    @JsonProperty
    public String detail() {
        return this.detail;
    }

    @JsonProperty
    public Markup markup() {
        return this.markup;
    }

    @JsonProperty
    public List<Change<?>> changes() {
        return this.changes;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractPushCommand)) {
            return false;
        }
        AbstractPushCommand that = (AbstractPushCommand)obj;
        return super.equals(that) && this.baseRevision.equals((Object)that.baseRevision) && this.summary.equals(that.summary) && this.detail.equals(that.detail) && this.markup == that.markup && this.changes.equals(that.changes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseRevision, this.summary, this.detail, this.markup, this.changes) * 31 + super.hashCode();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("baseRevision", (Object)this.baseRevision).add("summary", (Object)this.summary).add("detail", (Object)this.detail).add("markup", (Object)this.markup).add("changes", this.changes);
    }
}

