/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal;

import com.linecorp.armeria.common.util.SystemInfo;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public final class IsolatedSystemReader
extends SystemReader {
    private static final Pattern allowedSystemPropertyNamePattern = Pattern.compile("^(?:java|os|file|path|line|user|native|jdk)\\.");
    private static final SystemReader INSTANCE = new IsolatedSystemReader();

    public static void install() {
        SystemReader.setInstance((SystemReader)INSTANCE);
    }

    private IsolatedSystemReader() {
    }

    public String getHostname() {
        return SystemInfo.hostname();
    }

    @Nullable
    public String getenv(String variable) {
        return null;
    }

    @Nullable
    public String getProperty(String key) {
        if (allowedSystemPropertyNamePattern.matcher(key).find()) {
            return System.getProperty(key);
        }
        return null;
    }

    public FileBasedConfig openUserConfig(Config parent, FS fs) {
        return new EmptyConfig(parent, fs);
    }

    public FileBasedConfig openSystemConfig(Config parent, FS fs) {
        return new EmptyConfig(parent, fs);
    }

    public FileBasedConfig openJGitConfig(Config parent, FS fs) {
        return new EmptyConfig(parent, fs);
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public int getTimezone(long when) {
        return this.getTimeZone().getOffset(when) / 60000;
    }

    private static final class EmptyConfig
    extends FileBasedConfig {
        EmptyConfig(Config base, FS fs) {
            super(base, null, fs);
        }

        public void load() {
        }

        public boolean isOutdated() {
            return false;
        }
    }
}

