/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.dto;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.thrift.Commit;
import com.linecorp.centraldogma.server.internal.admin.dto.AuthorDto;
import com.linecorp.centraldogma.server.internal.admin.dto.ChangeDto;
import com.linecorp.centraldogma.server.internal.admin.dto.CommentDto;
import com.linecorp.centraldogma.server.internal.admin.dto.RevisionDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CommitDto {
    private RevisionDto revision;
    private AuthorDto author;
    private String timestamp;
    private String summary;
    private CommentDto detail;
    private List<ChangeDto> diffs = new ArrayList<ChangeDto>();

    public CommitDto() {
    }

    public CommitDto(Commit commit) {
        Objects.requireNonNull(commit, "commit");
        this.revision = new RevisionDto(commit.getRevision());
        this.author = new AuthorDto(commit.getAuthor());
        this.timestamp = commit.getTimestamp();
        this.summary = commit.getSummary();
        this.detail = new CommentDto(commit.getDetail());
        this.diffs = commit.getDiffs().stream().map(ChangeDto::new).collect(Collectors.toList());
    }

    public RevisionDto getRevision() {
        return this.revision;
    }

    public void setRevision(RevisionDto revision) {
        this.revision = revision;
    }

    public AuthorDto getAuthor() {
        return this.author;
    }

    public void setAuthor(AuthorDto author) {
        this.author = author;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public CommentDto getDetail() {
        return this.detail;
    }

    public void setDetail(CommentDto detail) {
        this.detail = detail;
    }

    public List<ChangeDto> getDiffs() {
        return this.diffs;
    }

    public void setDiffs(List<ChangeDto> diffs) {
        this.diffs = diffs;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("revision", (Object)this.revision).add("author", (Object)this.author).add("timestamp", (Object)this.timestamp).add("summary", (Object)this.summary).add("detail", (Object)this.detail).add("diffs", this.diffs).toString();
    }
}

