/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.service;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.admin.dto.AuthorDto;
import com.linecorp.centraldogma.server.internal.admin.dto.ChangeDto;
import com.linecorp.centraldogma.server.internal.admin.dto.CommentDto;
import com.linecorp.centraldogma.server.internal.admin.dto.CommitDto;
import com.linecorp.centraldogma.server.internal.admin.dto.EntryDto;
import com.linecorp.centraldogma.server.internal.admin.dto.ProjectDto;
import com.linecorp.centraldogma.server.internal.admin.dto.RepositoryDto;
import com.linecorp.centraldogma.server.internal.admin.dto.RevisionDto;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.List;
import java.util.concurrent.CompletableFuture;

final class DtoConverter {
    static CompletableFuture<RepositoryDto> convert(Repository repository) {
        return repository.history(Revision.HEAD, Revision.HEAD, "/**", 1).thenApply(history -> DtoConverter.fromCommit(repository.name(), history));
    }

    static ProjectDto convert(Project project) {
        ProjectDto dto = new ProjectDto();
        dto.setName(project.name());
        return dto;
    }

    static CommitDto convert(Commit commit) {
        CommitDto dto = new CommitDto();
        dto.setAuthor(DtoConverter.convert(commit.author()));
        dto.setRevision(DtoConverter.convert(commit.revision()));
        dto.setTimestamp(commit.whenAsText());
        dto.setSummary(commit.summary());
        dto.setDetail(DtoConverter.convert(commit.detail(), commit.markup()));
        return dto;
    }

    static RevisionDto convert(Revision revision) {
        return new RevisionDto(revision.major(), 0, revision.text());
    }

    static AuthorDto convert(Author author) {
        AuthorDto dto = new AuthorDto();
        dto.setName(author.name());
        dto.setEmail(author.email());
        return dto;
    }

    static CommentDto convert(String content, Markup markup) {
        CommentDto dto = new CommentDto();
        dto.setContent(content);
        dto.setMarkup(markup.name());
        return dto;
    }

    static ChangeDto convert(Change<?> change) {
        ChangeDto dto = new ChangeDto();
        dto.setPath(change.path());
        dto.setType(change.type().name());
        dto.setContent(change.contentAsText());
        return dto;
    }

    static EntryDto convert(Entry<?> entry) {
        EntryDto dto = new EntryDto();
        dto.setRevision(entry.revision().text());
        dto.setPath(entry.path());
        dto.setType(entry.type().name());
        dto.setContent(entry.contentAsText());
        return dto;
    }

    static RepositoryDto fromCommit(String name, List<Commit> history) {
        RepositoryDto dto = new RepositoryDto();
        dto.setName(name);
        dto.setHead(DtoConverter.convert(history.get(0)));
        return dto;
    }

    private DtoConverter() {
    }
}

