/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.Session;
import com.linecorp.centraldogma.server.MirrorException;
import com.linecorp.centraldogma.server.internal.mirror.GitMirror;
import com.linecorp.centraldogma.server.internal.mirror.GitWithAuth;
import com.linecorp.centraldogma.server.internal.mirror.credential.PasswordMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.PublicKeyMirrorCredential;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;

final class Git5WithAuth
extends GitWithAuth {
    Git5WithAuth(GitMirror mirror, File repoDir) throws IOException {
        super(mirror, repoDir);
    }

    @Override
    FetchCommand fetch(int depth) {
        return this.fetch();
    }

    @Override
    public <T extends TransportCommand<?, ?>> void configureSsh(T cmd, final PublicKeyMirrorCredential cred) {
        cmd.setTransportConfigCallback(transport -> {
            SshTransport sshTransport = (SshTransport)transport;
            sshTransport.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host host, Session session) {
                    try {
                        session.setHostKeyRepository((HostKeyRepository)new GitWithAuth.MirrorHostKeyRepository(Git5WithAuth.this.getMirror().localRepo().parent().metaRepo()));
                        session.setIdentityRepository((IdentityRepository)new GitWithAuth.MirrorIdentityRepository(cred.username() + '@' + host.getHostName(), cred));
                    }
                    catch (MirrorException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new MirrorException(e);
                    }
                }
            });
        });
    }

    @Override
    public <T extends TransportCommand<?, ?>> void configureSsh(T cmd, final PasswordMirrorCredential cred) {
        cmd.setTransportConfigCallback(transport -> {
            SshTransport sshTransport = (SshTransport)transport;
            sshTransport.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host host, Session session) {
                    try {
                        session.setHostKeyRepository((HostKeyRepository)new GitWithAuth.MirrorHostKeyRepository(Git5WithAuth.this.getMirror().localRepo().parent().metaRepo()));
                        session.setPassword(cred.password());
                    }
                    catch (MirrorException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new MirrorException(e);
                    }
                }
            });
        });
    }
}

