/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.server.MirrorException;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.mirror.AbstractMirror;
import com.linecorp.centraldogma.server.internal.mirror.Git5WithAuth;
import com.linecorp.centraldogma.server.internal.mirror.GitWithAuth;
import com.linecorp.centraldogma.server.internal.mirror.MirrorState;
import com.linecorp.centraldogma.server.internal.mirror.credential.PasswordMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.PublicKeyMirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.storage.StorageException;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteSetUrlCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitMirror
extends AbstractMirror {
    private static final Logger logger = LoggerFactory.getLogger(GitMirror.class);
    private static final String MIRROR_STATE_FILE_NAME = "mirror_state.json";
    private static final String LOCAL_TO_REMOTE_MIRROR_STATE_FILE_NAME = ".mirror_state.json";
    private static final Pattern CR = Pattern.compile("\r", 16);
    private static final byte[] EMPTY_BYTE = new byte[0];
    private static final Pattern DISALLOWED_CHARS = Pattern.compile("[^-_a-zA-Z]");
    private static final Pattern CONSECUTIVE_UNDERSCORES = Pattern.compile("_+");
    private static final int GIT_TIMEOUT_SECS = 60;
    private static final String HEAD_REF_MASTER = "refs/heads/master";
    @Nullable
    private static final Constructor<?> GIT_WITH_AUTH_CONSTRUCTOR;
    @Nullable
    private IgnoreNode ignoreNode;

    public GitMirror(Cron schedule, MirrorDirection direction, MirrorCredential credential, Repository localRepo, String localPath, URI remoteRepoUri, String remotePath, @Nullable String remoteBranch, @Nullable String gitignore) {
        super(schedule, direction, credential, localRepo, localPath, remoteRepoUri, remotePath, remoteBranch, gitignore);
        if (gitignore != null) {
            this.ignoreNode = new IgnoreNode();
            try {
                this.ignoreNode.parse((InputStream)new ByteArrayInputStream(gitignore.getBytes()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read gitignore: " + gitignore, e);
            }
        }
    }

    @Override
    protected void mirrorLocalToRemote(File workDir, int maxNumFiles, long maxNumBytes) throws Exception {
        try (GitWithAuth git = this.openGit(workDir);){
            String headBranchRefName = this.getHeadBranchRefName(git);
            ObjectId headCommitId = GitMirror.fetchRemoteHeadAndGetCommitId(git, headBranchRefName);
            org.eclipse.jgit.lib.Repository gitRepository = git.getRepository();
            try (ObjectReader reader = gitRepository.newObjectReader();
                 TreeWalk treeWalk = new TreeWalk(reader);
                 RevWalk revWalk = new RevWalk(reader);){
                ObjectId headTreeId = revWalk.parseTree((AnyObjectId)headCommitId).getId();
                treeWalk.reset((AnyObjectId)headTreeId);
                String mirrorStatePath = this.remotePath() + LOCAL_TO_REMOTE_MIRROR_STATE_FILE_NAME;
                Revision localHead = this.localRepo().normalizeNow(Revision.HEAD);
                Revision remoteCurrentRevision = this.remoteCurrentRevision(reader, treeWalk, mirrorStatePath);
                if (localHead.equals((Object)remoteCurrentRevision)) {
                    logger.debug("The remote repository '{}#{}' already at {}. Local repository: '{}'", new Object[]{this.remoteRepoUri(), this.remoteBranch(), localHead, this.localRepo().name()});
                    return;
                }
                treeWalk.reset((AnyObjectId)headTreeId);
                DirCache dirCache = DirCache.newInCore();
                DirCacheBuilder builder = dirCache.builder();
                builder.addTree(EMPTY_BYTE, 0, reader, (AnyObjectId)headTreeId);
                builder.finish();
                try (ObjectInserter inserter = gitRepository.newObjectInserter();){
                    this.addModifiedEntryToCache(localHead, dirCache, reader, inserter, treeWalk, maxNumFiles, maxNumBytes);
                    MirrorState mirrorState = new MirrorState(localHead.text());
                    GitMirror.applyPathEdit(dirCache, new InsertText(mirrorStatePath.substring(1), inserter, Jackson.writeValueAsPrettyString((Object)mirrorState) + '\n'));
                }
                ObjectId nextCommitId = this.commit(gitRepository, dirCache, headCommitId, localHead);
                GitMirror.updateRef(gitRepository, revWalk, headBranchRefName, nextCommitId);
                ((PushCommand)git.push().setRefSpecs(new RefSpec[]{new RefSpec(headBranchRefName)}).setAtomic(true).setTimeout(60)).call();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void mirrorRemoteToLocal(File workDir, CommandExecutor executor, int maxNumFiles, long maxNumBytes) throws Exception {
        HashMap<String, Change> changes = new HashMap<String, Change>();
        try (GitWithAuth git = this.openGit(workDir);){
            String detail;
            String summary;
            String headBranchRefName = this.getHeadBranchRefName(git);
            ObjectId id = GitMirror.fetchRemoteHeadAndGetCommitId(git, headBranchRefName);
            Revision localRev = this.localRepo().normalizeNow(Revision.HEAD);
            try (ObjectReader reader = git.getRepository().newObjectReader();
                 TreeWalk treeWalk = new TreeWalk(reader);
                 RevWalk revWalk = new RevWalk(reader);){
                treeWalk.addTree((AnyObjectId)revWalk.parseTree((AnyObjectId)id).getId());
                String mirrorStatePath = this.localPath() + MIRROR_STATE_FILE_NAME;
                Entry<?> mirrorState = this.localRepo().getOrNull(localRev, mirrorStatePath).join();
                String localSourceRevision = mirrorState == null || mirrorState.type() != EntryType.JSON ? null : ((MirrorState)Jackson.treeToValue((TreeNode)((TreeNode)mirrorState.content()), MirrorState.class)).sourceRevision();
                String abbrId = reader.abbreviate((AnyObjectId)id).name();
                if (id.name().equals(localSourceRevision)) {
                    logger.info("Repository '{}' already at {}, {}#{}", new Object[]{this.localRepo().name(), abbrId, this.remoteRepoUri(), this.remoteBranch()});
                    return;
                }
                changes.put(mirrorStatePath, Change.ofJsonUpsert((String)mirrorStatePath, (String)("{ \"sourceRevision\": \"" + id.name() + "\" }")));
                summary = "Mirror " + abbrId + ", " + this.remoteRepoUri() + '#' + this.remoteBranch() + " to the repository '" + this.localRepo().name() + '\'';
                RevCommit headCommit = revWalk.parseCommit((AnyObjectId)id);
                detail = GitMirror.generateCommitDetail(headCommit);
                logger.info(summary);
                long numFiles = 0L;
                long numBytes = 0L;
                block36: while (treeWalk.next()) {
                    String localPath;
                    FileMode fileMode = treeWalk.getFileMode();
                    String path2 = '/' + treeWalk.getPathString();
                    if (this.ignoreNode != null && path2.startsWith(this.remotePath()) && this.ignoreNode.isIgnored('/' + path2.substring(this.remotePath().length()), fileMode == FileMode.TREE) == IgnoreNode.MatchResult.IGNORED) continue;
                    if (fileMode == FileMode.TREE) {
                        GitMirror.maybeEnterSubtree(treeWalk, this.remotePath(), path2);
                        continue;
                    }
                    if (fileMode != FileMode.REGULAR_FILE && fileMode != FileMode.EXECUTABLE_FILE || !path2.startsWith(this.remotePath()) || !Util.isValidFilePath((String)(localPath = this.localPath() + path2.substring(this.remotePath().length())))) continue;
                    if (++numFiles > (long)maxNumFiles) {
                        this.throwMirrorException(maxNumFiles, "files");
                        return;
                    }
                    ObjectId objectId = treeWalk.getObjectId(0);
                    long contentLength = reader.getObjectSize((AnyObjectId)objectId, -1);
                    if (numBytes > maxNumBytes - contentLength) {
                        this.throwMirrorException(maxNumBytes, "bytes");
                        return;
                    }
                    numBytes += contentLength;
                    byte[] content = reader.open((AnyObjectId)objectId).getBytes();
                    switch (EntryType.guessFromPath((String)localPath)) {
                        case JSON: {
                            JsonNode jsonNode = Jackson.readTree((byte[])content);
                            changes.putIfAbsent(localPath, Change.ofJsonUpsert((String)localPath, (JsonNode)jsonNode));
                            break;
                        }
                        case TEXT: {
                            String strVal = new String(content, StandardCharsets.UTF_8);
                            changes.putIfAbsent(localPath, Change.ofTextUpsert((String)localPath, (String)strVal));
                            continue block36;
                        }
                    }
                }
            }
            Map<String, Entry<?>> oldEntries = this.localRepo().find(localRev, this.localPath() + "**", FindOptions.FIND_ALL_WITHOUT_CONTENT).join();
            oldEntries.keySet().removeAll(changes.keySet());
            oldEntries.forEach((path, entry) -> {
                if (entry.type() != EntryType.DIRECTORY && !changes.containsKey(path)) {
                    changes.put((String)path, Change.ofRemoval((String)path));
                }
            });
            executor.execute(Command.push(MIRROR_AUTHOR, this.localRepo().parent().name(), this.localRepo().name(), Revision.HEAD, summary, detail, Markup.PLAINTEXT, changes.values())).join();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GitWithAuth openGit(File workDir) throws Exception {
        String jGitUri;
        String scheme = this.remoteRepoUri().getScheme();
        if (scheme.startsWith("git+")) {
            if (scheme.equals("git+ssh")) {
                String username = this.credential() instanceof PasswordMirrorCredential ? ((PasswordMirrorCredential)this.credential()).username() : (this.credential() instanceof PublicKeyMirrorCredential ? ((PublicKeyMirrorCredential)this.credential()).username() : null);
                assert (!this.remoteRepoUri().getRawAuthority().contains("@")) : this.remoteRepoUri().getRawAuthority();
                jGitUri = username != null ? "ssh://" + username + '@' + this.remoteRepoUri().getRawAuthority() + this.remoteRepoUri().getRawPath() : "ssh://" + this.remoteRepoUri().getRawAuthority() + this.remoteRepoUri().getRawPath();
            } else {
                jGitUri = this.remoteRepoUri().toASCIIString().substring(4);
            }
        } else {
            jGitUri = this.remoteRepoUri().toASCIIString();
        }
        File repoDir = new File(workDir, CONSECUTIVE_UNDERSCORES.matcher(DISALLOWED_CHARS.matcher(this.remoteRepoUri().toASCIIString()).replaceAll("_")).replaceAll("_"));
        GitWithAuth git = GIT_WITH_AUTH_CONSTRUCTOR != null ? (GitWithAuth)((Object)GIT_WITH_AUTH_CONSTRUCTOR.newInstance(this, repoDir)) : new Git5WithAuth(this, repoDir);
        boolean success = false;
        try {
            URIish uri = new URIish(jGitUri);
            RemoteSetUrlCommand remoteSetUrl = git.remoteSetUrl();
            remoteSetUrl.setRemoteName("origin");
            remoteSetUrl.setRemoteUri(uri);
            remoteSetUrl.setUriType(RemoteSetUrlCommand.UriType.FETCH);
            remoteSetUrl.call();
            remoteSetUrl.setUriType(RemoteSetUrlCommand.UriType.PUSH);
            remoteSetUrl.call();
            success = true;
            GitWithAuth gitWithAuth = git;
            return gitWithAuth;
        }
        finally {
            if (!success) {
                git.close();
            }
        }
    }

    private String getHeadBranchRefName(GitWithAuth git) throws GitAPIException {
        if (this.remoteBranch() != null) {
            return "refs/heads/" + this.remoteBranch();
        }
        Collection refs = ((LsRemoteCommand)git.lsRemote().setTags(false).setTimeout(60)).call();
        Optional<String> headRefName = refs.stream().filter(ref -> "HEAD".equals(ref.getName())).map(ref -> ref.getTarget().getName()).findFirst();
        if (headRefName.isPresent()) {
            return headRefName.get();
        }
        return HEAD_REF_MASTER;
    }

    private static String generateCommitDetail(RevCommit headCommit) {
        PersonIdent authorIdent = headCommit.getAuthorIdent();
        return "Remote commit:\n- SHA: " + headCommit.name() + '\n' + "- Subject: " + headCommit.getShortMessage() + '\n' + "- Author: " + authorIdent.getName() + " <" + authorIdent.getEmailAddress() + "> \n- Date: " + authorIdent.getWhen() + "\n\n" + headCommit.getFullMessage();
    }

    @Nullable
    private Revision remoteCurrentRevision(ObjectReader reader, TreeWalk treeWalk, String mirrorStatePath) {
        try {
            while (treeWalk.next()) {
                FileMode fileMode = treeWalk.getFileMode();
                String path = '/' + treeWalk.getPathString();
                if (fileMode == FileMode.TREE) {
                    if (!this.remotePath().startsWith(path + '/')) continue;
                    treeWalk.enterSubtree();
                    continue;
                }
                if (!path.equals(mirrorStatePath)) continue;
                byte[] content = GitMirror.currentEntryContent(reader, treeWalk);
                MirrorState mirrorState = (MirrorState)Jackson.readValue((byte[])content, MirrorState.class);
                return new Revision(mirrorState.sourceRevision());
            }
            return null;
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while retrieving the remote source revision", (Throwable)e);
            return null;
        }
    }

    private static ObjectId fetchRemoteHeadAndGetCommitId(GitWithAuth git, String headBranchRefName) throws GitAPIException, IOException {
        FetchCommand fetch = git.fetch(1);
        FetchResult fetchResult = ((FetchCommand)fetch.setRefSpecs(new RefSpec[]{new RefSpec(headBranchRefName)}).setRemoveDeletedRefs(true).setTagOpt(TagOpt.NO_TAGS).setTimeout(60)).call();
        ObjectId commitId = fetchResult.getAdvertisedRef(headBranchRefName).getObjectId();
        RefUpdate refUpdate = git.getRepository().updateRef(headBranchRefName);
        refUpdate.setNewObjectId((AnyObjectId)commitId);
        refUpdate.setForceUpdate(true);
        refUpdate.update();
        return commitId;
    }

    private Map<String, Entry<?>> localHeadEntries(Revision localHead) {
        Map<String, Entry<?>> localRawHeadEntries = this.localRepo().find(localHead, this.localPath() + "**").join();
        Stream entryStream = localRawHeadEntries.entrySet().stream();
        if (this.ignoreNode == null) {
            return entryStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        Map sortedMap = entryStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
        HashMap result = new HashMap(sortedMap.size());
        String lastIgnoredDirectory = null;
        for (Map.Entry entry : sortedMap.entrySet()) {
            String path = (String)entry.getKey();
            boolean isDirectory = ((Entry)entry.getValue()).type() == EntryType.DIRECTORY;
            IgnoreNode.MatchResult ignoreResult = this.ignoreNode.isIgnored(path.substring(this.localPath().length()), isDirectory);
            if (ignoreResult == IgnoreNode.MatchResult.IGNORED) {
                if (!isDirectory) continue;
                lastIgnoredDirectory = path;
                continue;
            }
            if (ignoreResult == IgnoreNode.MatchResult.CHECK_PARENT && lastIgnoredDirectory != null && path.startsWith(lastIgnoredDirectory)) continue;
            result.put(path, (Entry)entry.getValue());
        }
        return result;
    }

    private void addModifiedEntryToCache(Revision localHead, DirCache dirCache, ObjectReader reader, ObjectInserter inserter, TreeWalk treeWalk, int maxNumFiles, long maxNumBytes) throws IOException {
        Map<String, Entry<?>> localHeadEntries = this.localHeadEntries(localHead);
        long numFiles = 0L;
        long numBytes = 0L;
        while (treeWalk.next()) {
            String localFilePath;
            FileMode fileMode = treeWalk.getFileMode();
            String pathString = treeWalk.getPathString();
            String remoteFilePath = '/' + pathString;
            if (fileMode == FileMode.TREE) {
                GitMirror.maybeEnterSubtree(treeWalk, this.remotePath(), remoteFilePath);
                continue;
            }
            if (fileMode != FileMode.REGULAR_FILE && fileMode != FileMode.EXECUTABLE_FILE || !remoteFilePath.startsWith(this.remotePath()) || !Util.isValidFilePath((String)(localFilePath = this.localPath() + remoteFilePath.substring(this.remotePath().length())))) continue;
            Entry<?> entry = localHeadEntries.remove(localFilePath);
            if (entry == null) {
                GitMirror.applyPathEdit(dirCache, (DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(pathString));
                continue;
            }
            if (++numFiles > (long)maxNumFiles) {
                this.throwMirrorException(maxNumFiles, "files");
                return;
            }
            byte[] oldContent = GitMirror.currentEntryContent(reader, treeWalk);
            long contentLength = GitMirror.applyPathEdit(dirCache, inserter, pathString, entry, oldContent);
            if ((numBytes += contentLength) <= maxNumBytes) continue;
            this.throwMirrorException(maxNumBytes, "bytes");
            return;
        }
        for (Map.Entry<String, Entry<?>> entry : localHeadEntries.entrySet()) {
            Entry<?> value = entry.getValue();
            if (value.type() == EntryType.DIRECTORY || entry.getKey().endsWith(MIRROR_STATE_FILE_NAME)) continue;
            if (++numFiles > (long)maxNumFiles) {
                this.throwMirrorException(maxNumFiles, "files");
                return;
            }
            String convertedPath = this.remotePath().substring(1) + entry.getKey().substring(this.localPath().length());
            long contentLength = GitMirror.applyPathEdit(dirCache, inserter, convertedPath, value, null);
            if ((numBytes += contentLength) <= maxNumBytes) continue;
            this.throwMirrorException(maxNumBytes, "bytes");
        }
    }

    private static long applyPathEdit(DirCache dirCache, ObjectInserter inserter, String pathString, Entry<?> entry, @Nullable byte[] oldContent) throws JsonProcessingException {
        switch (EntryType.guessFromPath((String)pathString)) {
            case JSON: {
                JsonNode oldJsonNode = oldContent != null ? Jackson.readTree((byte[])oldContent) : null;
                JsonNode newJsonNode = (JsonNode)entry.content();
                if (Objects.equals(newJsonNode, oldJsonNode)) break;
                String newContent = newJsonNode.toPrettyString() + '\n';
                GitMirror.applyPathEdit(dirCache, new InsertText(pathString, inserter, newContent));
                return newContent.length();
            }
            case TEXT: {
                String sanitizedOldText = oldContent != null ? GitMirror.sanitizeText(new String(oldContent, StandardCharsets.UTF_8)) : null;
                String sanitizedNewText = entry.contentAsText();
                if (sanitizedNewText.equals(sanitizedOldText)) break;
                GitMirror.applyPathEdit(dirCache, new InsertText(pathString, inserter, sanitizedNewText));
                return sanitizedNewText.length();
            }
        }
        return 0L;
    }

    private static void applyPathEdit(DirCache dirCache, DirCacheEditor.PathEdit edit) {
        DirCacheEditor e = dirCache.editor();
        e.add(edit);
        e.finish();
    }

    private static byte[] currentEntryContent(ObjectReader reader, TreeWalk treeWalk) throws IOException {
        ObjectId objectId = treeWalk.getObjectId(0);
        return reader.open((AnyObjectId)objectId).getBytes();
    }

    private static void maybeEnterSubtree(TreeWalk treeWalk, String remotePath, String path) throws IOException {
        if (path.startsWith(remotePath)) {
            treeWalk.enterSubtree();
            return;
        }
        int pathLen = path.length() + 1;
        if (pathLen == remotePath.length() && remotePath.startsWith(path)) {
            treeWalk.enterSubtree();
            return;
        }
        if (pathLen < remotePath.length() && remotePath.startsWith(path + '/')) {
            treeWalk.enterSubtree();
        }
    }

    private static String sanitizeText(String text) {
        if (text.indexOf(13) >= 0) {
            text = CR.matcher(text).replaceAll("");
        }
        if (!text.isEmpty() && !text.endsWith("\n")) {
            text = text + "\n";
        }
        return text;
    }

    private ObjectId commit(org.eclipse.jgit.lib.Repository gitRepository, DirCache dirCache, ObjectId headCommitId, Revision localHead) throws IOException {
        try (ObjectInserter inserter = gitRepository.newObjectInserter();){
            ObjectId nextTreeId = dirCache.writeTree(inserter);
            PersonIdent personIdent = new PersonIdent(MIRROR_AUTHOR.name(), MIRROR_AUTHOR.email(), System.currentTimeMillis() / 1000L * 1000L, 0);
            CommitBuilder commitBuilder = new CommitBuilder();
            commitBuilder.setAuthor(personIdent);
            commitBuilder.setCommitter(personIdent);
            commitBuilder.setTreeId((AnyObjectId)nextTreeId);
            commitBuilder.setEncoding(StandardCharsets.UTF_8);
            commitBuilder.setParentId((AnyObjectId)headCommitId);
            String summary = "Mirror '" + this.localRepo().name() + "' at " + localHead + " to the repository '" + this.remoteRepoUri() + '#' + this.remoteBranch() + "'\n";
            logger.info(summary);
            commitBuilder.setMessage(summary);
            ObjectId nextCommitId = inserter.insert(commitBuilder);
            inserter.flush();
            ObjectId objectId = nextCommitId;
            return objectId;
        }
    }

    private <T> T throwMirrorException(long number, String filesOrBytes) {
        throw new MirrorException("mirror (" + this.remoteRepoUri() + '#' + this.remoteBranch() + ") contains more than " + number + ' ' + filesOrBytes);
    }

    static void updateRef(org.eclipse.jgit.lib.Repository jGitRepository, RevWalk revWalk, String ref, ObjectId commitId) throws IOException {
        RefUpdate refUpdate = jGitRepository.updateRef(ref);
        refUpdate.setNewObjectId((AnyObjectId)commitId);
        RefUpdate.Result res = refUpdate.update(revWalk);
        switch (res) {
            case NEW: 
            case FAST_FORWARD: {
                break;
            }
            default: {
                throw new StorageException("unexpected refUpdate state: " + res);
            }
        }
    }

    static {
        Constructor<?> constr = null;
        try {
            constr = Class.forName("com.linecorp.centraldogma.server.internal.mirror.Git6WithAuth").getDeclaredConstructor(GitMirror.class, File.class);
        }
        catch (Exception e) {
            logger.info("Falling back to JGit 5:", (Throwable)e);
        }
        GIT_WITH_AUTH_CONSTRUCTOR = constr;
    }

    private static final class InsertText
    extends DirCacheEditor.PathEdit {
        private final ObjectInserter inserter;
        private final String text;

        InsertText(String entryPath, ObjectInserter inserter, String text) {
            super(entryPath);
            this.inserter = inserter;
            this.text = text;
        }

        public void apply(DirCacheEntry ent) {
            try {
                ent.setObjectId((AnyObjectId)this.inserter.insert(3, this.text.getBytes(StandardCharsets.UTF_8)));
                ent.setFileMode(FileMode.REGULAR_FILE);
            }
            catch (IOException e) {
                throw new StorageException("failed to create a new text blob", e);
            }
        }
    }
}

