/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.UserInfo;
import com.linecorp.centraldogma.server.MirrorException;
import com.linecorp.centraldogma.server.internal.IsolatedSystemReader;
import com.linecorp.centraldogma.server.internal.mirror.GitMirror;
import com.linecorp.centraldogma.server.internal.mirror.credential.AccessTokenMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.PasswordMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.PublicKeyMirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.storage.repository.MetaRepository;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.GarbageCollectCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.lib.EmptyProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GitWithAuth
extends Git {
    private static final Logger logger = LoggerFactory.getLogger(GitWithAuth.class);
    private static final Lock[] locks = new Lock[1024];
    private final GitMirror mirror;
    private final Lock lock;
    private final Map<String, ProgressMonitor> progressMonitors = new HashMap<String, ProgressMonitor>();

    private static Lock getLock(File repoDir) {
        int h = repoDir.getPath().hashCode();
        return locks[Math.abs((h ^ h >>> 16) % locks.length)];
    }

    GitWithAuth(GitMirror mirror, File repoDir) throws IOException {
        super(GitWithAuth.repo(repoDir));
        this.mirror = mirror;
        this.lock = GitWithAuth.getLock(repoDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Repository repo(File repoDir) throws IOException {
        Lock lock = GitWithAuth.getLock(repoDir);
        boolean success = false;
        lock.lock();
        try {
            repoDir.getParentFile().mkdirs();
            Repository repo = ((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).setBare()).build();
            if (!repo.getObjectDatabase().exists()) {
                repo.create(true);
            }
            success = true;
            Repository repository = repo;
            return repository;
        }
        finally {
            if (!success) {
                lock.unlock();
            }
        }
    }

    public final void close() {
        try {
            super.close();
        }
        finally {
            try {
                this.getRepository().close();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected final ProgressMonitor progressMonitor(String name) {
        return this.progressMonitors.computeIfAbsent(name, x$0 -> new MirrorProgressMonitor((String)x$0));
    }

    public final FetchCommand fetch() {
        return this.configure(super.fetch()).setProgressMonitor(this.progressMonitor("fetch"));
    }

    abstract FetchCommand fetch(int var1);

    public final PushCommand push() {
        return this.configure(super.push()).setProgressMonitor(this.progressMonitor("push"));
    }

    public final GarbageCollectCommand gc() {
        return super.gc().setProgressMonitor(this.progressMonitor("gc"));
    }

    public final LsRemoteCommand lsRemote() {
        return this.configure(super.lsRemote());
    }

    private <T extends TransportCommand<?, ?>> T configure(T command) {
        MirrorCredential c = this.mirror.credential();
        switch (this.mirror.remoteRepoUri().getScheme()) {
            case "git+http": 
            case "git+https": {
                if (c instanceof PasswordMirrorCredential) {
                    GitWithAuth.configureHttp(command, (PasswordMirrorCredential)c);
                    break;
                }
                if (!(c instanceof AccessTokenMirrorCredential)) break;
                GitWithAuth.configureHttp(command, (AccessTokenMirrorCredential)c);
                break;
            }
            case "git+ssh": {
                if (c instanceof PasswordMirrorCredential) {
                    this.configureSsh(command, (PasswordMirrorCredential)c);
                    break;
                }
                if (!(c instanceof PublicKeyMirrorCredential)) break;
                this.configureSsh(command, (PublicKeyMirrorCredential)c);
            }
        }
        return command;
    }

    abstract <T extends TransportCommand<?, ?>> void configureSsh(T var1, PublicKeyMirrorCredential var2);

    abstract <T extends TransportCommand<?, ?>> void configureSsh(T var1, PasswordMirrorCredential var2);

    private static <T extends TransportCommand<?, ?>> void configureHttp(T cmd, PasswordMirrorCredential cred) {
        cmd.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(cred.username(), cred.password()));
    }

    private static <T extends TransportCommand<?, ?>> void configureHttp(T cmd, AccessTokenMirrorCredential cred) {
        cmd.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider("token", cred.accessToken()));
    }

    protected final GitMirror getMirror() {
        return this.mirror;
    }

    static {
        IsolatedSystemReader.install();
        for (int i = 0; i < locks.length; ++i) {
            GitWithAuth.locks[i] = new ReentrantLock();
        }
    }

    private final class MirrorProgressMonitor
    extends EmptyProgressMonitor {
        private final String operationName;

        MirrorProgressMonitor(String operationName) {
            this.operationName = Objects.requireNonNull(operationName, "operationName");
        }

        public void beginTask(String title, int totalWork) {
            if (totalWork > 0 && logger.isInfoEnabled()) {
                logger.info("[{}] {} ({}, total: {})", new Object[]{this.operationName, GitWithAuth.this.mirror.remoteRepoUri(), title, totalWork});
            }
        }
    }

    protected static final class MirrorIdentityRepository
    implements IdentityRepository {
        private final Identity identity;

        MirrorIdentityRepository(final String name, PublicKeyMirrorCredential cred) throws JSchException {
            final KeyPair keyPair = KeyPair.load((JSch)new JSch(), (byte[])cred.privateKey(), (byte[])cred.publicKey());
            Buffer buf = new Buffer(keyPair.getPublicKeyBlob());
            final String algName = new String(buf.getString(), StandardCharsets.US_ASCII);
            if (!keyPair.decrypt(cred.passphrase())) {
                throw new MirrorException("cannot decrypt the private key with the given passphrase");
            }
            this.identity = new Identity(){

                public String getName() {
                    return name;
                }

                public String getAlgName() {
                    return algName;
                }

                public byte[] getPublicKeyBlob() {
                    return keyPair.getPublicKeyBlob();
                }

                public byte[] getSignature(byte[] data) {
                    return keyPair.getSignature(data);
                }

                public boolean setPassphrase(byte[] passphrase) {
                    return keyPair.decrypt(passphrase);
                }

                public boolean isEncrypted() {
                    return keyPair.isEncrypted();
                }

                @Deprecated
                public boolean decrypt() {
                    throw new UnsupportedOperationException();
                }

                public void clear() {
                    keyPair.dispose();
                }
            };
        }

        public String getName() {
            return this.getClass().getSimpleName();
        }

        public int getStatus() {
            return 2;
        }

        public Vector<Identity> getIdentities() {
            Vector<Identity> identities = new Vector<Identity>();
            identities.add(this.identity);
            return identities;
        }

        public boolean add(byte[] identity) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(byte[] blob) {
            throw new UnsupportedOperationException();
        }

        public void removeAll() {
            throw new UnsupportedOperationException();
        }
    }

    protected static final class MirrorHostKeyRepository
    implements HostKeyRepository {
        private static final HostKey[] EMPTY_HOST_KEYS = new HostKey[0];

        MirrorHostKeyRepository(MetaRepository metaRepo) {
        }

        public int check(String host, byte[] key) {
            return 0;
        }

        public void add(HostKey hostkey, UserInfo ui) {
        }

        public void remove(String host, String type) {
        }

        public void remove(String host, String type, byte[] key) {
        }

        public String getKnownHostsRepositoryID() {
            return this.getClass().getSimpleName();
        }

        public HostKey[] getHostKey() {
            throw new UnsupportedOperationException();
        }

        public HostKey[] getHostKey(String host, String type) {
            return EMPTY_HOST_KEYS;
        }
    }
}

