/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.storage.StorageException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;

final class CommitUtil {
    private static final String FIELD_NAME_SUMMARY = "summary";
    private static final String FIELD_NAME_DETAIL = "detail";
    private static final String FIELD_NAME_MARKUP = "markup";
    private static final String FIELD_NAME_REVISION = "revision";

    static String toJsonString(String summary, String detail, Markup markup, Revision nextRevision) {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonGenerator jsonGenerator = Jackson.createPrettyGenerator((Writer)stringWriter);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(FIELD_NAME_SUMMARY, summary);
            jsonGenerator.writeStringField(FIELD_NAME_DETAIL, detail);
            jsonGenerator.writeStringField(FIELD_NAME_MARKUP, markup.nameLowercased());
            jsonGenerator.writeStringField(FIELD_NAME_REVISION, nextRevision.text());
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new StorageException("failed to generate a JSON string", e);
        }
    }

    static Revision extractRevision(String jsonString) {
        try {
            JsonNode jsonNode = Jackson.readTree((String)jsonString);
            return new Revision(Jackson.textValue((JsonNode)jsonNode.get(FIELD_NAME_REVISION), (String)""));
        }
        catch (Exception e) {
            throw new StorageException("failed to extract revision from " + jsonString, e);
        }
    }

    static Commit newCommit(Author author, long when, String jsonString) {
        Objects.requireNonNull(author, "author");
        when = when / 1000L * 1000L;
        try {
            Markup markup;
            JsonNode jsonNode = Jackson.readTree((String)jsonString);
            String summary = Jackson.textValue((JsonNode)jsonNode.get(FIELD_NAME_SUMMARY), (String)"");
            String detail = Jackson.textValue((JsonNode)jsonNode.get(FIELD_NAME_DETAIL), (String)"");
            switch (Jackson.textValue((JsonNode)jsonNode.get(FIELD_NAME_MARKUP), (String)"")) {
                case "plaintext": {
                    markup = Markup.PLAINTEXT;
                    break;
                }
                case "markdown": {
                    markup = Markup.MARKDOWN;
                    break;
                }
                default: {
                    markup = Markup.UNKNOWN;
                }
            }
            Revision revision = new Revision(Jackson.textValue((JsonNode)jsonNode.get(FIELD_NAME_REVISION), (String)""));
            return new Commit(revision, author, when, summary, detail, markup);
        }
        catch (Exception e) {
            throw new StorageException("failed to create a Commit", e);
        }
    }

    private CommitUtil() {
    }
}

