/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class AbstractService {
    private final ProjectManager projectManager;
    private final CommandExecutor executor;

    protected AbstractService(ProjectManager projectManager, CommandExecutor executor) {
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    public final ProjectManager projectManager() {
        return this.projectManager;
    }

    public final CommandExecutor executor() {
        return this.executor;
    }

    public <T> CompletableFuture<T> execute(Command<T> command) {
        return this.executor().execute(command);
    }
}

