/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.internal.storage.PurgeSchedulingService;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.plugin.Plugin;
import com.linecorp.centraldogma.server.plugin.PluginContext;
import com.linecorp.centraldogma.server.plugin.PluginTarget;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;

public final class PurgeSchedulingServicePlugin
implements Plugin {
    @Nullable
    private volatile PurgeSchedulingService purgeSchedulingService;

    @Override
    public PluginTarget target() {
        return PluginTarget.LEADER_ONLY;
    }

    @Override
    public synchronized CompletionStage<Void> start(PluginContext context) {
        Objects.requireNonNull(context, "context");
        PurgeSchedulingService purgeSchedulingService = this.purgeSchedulingService;
        if (purgeSchedulingService == null) {
            CentralDogmaConfig cfg = context.config();
            this.purgeSchedulingService = purgeSchedulingService = new PurgeSchedulingService(context.projectManager(), context.purgeWorker(), cfg.maxRemovedRepositoryAgeMillis());
        }
        MetadataService metadataService = new MetadataService(context.projectManager(), context.commandExecutor());
        purgeSchedulingService.start(context.commandExecutor(), metadataService);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletionStage<Void> stop(PluginContext context) {
        PurgeSchedulingService purgeSchedulingService = this.purgeSchedulingService;
        if (purgeSchedulingService != null && purgeSchedulingService.isStarted()) {
            purgeSchedulingService.stop();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isEnabled(CentralDogmaConfig config) {
        return Objects.requireNonNull(config, "config").maxRemovedRepositoryAgeMillis() > 0L;
    }

    @Nullable
    public PurgeSchedulingService scheduledPurgingService() {
        return this.purgeSchedulingService;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("target", (Object)this.target()).add("purgeSchedulingService", (Object)this.purgeSchedulingService).toString();
    }
}

